/*
  Copyright (c) 2005 Novell, Inc. All Rights Reserved.

  Novell grants permission, free of charge, to any person obtaining copies
  of this software and its associated documentation files (the "Software"),
  to deal in the Software without restriction, including to use, copy, adapt, 
  publish, distribute, display, perform, sublicense, and sell copies of the 
  Software, subject to the following condition: You must include the above 
  copyright notice and this permission notice in all full or partial copies 
  of the Software.

  NOVELL PROVIDES THE SOFTWARE "AS IS," WITHOUT ANY EXPRESS OR IMPLIED WARRANTY,
  INCLUDING WITHOUT THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  PARTICULAR PURPOSE, AND NON-INFRINGMENT.  NOVELL, THE AUTHORS OF THE SOFTWARE,
  AND THE OWNERS OF COPYRIGHT IN THE SOFTWARE ARE NOT LIABLE FOR ANY CLAIM, DAMAGES,
  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT, OR OTHERWISE, ARISING
  FROM, OUT OF, OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
*/

package com.novell.nxpe;


/**
 * Defines the interface that you need to extend.
 * <p> It contains the methods required to implement a deny, permit, or
 * obligation action. </p>
 *
 * @author Paladin Team <nxpe-dev@forge.provo.novell.com>
 * @since NXPE1.0
 */
public interface NxpeAction
{
    /**
     * Called by the policy engine and therefore must be implemented. It
     * initializes the element and passes to your extenstion any configuration
     * values you have requested.
     *
     * @param configurationValues The object containing requested configuration
     *                             values.
     * @throws NxpeException
     */
    void initialize(
            NxpeParameterList configurationValues)
        throws NxpeException;

    /**
     * Called by the policy engine when the action extension needs to be
     * evaluated for a policy.
     *
     * @param informationCtx The parameter information the extension needs from
     *                         the policy engine to evaluate the condition.
     * @param responseCtx The results of the action.
     *
     * @throws NxpeException
     * @return The result of the action.
     */
    NxpeResult doAction(
            NxpeInformationContext informationCtx, 
            NxpeResponseContext    responseCtx)
        throws NxpeException;

    /**
     * Sets the unique string value for the action. This value is used for
     * tracing the action during policy evaluation.
     * 
     * @param interfaceID The unique string value for the action.
     * @throws NxpeException
     */
    void setInterfaceId(
            String interfaceId)
        throws NxpeException;

} /* NxpeAction */

