/*
  Copyright (c) 2005-2008 Novell, Inc. All Rights Reserved.

  Novell grants permission, free of charge, to any person obtaining copies
  of this software and its associated documentation files (the "Software"),
  to deal in the Software without restriction, including to use, copy, adapt, 
  publish, distribute, display, perform, sublicense, and sell copies of the 
  Software, subject to the following condition: You must include the above 
  copyright notice and this permission notice in all full or partial copies 
  of the Software.

  NOVELL PROVIDES THE SOFTWARE "AS IS," WITHOUT ANY EXPRESS OR IMPLIED WARRANTY,
  INCLUDING WITHOUT THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  PARTICULAR PURPOSE, AND NON-INFRINGMENT.  NOVELL, THE AUTHORS OF THE SOFTWARE,
  AND THE OWNERS OF COPYRIGHT IN THE SOFTWARE ARE NOT LIABLE FOR ANY CLAIM, DAMAGES,
  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT, OR OTHERWISE, ARISING
  FROM, OUT OF, OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

package com.novell.nxpe;


/**
 * Defines the methods required to create a context data element that can be
 * used for injection, for activating roles, or in a condition.
 * 
 * @author Paladin Team <nxpe-dev@forge.provo.novell.com>
 * @since NXPE1.0
 */
public interface NxpeContextDataElement
{
    /**
     * Called by the policy engine to initialize a component in preparation 
     * for policy evaluation.
     * 
     *<p>Derived classes are required to override this method.
     *     This method is guaranteed to be called before any other method is 
     *     called, as this is part of object construction.</p>
     * 
     * @param configurationValues The list of configuration data required by 
     *      the extension. This object is only valid during the lifetime of the
     *      initialize method.  If the extension wants to preserver the config
     *      data, it must be copied to the context data element handler.
     * 
     * @throws NxpeException
     */
    void initialize(
            NxpeParameterList configurationValues)
        throws NxpeException;

    /**
     * Retrieves the name of the data element of the policy.
     */
    String getName();

    /**
     * Returns -1. Reserved for future releases.
     */
    int getEnumerativeValue();

    /**
     * Retrieves the string value of the parameter of the policy.
     */
    String getParameter();

    /**
     * Called by the policy engine when a request triggers a policy evaluation.
     *
     * @param informationContext  The parameter values that you need from the
     *                       policy engine in order to perform the evaluation.
     * @param reponseContext The results of the evaluation.
     * @throws NxpeException
     */
    Object getValue(
            NxpeInformationContext informationContext,
            NxpeResponseContext responseContext)
        throws NxpeException;

} /* NxpeContextDataElement */

