﻿// FILE:         _FT_SideNav_Master_Startup.js
// DESCRIPTION:  Populate Feedback form.
// MODIFIED:     July 1, 2020
// VERSION:      FTFS 1.6 
// 
// © Copyright 2017-2020 Micro Focus or one of its affiliates.
//
// The only warranties for products and services of Micro Focus and its affiliates and licensors 
// (“Micro Focus”) are as may be set forth in the express warranty statements accompanying such 
// products and services. Nothing herein should be construed as constituting an additional warranty. 
// Micro Focus shall not be liable for technical or editorial errors or omissions contained herein. 
// The information contained herein is subject to change without notice.

function sendFeedback() {
	
	var feedbackVariables = document.getElementById("ft-feedbackDiv");
	var companyName = feedbackVariables.getAttribute("data-company");
	var productFamily = feedbackVariables.getAttribute("data-product-family");
	var productName = feedbackVariables.getAttribute("data-product-name");
	var productAcronym = feedbackVariables.getAttribute("data-product-acronym");
	var productVersion = feedbackVariables.getAttribute("data-product-version");
	var commentsEmailAddress = feedbackVariables.getAttribute("data-comments-email");
	var firstheading = feedbackVariables.getAttribute("data-topic-title");
	
	//If product name starts with family name, don't add family name to full product name
	if (productName.toLowerCase().match("^" + productFamily.toLowerCase())) {
		var fullProductName = companyName + " " + productName;
	
	} else {  
		//Include family name
		var fullProductName = companyName + " " + productFamily + " " + productName;
	}

	//Check for non-Latin characters in topic title
	if (/[^\u0000-\u00ff]/.test(firstheading))
		firstheading = '';
	
	// Use acronym only if it exists and different than product name
	if ((productAcronym.length > 0) && (productAcronym.toLowerCase() !== productName.toLowerCase())) {
		productAcronym = " (" + productAcronym + ")";
	
	} else {
		productAcronym = "";
	}
	
	var index = 0;
	var delimiter = "";
	var topicURL = encodeURI(document.URL);
	var lowercaseTopicURL = topicURL.toLowerCase();
	
	if (lowercaseTopicURL.search(".chm") != -1) {           // chm file? 
		delimiter = "chm::/";
		index = lowercaseTopicURL.indexOf(delimiter);

	} else if (lowercaseTopicURL.search("content") != -1){	// web-based with Content folder?
		delimiter = "/content/";
		index = lowercaseTopicURL.indexOf(delimiter);

	} else {                                                // web-based with no Content folder?
		delimiter = "/";
		index = lowercaseTopicURL.lastIndexOf(delimiter);
	}
	
	topicURL = topicURL.substring(index + delimiter.length);  
	
	//Strip any query parameters after file name
	index = topicURL.indexOf("?");
	if (index > -1)
		topicURL = topicURL.substring(0, index);
	
	emailBody = document.getElementById('ft-feedbackBody').innerHTML;
	emailBody = emailBody.replace(/<span id="?ft-feedbackProduct"?><\/span>/i, fullProductName);
	emailBody = emailBody.replace(/<span id="?ft-feedbackVersion"?><\/span>/i, productVersion);
	emailBody = emailBody.replace(/<span id="?ft-feedbackTopic"?><\/span>/i, firstheading);
	emailBody = emailBody.replace(/<span id="?ft-feedbackURL"?><\/span>/i, topicURL);
	emailBody = emailBody.replace(/<span id="?ft-feedbackAcronym"?><\/span>/i, productAcronym);
	
	document.getElementById('ft-feedbackBody').innerHTML = emailBody;
			
	emailBody = emailBody.replace(/<br>/gi, "%0D%0A");
	emailBody = emailBody.replace(/&nbsp;/g, " ");
	
	// Localizable
	document.getElementById('ft-feedbackOpen').href = 'mailto:' + commentsEmailAddress + '?subject=Feedback on ' + fullProductName + " " + productVersion + " documentation: " + firstheading + '&body=' + emailBody;
	
	document.getElementById('ft-feedbackDiv').style.display = "block";
}

function closeFeedback()
{
	document.getElementById('ft-feedbackDiv').style.display = "none";
}