﻿#################################################################################### 
# Bulk Import of Organizational Units from CSV 
#################################################################################### 
# Created by Brad Voris 
# Description: Bulk import of Active Directory OUs via Powershell with a CSV file 
#################################################################################### 
# Notes for CSV File 
# First line of CSV file should contain the following in each cell 
# NAME,DistinguishedName 
# 
#################################################################################### 
#################################################################################### 
#Import AD Module RSAT must be installed 
#################################################################################### 
Import-Module ActiveDirectory  
#################################################################################### 
#Varibale location for CSV file 
#################################################################################### 
$ous = Import-Csv -Path ".\AD_OU-Keystone_Steel.csv"   
#################################################################################### 
# Use the current domain
#################################################################################### 
$domainDN = (Get-ADDomain).DistinguishedName
#################################################################################### 
# For each function to create accounts 
#################################################################################### 
foreach ($ou in $ous)   
{   
#################################################################################### 
# Function Variables 
#################################################################################### 
    $ouname = $ou.name   
    $oudn = $ou.DistinguishedName  
     
#################################################################################### 
# Function 
#################################################################################### 
    if ([string]::IsNullOrEmpty($oudn))
    {
       echo "Creating $ouname,$domainDN"
       New-ADOrganizationalUnit -Name $ouname -ProtectedFromAccidentalDeletion $false -Path "$domainDN"  -ManagedBy 'domain admins' 
    }
    else
    {
       echo "Creating $ouname,$oudn,$domainDN"
       New-ADOrganizationalUnit -Name $ouname -ProtectedFromAccidentalDeletion $false -Path "$oudn,$domainDN"  -ManagedBy 'domain admins' 
    }
}
