/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/TokensHaveExpiredException.java $
  $Revision: 7 $
  $Modtime: 10/22/98 10:31a $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

/**@internal
 *
 * Thrown if the authentication tokens have expired.
 *
 * @see LoginException
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0
 */
public class TokensHaveExpiredException extends LoginException
{
   /**
    * The default constructor.
    */
   public TokensHaveExpiredException()
   {
      super(I2L.getString(XMsg.TOKENS_HAVE_EXPIRED));
   }

   /**
    * Constructor with a message.
    *
    * @param message A message associated with the exception.
    */
   public TokensHaveExpiredException(String message)
   {
      super(message);
   }

   /**
    * Constructor with a message and a root cause exception.
    *
    * @param message   A message associated with the exception.
    * @param exception The root cause exception.
    */
   public TokensHaveExpiredException(String message,java.lang.Throwable exception)
   {
      super(message,exception);
   }

   /**
    * Constructor with a root cause exception.
    *
    * @param exception The root cause exception.
    */
   public TokensHaveExpiredException(java.lang.Throwable exception)
   {
      this(I2L.getString(XMsg.TOKENS_HAVE_EXPIRED),exception);
   }
}
