/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/bindery/BinderyEnvironment.java $
  $Revision: 5 $
  $Modtime: 5/04/00 2:27p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.Hashtable;
import java.io.Serializable;

import javax.naming.*;

import com.novell.utility.naming.Environment;

import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;

/**
 * Defines the set of constant Strings that uniquely controls
 * the behavior of the Bindery name provider. It also contains
 * convenience functions for managing the bindery objects.
 *
 * <p>The BinderyEnvironment class extends the Environment class,
 * which provides constants for environment variables associated
 * with Novell JNDI providers.</p>
 * 
 * @see Environment
 */

public class BinderyEnvironment
   extends Environment
   implements Cloneable, Serializable
{
   // JNDI property strings =================================================

  /**
   * The constant for the BinderyDirContext object.
   *
   * <p>(BINDERY = "com.novell.service.bindery.BinderyDirContext")
   */
   public static final String BINDERY = 
               "com.novell.service.bindery.BinderyDirContext";

  /**
   * The constant for the BinderyObjectDirContext object.
   *
   * <p>(BINDERY_OBJECT = 
   *           "com.novell.service.bindery.BinderyObjectDirContext")
   */
   public static final String BINDERY_OBJECT = 
               "com.novell.service.bindery.BinderyObjectDirContext";

  /**
   * The constant for the QueueBinderyObjectDirContext object.
   *
   * <p>(QUEUE_BINDERY_OBJECT = 
   *           "com.novell.service.bindery.QueueBinderyObjectDirContext")
   */
   public static final String QUEUE_BINDERY_OBJECT = 
               "com.novell.service.bindery.QueueBinderyObjectDirContext";

  /**
   * The constant for the ServerBinderyObjectDirContext object.
   *
   * <p>(SERVER_BINDERY_OBJECT = 
   *           "com.novell.service.bindery.serverBinderyObjectDirContext")
   */
   public static final String SERVER_BINDERY_OBJECT = 
               "com.novell.service.bindery.ServerBinderyObjectDirContext";

  /**
   * The constant for the TreeBinderyObjectDirContext object.
   *
   * <p>(TREE_BINDERY_OBJECT = 
   *           "com.novell.service.bindery.treeBinderyObjectDirContext")
   */
   public static final String TREE_BINDERY_OBJECT = 
               "com.novell.service.bindery.TreeBinderyObjectDirContext";

  /**
   * The constant for the BinderyObjectFactory object.
   *
   * <p>(BINDERY_OBJECT_FACTORY = 
   *           "com.novell.service.bindery.BinderyObjectFactory")
   */
   public static final String BINDERY_OBJECT_FACTORY = 
               "com.novell.service.bindery.BinderyObjectFactory";

  /**
   * The constant for the BinderyObjectClassDefContext object.
   *
   * <p>(OBJECT_CLASS_DEF = 
   *           "com.novell.service.bindery.BinderyObjectClassDefContext")
   */
   public static final String OBJECT_CLASS_DEF = 
               "com.novell.service.bindery.BinderyObjectClassDefContext";

  /**
   * The constant for the BinderyObjectClassDefContext object.
   *
   * <p>(SCHEMA_CLASS_DEF = 
   *           "com.novell.service.bindery.BinderySchemaClassDefContext")
   */
   public static final String SCHEMA_CLASS_DEFS = 
               "com.novell.service.bindery.BinderySchemaClassDefsContext";

  /**
   * The constant for the BinderyPropertyAttrVal object.
   *
   * <p>(BINDERY_PROPERTY = 
   *           "com.novell.service.bindery.BinderyPropertyAttrVal")
   */
   public static final String BINDERY_PROPERTY = 
               "com.novell.service.bindery.BinderyPropertyAttrVal";

   // Internal variables =====================================================
   private CallsService callsService = null;
   
   // Constructors ===========================================================

   /**@internal
    *
    */
   public BinderyEnvironment (Hashtable hash)
   {
      super (hash);
   } // BinderyEnvironment ()
   
   /**@internal
    *
    */
   public BinderyEnvironment (Environment env)
      throws NamingException
   {
      super (env);
   } // BinderyEnvironment ()

   // Environment methods ====================================================

   /** @internal
    * Returns the current session used by this context.
    *
    * @return The Session object being used by this context.
    *
    * @exception NamingException When a naming error occurs.
    */
   public Session getSession ()
      throws NamingException
   {
      try
      {
         if (session == null)
         {
            Object obj = environment.get (Environment.SESSION_OBJECT);

            if ((null != obj) && (obj instanceof Session))
            {
               session = (Session) obj;
            }
            else
               throw new SessionException ("Session not found");
         }
         return session;
      }
      catch (SessionException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }
   } // getSession ()
   
   /** @internal
    * Returns the session service (CallsService) for this
    * environment's session.
    *
    * @return  The CallsService for this environment.
    *
    * @exception NamingException When a naming error occurs.
    */
   public CallsService getCallsService()
      throws NamingException
   {
      if (callsService != null)
         return callsService;

      callsService = (CallsService) getService (CallsService.KEY);
      return callsService;
   } // getCallsService ()

}  // class BinderyEnvironment