/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/bindery/IDByteSwap.java $
  $Revision: 6 $
  $Modtime: 5/17/99 2:57p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

/**
 * @internal
 *
 * @deprecated Use com.novell.service.bindery.BinderyUtil
 * This is a utility class which swaps the bytes on a 16-bit integer.
 *
 * <p>This must be done when sending Bindery object types over the wire,
 * because the wire format for type 0x1 is 0x100.  Only the lower 16 bits
 * are swapped, but the parameter and return values are 32-bit Java ints.
 * In the future, this operation should be performed by the native calls.
 * This class exists only for its static method swap, so it has no
 * constructor of its own.
 */

public final class IDByteSwap
{
   /**@internal
    * This private, default constructor insure that this class is a singleton
    * instance.
    */
   private IDByteSwap () {}
   
   /**
    *
    */
   public static int swap (
         int orig)
   {
      int byte1, byte2, swapped;
      
      byte1   = (orig & 0x000000ff) << 8;
      byte2   = (orig & 0x0000ff00) >> 8;
      swapped = (orig & 0xffff0000) | byte1 | byte2;

      return swapped;
   } // swap ()
   
}  // class IDByteSwap
