/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/EAEnumerator.java $
  $Revision: 6 $
  $Modtime: 12/13/99 10:07a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import java.util.Enumeration;

/** 
 * Provides for enumeration of extended attributes of a given file,
 * which can have multiple attributes.
 *
 * <p>This interface declares an enumeration interface for obtaining
 * the extended attributes from a given file.</p>
 *
 * @see ExtendedAttribute
 */

public interface EAEnumerator extends Enumeration
{
   /**
    * Attribute ID of EAEnumerator
    *
    * <p>(ATTRIBUTE_ID = com.novell.service.file.nw.ExtendedAttribute.ATTRIBUTE_ID)
    * </p>
    */

   public static final String ATTRIBUTE_ID =
      ExtendedAttribute.ATTRIBUTE_ID;

   /**
    * The schema binding name of EAEnumerator.
    *
    * <p>(SCHEMA_BINDING_NAME =
    *       com.novell.service.file.nw.ExtendedAttribute.SCHEMA_BINDING_NAME)
    * </p>
    * @see ExtendedAttribute
    */

   public static final String SCHEMA_BINDING_NAME =
      ExtendedAttribute.SCHEMA_BINDING_NAME;

   /**
    * The Schema Syntax of EAEnumerator.
    *
    * <p>(COMPARE_SYNTAX_STRING =
    *       com.novell.service.file.nw.ExtendedAttribute.COMPARE_SYNTAX_STRING)
    * </p>
    * @see ExtendedAttribute
    */

   public static final String COMPARE_SYNTAX_STRING =
      ExtendedAttribute.COMPARE_SYNTAX_STRING;

   /**
    * Returns the next element in the EA enumeration.
    *
    * <p>This method is used to return the typed ExtendedAttribute
    * value.</p>
    *
    * @return The next ExtendedAttribute in the enumeration.
    *
    * @exception NoSuchElementException When no next element is found.
    *
    * @see ExtendedAttribute
    */

   public ExtendedAttribute next();

   /**
    * Determines if the Enumerator has more elements.
    *
    * <p>This method is used to report if more elements are available.
    * It is a hasMoreElements short cut.</p>
    *
    * @return A boolean set to TRUE if there are more elements
    * to be returned; otherwise FALSE is returned.
    */

   public boolean hasMore();

}
