/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/NameSpace.java $
  $Revision: 6 $
  $Modtime: 12/17/99 10:43a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

/** 
 * Provides an interface for getting the default name space of the
 * platform on which the JVM is executing. It also provides a central
 * interface for changing NetWare file system name space integer values
 * into strings and vice versa.
 */
public class NameSpace
{
   private static final String[] nameSpaces =
   {
      "DOS",
      "MAC",
      "NFS",
      "FTAM",
      "LONG"
   };

   /**
    * The NetWare DOS name space flag.
    *
    * <p>DOS_INT = 0
    * </p>
    */
   public static final int DOS_INT = 0x00;

   /**
    * The NetWare MAC name space flag.
    *
    * <p>MAC_INT = 1
    * </p>
    */
   public static final int MAC_INT = 0x01;

   /**
    * The NetWare NFS name space flag.
    *
    * <p>NFS_INT = 2
    * </p>
    */
   public static final int NFS_INT = 0x02;

   /**
    * The NetWare FTAM name space flag.
    *
    * <p>FTAM_INT = 3
    * </p>
    */
   public static final int FTAM_INT = 0x03;

   /**
    * The NetWare LONG name space flag.
    *
    * <p>LONG_INT = 0
    * </p>
    */
   public static final int LONG_INT = 0x04;

   /**
    * Returns a name space number given a name space string.
    *
    * @param  name The name space string.
    *
    * @return The valid NetWare name space number for the
    *         name space string. If the name is invalid, -1
    *         is returned. 
    */
   public static int nameToNumber(String name)
   {
      if (name == null)
         return (-1);

      int i = nameSpaces.length;

      while (i-- > 0)
      {
         if (name.equals (nameSpaces[i]))
            return (i);
      }

      return (-1);
   }

   /**
    * Returns a name space string given a NetWare name space number.
    *
    * @param  ns The name space number.
    *
    * @return The valid name space string for the NetWare name space
    *         number. If the number is invalid, NULL is returned.
    */
   public static String numberToName(int ns)
   {
      if (ns < 0 || ns >= nameSpaces.length)
         return (null);
      else
         return (nameSpaces[ns]);
   }

   /**
    * Returns the default NetWare name space number depending
    * on the OS under which the current JVM is running.
    *
    * <p>This method returns the best-case name space, because not
    * every NetWare volume will support the name space returned.
    * The name space returned here must be filtered through the
    * list of name spaces loaded on a particular volume to get
    * the optimum usable name space for the volume.</p>
    *
    * @return The NetWare name space number.
    */
   public static int getPlatformDefaultNameSpace()
   {
      return (LONG_INT);
   }

}