/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/file/nw/naming/FileNameClassPair.java $
  $Revision: 1 $
  $Modtime: 3/03/98 10:57a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.naming;


import javax.naming.NameClassPair;


/** @internal
 *
 */
public final class FileNameClassPair extends NameClassPair 
{
   private String fileClassName;
   private String baseClass;

   /**
    *
    */
   public FileNameClassPair (
         String name,
         String baseClass) 
   {
      super (name, null);

      this.baseClass = baseClass;
   }

   /**
    *
    */
   public FileNameClassPair (
         String name,
         String baseClass,
         boolean isRelative)
   {
      super (name, null, isRelative);

      this.baseClass = baseClass;
   }

   /**
    *
    */
   public String getClassName ()
   {
      return (fileClassName);
   }

   /**
    *
    */
   public String getBaseClass ()
   {
      return (baseClass);
   }

   /**
    *
    */
   public void setClassName (String className)
   {
      this.fileClassName = className;
   }

} /* FileNameClassPair */


