/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncp/NDSErrors.java $
  $Revision: 5 $
  $Modtime: 1/28/00 11:06a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

/* @(#)NDSErrors.java        1.00  96/11/11    NSI Development Team
 *
 */

package com.novell.service.jncp;

/**
 * Static list of known errors returned from native NDS calls<p>
 *
 * @version     1.00, 11 Nov 1996
 * @author      NSI Development Team
 */

public class NDSErrors
{
   /* errors from the file system, IPX, NCP, and other OS services are one byte
    * and are mapped to -1 to -256 when returned as a directory services error
    */

   /**
    * <p>(ERR_INSUFFICIENT_MEMORY                 = -150 = 0xFFFFFF6A)
    * </p>
    */
   public static final int ERR_INSUFFICIENT_MEMORY                 = -150;

   /**
    * <p>(ERR_REQUEST_UNKNOWN                     = -251 = 0xFFFFFF05)
    * </p>
    */
   public static final int ERR_REQUEST_UNKNOWN                     = -251;

   /**
    * <p>(ERR_OF_SOME_SORT                        = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int ERR_OF_SOME_SORT                        = -255;

   /* -301 to -399 are returned by the directory services client library */

   /**
    * <p>(ERR_NOT_ENOUGH_MEMORY                   = -301 = 0xFFFFFED3)
    * </p>
    */
   public static final int ERR_NOT_ENOUGH_MEMORY                   = -301;

   /**
    * <p>(ERR_BAD_KEY                             = -302 = 0xFFFFFED2)
    * </p>
    */
   public static final int ERR_BAD_KEY                             = -302;

   /**
    * <p>(ERR_BAD_CONTEXT                         = -303 = 0xFFFFFED1)
    * </p>
    */
   public static final int ERR_BAD_CONTEXT                         = -303;

   /**
    * <p>(ERR_BUFFER_FULL                         = -304 = 0xFFFFFED0)
    * </p>
    */
   public static final int ERR_BUFFER_FULL                         = -304;

   /**
    * <p>(ERR_LIST_EMPTY                          = -305 = 0xFFFFFECF)
    * </p>
    */
   public static final int ERR_LIST_EMPTY                          = -305;

   /**
    * <p>(ERR_BAD_SYNTAX                          = -306 = 0xFFFFFECE)
    * </p>
    */
   public static final int ERR_BAD_SYNTAX                          = -306;

   /**
    * <p>(ERR_BUFFER_EMPTY                        = -307 = 0xFFFFFECD)
    * </p>
    */
   public static final int ERR_BUFFER_EMPTY                        = -307;

   /**
    * <p>(ERR_BAD_VERB                            = -308 = 0xFFFFFECC)
    * </p>
    */
   public static final int ERR_BAD_VERB                            = -308;

   /**
    * <p>(ERR_EXPECTED_IDENTIFIER                 = -309 = 0xFFFFFECB)
    * </p>
    */
   public static final int ERR_EXPECTED_IDENTIFIER                 = -309;

   /**
    * <p>(ERR_EXPECTED_EQUALS                     = -310 = 0xFFFFFECA)
    * </p>
    */
   public static final int ERR_EXPECTED_EQUALS                     = -310;

   /**
    * <p>(ERR_ATTR_TYPE_EXPECTED                  = -311 = 0xFFFFFEC9)
    * </p>
    */
   public static final int ERR_ATTR_TYPE_EXPECTED                  = -311;

   /**
    * <p>(ERR_ATTR_TYPE_NOT_EXPECTED              = -312 = 0xFFFFFEC8)
    * </p>
    */
   public static final int ERR_ATTR_TYPE_NOT_EXPECTED              = -312;

   /**
    * <p>(ERR_FILTER_TREE_EMPTY                   = -313 = 0xFFFFFEC7)
    * </p>
    */
   public static final int ERR_FILTER_TREE_EMPTY                   = -313;

   /**
    * <p>(ERR_INVALID_OBJECT_NAME                 = -314 = 0xFFFFFEC6)
    * </p>
    */
   public static final int ERR_INVALID_OBJECT_NAME                 = -314;

   /**
    * <p>(ERR_EXPECTED_RDN_DELIMITER              = -315 = 0xFFFFFEC5)
    * </p>
    */
   public static final int ERR_EXPECTED_RDN_DELIMITER              = -315;

   /**
    * <p>(ERR_TOO_MANY_TOKENS                     = -316 = 0xFFFFFEC4)
    * </p>
    */
   public static final int ERR_TOO_MANY_TOKENS                     = -316;

   /**
    * <p>(ERR_INCONSISTENT_MULTIAVA               = -317 = 0xFFFFFEC3)
    * </p>
    */
   public static final int ERR_INCONSISTENT_MULTIAVA               = -317;

   /**
    * <p>(ERR_COUNTRY_NAME_TOO_LONG               = -318 = 0xFFFFFEC2)
    * </p>
    */
   public static final int ERR_COUNTRY_NAME_TOO_LONG               = -318;

   /**
    * <p>(ERR_SYSTEM_ERROR                        = -319 = 0xFFFFFEC1)
    * </p>
    */
   public static final int ERR_SYSTEM_ERROR                        = -319;

   /**
    * <p>(ERR_CANT_ADD_ROOT                       = -320 = 0xFFFFFEC0)
    * </p>
    */
   public static final int ERR_CANT_ADD_ROOT                       = -320;

   /**
    * <p>(ERR_UNABLE_TO_ATTACH                    = -321 = 0xFFFFFEBF)
    * </p>
    */
   public static final int ERR_UNABLE_TO_ATTACH                    = -321;

   /**
    * <p>(ERR_INVALID_HANDLE                      = -322 = 0xFFFFFEBE)
    * </p>
    */
   public static final int ERR_INVALID_HANDLE                      = -322;

   /**
    * <p>(ERR_BUFFER_ZERO_LENGTH                  = -323 = 0xFFFFFEBD)
    * </p>
    */
   public static final int ERR_BUFFER_ZERO_LENGTH                  = -323;

   /**
    * <p>(ERR_INVALID_REPLICA_TYPE                = -324 = 0xFFFFFEBC)
    * </p>
    */
   public static final int ERR_INVALID_REPLICA_TYPE                = -324;

   /**
    * <p>(ERR_INVALID_ATTR_SYNTAX                 = -325 = 0xFFFFFEBB)
    * </p>
    */
   public static final int ERR_INVALID_ATTR_SYNTAX                 = -325;

   /**
    * <p>(ERR_INVALID_FILTER_SYNTAX               = -326 = 0xFFFFFEBA)
    * </p>
    */
   public static final int ERR_INVALID_FILTER_SYNTAX               = -326;

   /**
    * <p>(ERR_CONTEXT_CREATION                    = -328 = 0xFFFFFEB8)
    * </p>
    */
   public static final int ERR_CONTEXT_CREATION                    = -328;

   /**
    * <p>(ERR_INVALID_UNION_TAG                   = -329 = 0xFFFFFEB7)
    * </p>
    */
   public static final int ERR_INVALID_UNION_TAG                   = -329;

   /**
    * <p>(ERR_INVALID_SERVER_RESPONSE             = -330 = 0xFFFFFEB6)
    * </p>
    */
   public static final int ERR_INVALID_SERVER_RESPONSE             = -330;

   /**
    * <p>(ERR_NULL_POINTER                        = -331 = 0xFFFFFEB5)
    * </p>
    */
   public static final int ERR_NULL_POINTER                        = -331;

   /**
    * <p>(ERR_NO_SERVER_FOUND                     = -332 = 0xFFFFFEB4)
    * </p>
    */
   public static final int ERR_NO_SERVER_FOUND                     = -332;

   /**
    * <p>(ERR_NO_CONNECTION                       = -333 = 0xFFFFFEB3)
    * </p>
    */
   public static final int ERR_NO_CONNECTION                       = -333;

   /**
    * <p>(ERR_RDN_TOO_LONG                        = -334 = 0xFFFFFEB2)
    * </p>
    */
   public static final int ERR_RDN_TOO_LONG                        = -334;

   /**
    * <p>(ERR_DUPLICATE_TYPE                      = -335 = 0xFFFFFEB1)
    * </p>
    */
   public static final int ERR_DUPLICATE_TYPE                      = -335;

   /**
    * <p>(ERR_DATA_STORE_FAILURE                  = -336 = 0xFFFFFEB0)
    * </p>
    */
   public static final int ERR_DATA_STORE_FAILURE                  = -336;

   /**
    * <p>(ERR_NOT_LOGGED_IN                       = -337 = 0xFFFFFEAF)
    * </p>
    */
   public static final int ERR_NOT_LOGGED_IN                       = -337;

   /**
    * <p>(ERR_INVALID_PASSWORD_CHARS              = -338 = 0xFFFFFEAE)
    * </p>
    */
   public static final int ERR_INVALID_PASSWORD_CHARS              = -338;

   /**
    * <p>(ERR_FAILED_SERVER_AUTHENT               = -339 = 0xFFFFFEAD)
    * </p>
    */
   public static final int ERR_FAILED_SERVER_AUTHENT               = -339;

   /**
    * <p>(ERR_TRANSPORT                           = -340 = 0xFFFFFEAC)
    * </p>
    */
   public static final int ERR_TRANSPORT                           = -340;

   /**
    * <p>(ERR_NO_SUCH_SYNTAX                      = -341 = 0xFFFFFEAB)
    * </p>
    */
   public static final int ERR_NO_SUCH_SYNTAX                      = -341;

   /**
    * <p>(ERR_INVALID_DS_NAME                     = -342 = 0xFFFFFEAA)
    * </p>
    */
   public static final int ERR_INVALID_DS_NAME                     = -342;

   /**
    * <p>(ERR_ATTR_NAME_TOO_LONG                  = -343 = 0xFFFFFEA9)
    * </p>
    */
   public static final int ERR_ATTR_NAME_TOO_LONG                  = -343;

   /**
    * <p>(ERR_INVALID_TDS                         = -344 = 0xFFFFFEA8)
    * </p>
    */
   public static final int ERR_INVALID_TDS                         = -344;

   /**
    * <p>(ERR_INVALID_DS_VERSION                  = -345 = 0xFFFFFEA7)
    * </p>
    */
   public static final int ERR_INVALID_DS_VERSION                  = -345;

   /**
    * <p>(ERR_UNICODE_TRANSLATION                 = -346 = 0xFFFFFEA6)
    * </p>
    */
   public static final int ERR_UNICODE_TRANSLATION                 = -346;

   /**
    * <p>(ERR_SCHEMA_NAME_TOO_LONG                = -347 = 0xFFFFFEA5)
    * </p>
    */
   public static final int ERR_SCHEMA_NAME_TOO_LONG                = -347;

   /**
    * <p>(ERR_UNICODE_FILE_NOT_FOUND              = -348 = 0xFFFFFEA4)
    * </p>
    */
   public static final int ERR_UNICODE_FILE_NOT_FOUND              = -348;

   /**
    * <p>(ERR_UNICODE_ALREADY_LOADED              = -349 = 0xFFFFFEA3)
    * </p>
    */
   public static final int ERR_UNICODE_ALREADY_LOADED              = -349;

   /**
    * <p>(ERR_NOT_CONTEXT_OWNER                   = -350 = 0xFFFFFEA2)
    * </p>
    */
   public static final int ERR_NOT_CONTEXT_OWNER                   = -350;

   /**
    * <p>(ERR_ATTEMPT_TO_AUTHENTICATE_0           = -351 = 0xFFFFFEA1)
    * </p>
    */
   public static final int ERR_ATTEMPT_TO_AUTHENTICATE_0           = -351;

   /**
    * <p>(ERR_NO_WRITABLE_REPLICAS                = -352 = 0xFFFFFEA0)
    * </p>
    */
   public static final int ERR_NO_WRITABLE_REPLICAS                = -352;

   /**
    * <p>(ERR_DN_TOO_LONG                         = -353 = 0xFFFFFE9F)
    * </p>
    */
   public static final int ERR_DN_TOO_LONG                         = -353;

   /**
    * <p>(ERR_RENAME_NOT_ALLOWED                  = -354 = 0xFFFFFE9E)
    * </p>
    */
   public static final int ERR_RENAME_NOT_ALLOWED                  = -354;

   /* -601 to -699 are returned by the directory services agent in the server */

   /**
    * <p>(ERR_NO_SUCH_ENTRY                       = -601 = 0xFFFFFDA7)
    * </p>
    */
   public static final int ERR_NO_SUCH_ENTRY                       = -601;

   /**
    * <p>(ERR_NO_SUCH_VALUE                       = -602 = 0xFFFFFDA6)
    * </p>
    */
   public static final int ERR_NO_SUCH_VALUE                       = -602;

   /**
    * <p>(ERR_NO_SUCH_ATTRIBUTE                   = -603 = 0xFFFFFDA5)
    * </p>
    */
   public static final int ERR_NO_SUCH_ATTRIBUTE                   = -603;

   /**
    * <p>(ERR_NO_SUCH_CLASS                       = -604 = 0xFFFFFDA4)
    * </p>
    */
   public static final int ERR_NO_SUCH_CLASS                       = -604;

   /**
    * <p>(ERR_NO_SUCH_PARTITION                   = -605 = 0xFFFFFDA3)
    * </p>
    */
   public static final int ERR_NO_SUCH_PARTITION                   = -605;

   /**
    * <p>(ERR_ENTRY_ALREADY_EXISTS                = -606 = 0xFFFFFDA2)
    * </p>
    */
   public static final int ERR_ENTRY_ALREADY_EXISTS                = -606;

   /**
    * <p>(ERR_NOT_EFFECTIVE_CLASS                 = -607 = 0xFFFFFDA1)
    * </p>
    */
   public static final int ERR_NOT_EFFECTIVE_CLASS                 = -607;

   /**
    * <p>(ERR_ILLEGAL_ATTRIBUTE                   = -608 = 0xFFFFFDA0)
    * </p>
    */
   public static final int ERR_ILLEGAL_ATTRIBUTE                   = -608;

   /**
    * <p>(ERR_MISSING_MANDATORY                   = -609 = 0xFFFFFD9F)
    * </p>
    */
   public static final int ERR_MISSING_MANDATORY                   = -609;

   /**
    * <p>(ERR_ILLEGAL_DS_NAME                     = -610 = 0xFFFFFD9E)
    * </p>
    */
   public static final int ERR_ILLEGAL_DS_NAME                     = -610;

   /**
    * <p>(ERR_ILLEGAL_CONTAINMENT                 = -611 = 0xFFFFFD9D)
    * </p>
    */
   public static final int ERR_ILLEGAL_CONTAINMENT                 = -611;

   /**
    * <p>(ERR_CANT_HAVE_MULTIPLE_VALUES           = -612 = 0xFFFFFD9C)
    * </p>
    */
   public static final int ERR_CANT_HAVE_MULTIPLE_VALUES           = -612;

   /**
    * <p>(ERR_SYNTAX_VIOLATION                    = -613 = 0xFFFFFD9B)
    * </p>
    */
   public static final int ERR_SYNTAX_VIOLATION                    = -613;

   /**
    * <p>(ERR_DUPLICATE_VALUE                     = -614 = 0xFFFFFD9A)
    * </p>
    */
   public static final int ERR_DUPLICATE_VALUE                     = -614;

   /**
    * <p>(ERR_ATTRIBUTE_ALREADY_EXISTS            = -615 = 0xFFFFFD99)
    * </p>
    */
   public static final int ERR_ATTRIBUTE_ALREADY_EXISTS            = -615;

   /**
    * <p>(ERR_MAXIMUM_ENTRIES_EXIST               = -616 = 0xFFFFFD98)
    * </p>
    */
   public static final int ERR_MAXIMUM_ENTRIES_EXIST               = -616;

   /**
    * <p>(ERR_DATABASE_FORMAT                     = -617 = 0xFFFFFD97)
    * </p>
    */
   public static final int ERR_DATABASE_FORMAT                     = -617;

   /**
    * <p>(ERR_INCONSISTENT_DATABASE               = -618 = 0xFFFFFD96)
    * </p>
    */
   public static final int ERR_INCONSISTENT_DATABASE               = -618;

   /**
    * <p>(ERR_INVALID_COMPARISON                  = -619 = 0xFFFFFD95)
    * </p>
    */
   public static final int ERR_INVALID_COMPARISON                  = -619;

   /**
    * <p>(ERR_COMPARISON_FAILED                   = -620 = 0xFFFFFD94)
    * </p>
    */
   public static final int ERR_COMPARISON_FAILED                   = -620;

   /**
    * <p>(ERR_TRANSACTIONS_DISABLED               = -621 = 0xFFFFFD93)
    * </p>
    */
   public static final int ERR_TRANSACTIONS_DISABLED               = -621;

   /**
    * <p>(ERR_INVALID_TRANSPORT                   = -622 = 0xFFFFFD92)
    * </p>
    */
   public static final int ERR_INVALID_TRANSPORT                   = -622;

   /**
    * <p>(ERR_SYNTAX_INVALID_IN_NAME              = -623 = 0xFFFFFD91)
    * </p>
    */
   public static final int ERR_SYNTAX_INVALID_IN_NAME              = -623;

   /**
    * <p>(ERR_REPLICA_ALREADY_EXISTS              = -624 = 0xFFFFFD90)
    * </p>
    */
   public static final int ERR_REPLICA_ALREADY_EXISTS              = -624;

   /**
    * <p>(ERR_TRANSPORT_FAILURE                   = -625 = 0xFFFFFD8F)
    * </p>
    */
   public static final int ERR_TRANSPORT_FAILURE                   = -625;

   /**
    * <p>(ERR_ALL_REFERRALS_FAILED                = -626 = 0xFFFFFD8E)
    * </p>
    */
   public static final int ERR_ALL_REFERRALS_FAILED                = -626;

   /**
    * <p>(ERR_CANT_REMOVE_NAMING_VALUE            = -627 = 0xFFFFFD8D)
    * </p>
    */
   public static final int ERR_CANT_REMOVE_NAMING_VALUE            = -627;

   /**
    * <p>(ERR_OBJECT_CLASS_VIOLATION              = -628 = 0xFFFFFD8C)
    * </p>
    */
   public static final int ERR_OBJECT_CLASS_VIOLATION              = -628;

   /**
    * <p>(ERR_ENTRY_IS_NOT_LEAF                   = -629 = 0xFFFFFD8B)
    * </p>
    */
   public static final int ERR_ENTRY_IS_NOT_LEAF                   = -629;

   /**
    * <p>(ERR_DIFFERENT_TREE                      = -630 = 0xFFFFFD8A)
    * </p>
    */
   public static final int ERR_DIFFERENT_TREE                      = -630;

   /**
    * <p>(ERR_ILLEGAL_REPLICA_TYPE                = -631 = 0xFFFFFD89)
    * </p>
    */
   public static final int ERR_ILLEGAL_REPLICA_TYPE                = -631;

   /**
    * <p>(ERR_SYSTEM_FAILURE                      = -632 = 0xFFFFFD88)
    * </p>
    */
   public static final int ERR_SYSTEM_FAILURE                      = -632;

   /**
    * <p>(ERR_INVALID_ENTRY_FOR_ROOT              = -633 = 0xFFFFFD87)
    * </p>
    */
   public static final int ERR_INVALID_ENTRY_FOR_ROOT              = -633;

   /**
    * <p>(ERR_NO_REFERRALS                        = -634 = 0xFFFFFD86)
    * </p>
    */
   public static final int ERR_NO_REFERRALS                        = -634;

   /**
    * <p>(ERR_REMOTE_FAILURE                      = -635 = 0xFFFFFD85)
    * </p>
    */
   public static final int ERR_REMOTE_FAILURE                      = -635;

   /**
    * <p>(ERR_UNREACHABLE_SERVER                  = -636 = 0xFFFFFD84)
    * </p>
    */
   public static final int ERR_UNREACHABLE_SERVER                  = -636;

   /**
    * <p>(ERR_PREVIOUS_MOVE_IN_PROGRESS           = -637 = 0xFFFFFD83)
    * </p>
    */
   public static final int ERR_PREVIOUS_MOVE_IN_PROGRESS           = -637;

   /**
    * <p>(ERR_NO_CHARACTER_MAPPING                = -638 = 0xFFFFFD82)
    * </p>
    */
   public static final int ERR_NO_CHARACTER_MAPPING                = -638;

   /**
    * <p>(ERR_INCOMPLETE_AUTHENTICATION           = -639 = 0xFFFFFD81)
    * </p>
    */
   public static final int ERR_INCOMPLETE_AUTHENTICATION           = -639;

   /**
    * <p>(ERR_INVALID_CERTIFICATE                 = -640 = 0xFFFFFD80)
    * </p>
    */
   public static final int ERR_INVALID_CERTIFICATE                 = -640;

   /**
    * <p>(ERR_INVALID_REQUEST                     = -641 = 0xFFFFFD7F)
    * </p>
    */
   public static final int ERR_INVALID_REQUEST                     = -641;

   /**
    * <p>(ERR_INVALID_ITERATION                   = -642 = 0xFFFFFD7E)
    * </p>
    */
   public static final int ERR_INVALID_ITERATION                   = -642;

   /**
    * <p>(ERR_SCHEMA_IS_NONREMOVABLE              = -643 = 0xFFFFFD7D)
    * </p>
    */
   public static final int ERR_SCHEMA_IS_NONREMOVABLE              = -643;

   /**
    * <p>(ERR_SCHEMA_IS_IN_USE                    = -644 = 0xFFFFFD7C)
    * </p>
    */
   public static final int ERR_SCHEMA_IS_IN_USE                    = -644;

   /**
    * <p>(ERR_CLASS_ALREADY_EXISTS                = -645 = 0xFFFFFD7B)
    * </p>
    */
   public static final int ERR_CLASS_ALREADY_EXISTS                = -645;

   /**
    * <p>(ERR_BAD_NAMING_ATTRIBUTES               = -646 = 0xFFFFFD7A)
    * </p>
    */
   public static final int ERR_BAD_NAMING_ATTRIBUTES               = -646;

   /**
    * <p>(ERR_NOT_ROOT_PARTITION                  = -647 = 0xFFFFFD79)
    * </p>
    */
   public static final int ERR_NOT_ROOT_PARTITION                  = -647;

   /**
    * <p>(ERR_INSUFFICIENT_STACK                  = -648 = 0xFFFFFD78)
    * </p>
    */
   public static final int ERR_INSUFFICIENT_STACK                  = -648;

   /**
    * <p>(ERR_INSUFFICIENT_BUFFER                 = -649 = 0xFFFFFD77)
    * </p>
    */
   public static final int ERR_INSUFFICIENT_BUFFER                 = -649;

   /**
    * <p>(ERR_AMBIGUOUS_CONTAINMENT               = -650 = 0xFFFFFD76)
    * </p>
    */
   public static final int ERR_AMBIGUOUS_CONTAINMENT               = -650;

   /**
    * <p>(ERR_AMBIGUOUS_NAMING                    = -651 = 0xFFFFFD75)
    * </p>
    */
   public static final int ERR_AMBIGUOUS_NAMING                    = -651;

   /**
    * <p>(ERR_DUPLICATE_MANDATORY                 = -652 = 0xFFFFFD74)
    * </p>
    */
   public static final int ERR_DUPLICATE_MANDATORY                 = -652;

   /**
    * <p>(ERR_DUPLICATE_OPTIONAL                  = -653 = 0xFFFFFD73)
    * </p>
    */
   public static final int ERR_DUPLICATE_OPTIONAL                  = -653;

   /**
    * <p>(ERR_PARTITION_BUSY                      = -654 = 0xFFFFFD72)
    * </p>
    */
   public static final int ERR_PARTITION_BUSY                      = -654;

   /**
    * <p>(ERR_MULTIPLE_REPLICAS                   = -655 = 0xFFFFFD71)
    * </p>
    */
   public static final int ERR_MULTIPLE_REPLICAS                   = -655;

   /**
    * <p>(ERR_CRUCIAL_REPLICA                     = -656 = 0xFFFFFD70)
    * </p>
    */
   public static final int ERR_CRUCIAL_REPLICA                     = -656;

   /**
    * <p>(ERR_SCHEMA_SYNC_IN_PROGRESS             = -657 = 0xFFFFFD6F)
    * </p>
    */
   public static final int ERR_SCHEMA_SYNC_IN_PROGRESS             = -657;

   /**
    * <p>(ERR_SKULK_IN_PROGRESS                   = -658 = 0xFFFFFD6E)
    * </p>
    */
   public static final int ERR_SKULK_IN_PROGRESS                   = -658;

   /**
    * <p>(ERR_TIME_NOT_SYNCHRONIZED               = -659 = 0xFFFFFD6D)
    * </p>
    */
   public static final int ERR_TIME_NOT_SYNCHRONIZED               = -659;

   /**
    * <p>(ERR_RECORD_IN_USE                       = -660 = 0xFFFFFD6C)
    * </p>
    */
   public static final int ERR_RECORD_IN_USE                       = -660;

   /**
    * <p>(ERR_DS_VOLUME_NOT_MOUNTED               = -661 = 0xFFFFFD6B)
    * </p>
    */
   public static final int ERR_DS_VOLUME_NOT_MOUNTED               = -661;

   /**
    * <p>(ERR_DS_VOLUME_IO_FAILURE                = -662 = 0xFFFFFD6A)
    * </p>
    */
   public static final int ERR_DS_VOLUME_IO_FAILURE                = -662;

   /**
    * <p>(ERR_DS_LOCKED                           = -663 = 0xFFFFFD69)
    * </p>
    */
   public static final int ERR_DS_LOCKED                           = -663;

   /**
    * <p>(ERR_OLD_EPOCH                           = -664 = 0xFFFFFD68)
    * </p>
    */
   public static final int ERR_OLD_EPOCH                           = -664;

   /**
    * <p>(ERR_NEW_EPOCH                           = -665 = 0xFFFFFD67)
    * </p>
    */
   public static final int ERR_NEW_EPOCH                           = -665;

   /**
    * <p>(ERR_INCOMPATIBLE_DS_VERSION             = -666 = 0xFFFFFD66)
    * </p>
    */
   public static final int ERR_INCOMPATIBLE_DS_VERSION             = -666;

   /**
    * <p>(ERR_PARTITION_ROOT                      = -667 = 0xFFFFFD65)
    * </p>
    */
   public static final int ERR_PARTITION_ROOT                      = -667;

   /**
    * <p>(ERR_ENTRY_NOT_CONTAINER                 = -668 = 0xFFFFFD64)
    * </p>
    */
   public static final int ERR_ENTRY_NOT_CONTAINER                 = -668;

   /**
    * <p>(ERR_FAILED_AUTHENTICATION               = -669 = 0xFFFFFD63)
    * </p>
    */
   public static final int ERR_FAILED_AUTHENTICATION               = -669;

   /**
    * <p>(ERR_INVALID_CONTEXT                     = -670 = 0xFFFFFD62)
    * </p>
    */
   public static final int ERR_INVALID_CONTEXT                     = -670;

   /**
    * <p>(ERR_NO_SUCH_PARENT                      = -671 = 0xFFFFFD61)
    * </p>
    */
   public static final int ERR_NO_SUCH_PARENT                      = -671;

   /**
    * <p>(ERR_NO_ACCESS                           = -672 = 0xFFFFFD60)
    * </p>
    */
   public static final int ERR_NO_ACCESS                           = -672;

   /**
    * <p>(ERR_REPLICA_NOT_ON                      = -673 = 0xFFFFFD5F)
    * </p>
    */
   public static final int ERR_REPLICA_NOT_ON                      = -673;

   /**
    * <p>(ERR_INVALID_NAME_SERVICE                = -674 = 0xFFFFFD5E)
    * </p>
    */
   public static final int ERR_INVALID_NAME_SERVICE                = -674;

   /**
    * <p>(ERR_INVALID_TASK                        = -675 = 0xFFFFFD5D)
    * </p>
    */
   public static final int ERR_INVALID_TASK                        = -675;

   /**
    * <p>(ERR_INVALID_CONN_HANDLE                 = -676 = 0xFFFFFD5C)
    * </p>
    */
   public static final int ERR_INVALID_CONN_HANDLE                 = -676;

   /**
    * <p>(ERR_INVALID_IDENTITY                    = -677 = 0xFFFFFD5B)
    * </p>
    */
   public static final int ERR_INVALID_IDENTITY                    = -677;

   /**
    * <p>(ERR_DUPLICATE_ACL                       = -678 = 0xFFFFFD5A)
    * </p>
    */
   public static final int ERR_DUPLICATE_ACL                       = -678;

   /**
    * <p>(ERR_PARTITION_ALREADY_EXISTS            = -679 = 0xFFFFFD59)
    * </p>
    */
   public static final int ERR_PARTITION_ALREADY_EXISTS            = -679;

   /**
    * <p>(ERR_TRANSPORT_MODIFIED                  = -680 = 0xFFFFFD58)
    * </p>
    */
   public static final int ERR_TRANSPORT_MODIFIED                  = -680;

   /**
    * <p>(ERR_ALIAS_OF_AN_ALIAS                   = -681 = 0xFFFFFD57)
    * </p>
    */
   public static final int ERR_ALIAS_OF_AN_ALIAS                   = -681;

   /**
    * <p>(ERR_AUDITING_FAILED                     = -682 = 0xFFFFFD56)
    * </p>
    */
   public static final int ERR_AUDITING_FAILED                     = -682;

   /**
    * <p>(ERR_INVALID_API_VERSION                 = -683 = 0xFFFFFD55)
    * </p>
    */
   public static final int ERR_INVALID_API_VERSION                 = -683;

   /**
    * <p>(ERR_SECURE_NCP_VIOLATION                = -684 = 0xFFFFFD54)
    * </p>
    */
   public static final int ERR_SECURE_NCP_VIOLATION                = -684;

   /**
    * <p>(ERR_MOVE_IN_PROGRESS                    = -685 = 0xFFFFFD53)
    * </p>
    */
   public static final int ERR_MOVE_IN_PROGRESS                    = -685;

   /**
    * <p>(ERR_NOT_LEAF_PARTITION                  = -686 = 0xFFFFFD52)
    * </p>
    */
   public static final int ERR_NOT_LEAF_PARTITION                  = -686;

   /**
    * <p>(ERR_CANNOT_ABORT                        = -687 = 0xFFFFFD51)
    * </p>
    */
   public static final int ERR_CANNOT_ABORT                        = -687;

   /**
    * <p>(ERR_CACHE_OVERFLOW                      = -688 = 0xFFFFFD50)
    * </p>
    */
   public static final int ERR_CACHE_OVERFLOW                      = -688;

   /**
    * <p>(ERR_INVALID_SUBORDINATE_COUNT           = -689 = 0xFFFFFD4F)
    * </p>
    */
   public static final int ERR_INVALID_SUBORDINATE_COUNT           = -689;

   /**
    * <p>(ERR_INVALID_RDN                         = -690 = 0xFFFFFD4E)
    * </p>
    */
   public static final int ERR_INVALID_RDN                         = -690;

   /**
    * <p>(ERR_MOD_TIME_NOT_CURRENT                = -691 = 0xFFFFFD4D)
    * </p>
    */
   public static final int ERR_MOD_TIME_NOT_CURRENT                = -691;

   /**
    * <p>(ERR_INCORRECT_BASE_CLASS                = -692 = 0xFFFFFD4C)
    * </p>
    */
   public static final int ERR_INCORRECT_BASE_CLASS                = -692;

   /**
    * <p>(ERR_MISSING_REFERENCE                   = -693 = 0xFFFFFD4B)
    * </p>
    */
   public static final int ERR_MISSING_REFERENCE                   = -693;

   /**
    * <p>(ERR_LOST_ENTRY                          = -694 = 0xFFFFFD4A)
    * </p>
    */
   public static final int ERR_LOST_ENTRY                          = -694;

   /**
    * <p>(ERR_AGENT_ALREADY_REGISTERED            = -695 = 0xFFFFFD49)
    * </p>
    */
   public static final int ERR_AGENT_ALREADY_REGISTERED            = -695;

   /**
    * <p>(ERR_DS_LOADER_BUSY                      = -696 = 0xFFFFFD48)
    * </p>
    */
   public static final int ERR_DS_LOADER_BUSY                      = -696;

   /**
    * <p>(ERR_DS_CANNOT_RELOAD                    = -697 = 0xFFFFFD47)
    * </p>
    */
   public static final int ERR_DS_CANNOT_RELOAD                    = -697;

   /**
    * <p>(ERR_REPLICA_IN_SKULK                    = -698 = 0xFFFFFD46)
    * </p>
    */
   public static final int ERR_REPLICA_IN_SKULK                    = -698;

   /**
    * <p>(ERR_FATAL                               = -699 = 0xFFFFFD45)
    * </p>
    */
   public static final int ERR_FATAL                               = -699;

   /**
    * <p>(ERR_OBSOLETE_API                        = -700 = 0xFFFFFD44)
    * </p>
    */
   public static final int ERR_OBSOLETE_API                        = -700;

   /**
    * <p>(ERR_SYNCHRONIZATION_DISABLED            = -701 = 0xFFFFFD43)
    * </p>
    */
   public static final int ERR_SYNCHRONIZATION_DISABLED            = -701;

   /**
    * <p>(ERR_INVALID_PARAMETER                   = -702 = 0xFFFFFD42)
    * </p>
    */
   public static final int ERR_INVALID_PARAMETER                   = -702;

   /**
    * <p>(ERR_DUPLICATE_TEMPLATE                  = -703 = 0xFFFFFD41)
    * </p>
    */
   public static final int ERR_DUPLICATE_TEMPLATE                  = -703;

   /**
    * <p>(ERR_NO_MASTER_REPLICA                   = -704 = 0xFFFFFD40)
    * </p>
    */
   public static final int ERR_NO_MASTER_REPLICA                   = -704;

   /**
    * <p>(ERR_DUPLICATE_CONTAINMENT               = -705 = 0xFFFFFD3F)
    * </p>
    */
   public static final int ERR_DUPLICATE_CONTAINMENT               = -705;

   /**
    * <p>(ERR_NOT_SIBLING                         = -706 = 0xFFFFFD3E)
    * </p>
    */
   public static final int ERR_NOT_SIBLING                         = -706;

   /**
    * <p>(ERR_INVALID_SIGNATURE                   = -707 = 0xFFFFFD3D)
    * </p>
    */
   public static final int ERR_INVALID_SIGNATURE                   = -707;

   /**
    * <p>(ERR_INVALID_RESPONSE                    = -708 = 0xFFFFFD3C)
    * </p>
    */
   public static final int ERR_INVALID_RESPONSE                    = -708;

   /**
    * <p>(ERR_INSUFFICIENT_SOCKETS                = -709 = 0xFFFFFD3B)
    * </p>
    */
   public static final int ERR_INSUFFICIENT_SOCKETS                = -709;

   /**
    * <p>(ERR_DATABASE_READ_FAIL                  = -710 = 0xFFFFFD3A)
    * </p>
    */
   public static final int ERR_DATABASE_READ_FAIL                  = -710;

   /**
    * <p>(ERR_INVALID_CODE_PAGE                   = -711 = 0xFFFFFD39)
    * </p>
    */
   public static final int ERR_INVALID_CODE_PAGE                   = -711;

   /**
    * <p>(ERR_INVALID_ESCAPE_CHAR                 = -712 = 0xFFFFFD38)
    * </p>
    */
   public static final int ERR_INVALID_ESCAPE_CHAR                 = -712;

   /**
    * <p>(ERR_INVALID_DELIMITERS                  = -713 = 0xFFFFFD37)
    * </p>
    */
   public static final int ERR_INVALID_DELIMITERS                  = -713;

   /**
    * <p>(ERR_NOT_IMPLEMENTED                     = -714 = 0xFFFFFD36)
    * </p>
    */
   public static final int ERR_NOT_IMPLEMENTED                     = -714;

   /**
    * <p>(ERR_CHECKSUM_FAILURE                    = -715 = 0xFFFFFD35)
    * </p>
    */
   public static final int ERR_CHECKSUM_FAILURE                    = -715;

   /**
    * <p>(ERR_CHECKSUMMING_NOT_SUPPORTED          = -716 = 0xFFFFFD34)
    * </p>
    */
   public static final int ERR_CHECKSUMMING_NOT_SUPPORTED          = -716;

   /**
    * <p>(ERR_CRC_FAILURE                         = -717 = 0xFFFFFD33)
    * </p>
    */
   public static final int ERR_CRC_FAILURE                         = -717;

   /*---------------------------------------------------------------------------
    * -001 to -255 are OS Errors returned through directory services
    */

   /**
    * <p>(DSERR_INSUFFICIENT_SPACE                = -001 = 0xFFFFFFFF)
    * </p>
    */
   public static final int DSERR_INSUFFICIENT_SPACE                = -001;

   /**
    * <p>(DSERR_BUFFER_TOO_SMALL                  = -119 = 0xFFFFFF89)
    * </p>
    */
   public static final int DSERR_BUFFER_TOO_SMALL                  = -119;

   /**
    * <p>(DSERR_VOLUME_FLAG_NOT_SET               = -120 = 0xFFFFFF88)
    * </p>
    */
   public static final int DSERR_VOLUME_FLAG_NOT_SET               = -120;

   /**
    * <p>(DSERR_NO_ITEMS_FOUND                    = -121 = 0xFFFFFF87)
    * </p>
    */
   public static final int DSERR_NO_ITEMS_FOUND                    = -121;

   /**
    * <p>(DSERR_CONN_ALREADY_TEMPORARY            = -122 = 0xFFFFFF86)
    * </p>
    */
   public static final int DSERR_CONN_ALREADY_TEMPORARY            = -122;

   /**
    * <p>(DSERR_CONN_ALREADY_LOGGED_IN            = -123 = 0xFFFFFF85)
    * </p>
    */
   public static final int DSERR_CONN_ALREADY_LOGGED_IN            = -123;

   /**
    * <p>(DSERR_CONN_NOT_AUTHENTICATED            = -124 = 0xFFFFFF84)
    * </p>
    */
   public static final int DSERR_CONN_NOT_AUTHENTICATED            = -124;

   /**
    * <p>(DSERR_CONN_NOT_LOGGED_IN                = -125 = 0xFFFFFF83)
    * </p>
    */
   public static final int DSERR_CONN_NOT_LOGGED_IN                = -125;

   /**
    * <p>(DSERR_NCP_BOUNDARY_CHECK_FAILED         = -126 = 0xFFFFFF82)
    * </p>
    */
   public static final int DSERR_NCP_BOUNDARY_CHECK_FAILED         = -126;

   /**
    * <p>(DSERR_LOCK_WAITING                      = -127 = 0xFFFFFF81)
    * </p>
    */
   public static final int DSERR_LOCK_WAITING                      = -127;

   /**
    * <p>(DSERR_LOCK_FAIL                         = -128 = 0xFFFFFF80)
    * </p>
    */
   public static final int DSERR_LOCK_FAIL                         = -128;

   /**
    * <p>(DSERR_OUT_OF_HANDLES                    = -129 = 0xFFFFFF7F)
    * </p>
    */
   public static final int DSERR_OUT_OF_HANDLES                    = -129;

   /**
    * <p>(DSERR_NO_OPEN_PRIVILEGE                 = -130 = 0xFFFFFF7E)
    * </p>
    */
   public static final int DSERR_NO_OPEN_PRIVILEGE                 = -130;

   /**
    * <p>(DSERR_HARD_IO_ERROR                     = -131 = 0xFFFFFF7D)
    * </p>
    */
   public static final int DSERR_HARD_IO_ERROR                     = -131;

   /**
    * <p>(DSERR_NO_CREATE_PRIVILEGE               = -132 = 0xFFFFFF7C)
    * </p>
    */
   public static final int DSERR_NO_CREATE_PRIVILEGE               = -132;

   /**
    * <p>(DSERR_NO_CREATE_DELETE_PRIV             = -133 = 0xFFFFFF7B)
    * </p>
    */
   public static final int DSERR_NO_CREATE_DELETE_PRIV             = -133;

   /**
    * <p>(DSERR_R_O_CREATE_FILE                   = -134 = 0xFFFFFF7A)
    * </p>
    */
   public static final int DSERR_R_O_CREATE_FILE                   = -134;

   /**
    * <p>(DSERR_CREATE_FILE_INVALID_NAME          = -135 = 0xFFFFFF79)
    * </p>
    */
   public static final int DSERR_CREATE_FILE_INVALID_NAME          = -135;

   /**
    * <p>(DSERR_INVALID_FILE_HANDLE               = -136 = 0xFFFFFF78)
    * </p>
    */
   public static final int DSERR_INVALID_FILE_HANDLE               = -136;

   /**
    * <p>(DSERR_NO_SEARCH_PRIVILEGE               = -137 = 0xFFFFFF77)
    * </p>
    */
   public static final int DSERR_NO_SEARCH_PRIVILEGE               = -137;

   /**
    * <p>(DSERR_NO_DELETE_PRIVILEGE               = -138 = 0xFFFFFF76)
    * </p>
    */
   public static final int DSERR_NO_DELETE_PRIVILEGE               = -138;

   /**
    * <p>(DSERR_NO_RENAME_PRIVILEGE               = -139 = 0xFFFFFF75)
    * </p>
    */
   public static final int DSERR_NO_RENAME_PRIVILEGE               = -139;

   /**
    * <p>(DSERR_NO_SET_PRIVILEGE                  = -140 = 0xFFFFFF74)
    * </p>
    */
   public static final int DSERR_NO_SET_PRIVILEGE                  = -140;

   /**
    * <p>(DSERR_SOME_FILES_IN_USE                 = -141 = 0xFFFFFF73)
    * </p>
    */
   public static final int DSERR_SOME_FILES_IN_USE                 = -141;

   /**
    * <p>(DSERR_ALL_FILES_IN_USE                  = -142 = 0xFFFFFF72)
    * </p>
    */
   public static final int DSERR_ALL_FILES_IN_USE                  = -142;

   /**
    * <p>(DSERR_SOME_READ_ONLY                    = -143 = 0xFFFFFF71)
    * </p>
    */
   public static final int DSERR_SOME_READ_ONLY                    = -143;

   /**
    * <p>(DSERR_ALL_READ_ONLY                     = -144 = 0xFFFFFF70)
    * </p>
    */
   public static final int DSERR_ALL_READ_ONLY                     = -144;

   /**
    * <p>(DSERR_SOME_NAMES_EXIST                  = -145 = 0xFFFFFF6F)
    * </p>
    */
   public static final int DSERR_SOME_NAMES_EXIST                  = -145;

   /**
    * <p>(DSERR_ALL_NAMES_EXIST                   = -146 = 0xFFFFFF6E)
    * </p>
    */
   public static final int DSERR_ALL_NAMES_EXIST                   = -146;

   /**
    * <p>(DSERR_NO_READ_PRIVILEGE                 = -147 = 0xFFFFFF6D)
    * </p>
    */
   public static final int DSERR_NO_READ_PRIVILEGE                 = -147;

   /**
    * <p>(DSERR_NO_WRITE_PRIVILEGE                = -148 = 0xFFFFFF6C)
    * </p>
    */
   public static final int DSERR_NO_WRITE_PRIVILEGE                = -148;

   /**
    * <p>(DSERR_FILE_DETACHED                     = -149 = 0xFFFFFF6B)
    * </p>
    */
   public static final int DSERR_FILE_DETACHED                     = -149;

   /**
    * <p>(DSERR_NO_ALLOC_SPACE                    = -150 = 0xFFFFFF6A)
    * </p>
    */
   public static final int DSERR_NO_ALLOC_SPACE                    = -150;

   /**
    * <p>(DSERR_TARGET_NOT_A_SUBDIR               = -150 = 0xFFFFFF6A)
    * </p>
    */
   public static final int DSERR_TARGET_NOT_A_SUBDIR               = -150;

   /**
    * <p>(DSERR_NO_SPOOL_SPACE                    = -151 = 0xFFFFFF69)
    * </p>
    */
   public static final int DSERR_NO_SPOOL_SPACE                    = -151;

   /**
    * <p>(DSERR_INVALID_VOLUME                    = -152 = 0xFFFFFF68)
    * </p>
    */
   public static final int DSERR_INVALID_VOLUME                    = -152;

   /**
    * <p>(DSERR_DIRECTORY_FULL                    = -153 = 0xFFFFFF67)
    * </p>
    */
   public static final int DSERR_DIRECTORY_FULL                    = -153;

   /**
    * <p>(DSERR_RENAME_ACROSS_VOLUME              = -154 = 0xFFFFFF66)
    * </p>
    */
   public static final int DSERR_RENAME_ACROSS_VOLUME              = -154;

   /**
    * <p>(DSERR_BAD_DIR_HANDLE                    = -155 = 0xFFFFFF65)
    * </p>
    */
   public static final int DSERR_BAD_DIR_HANDLE                    = -155;

   /**
    * <p>(DSERR_INVALID_PATH                      = -156 = 0xFFFFFF64)
    * </p>
    */
   public static final int DSERR_INVALID_PATH                      = -156;

   /**
    * <p>(DSERR_NO_SUCH_EXTENSION                 = -156 = 0xFFFFFF64)
    * </p>
    */
   public static final int DSERR_NO_SUCH_EXTENSION                 = -156;

   /**
    * <p>(DSERR_NO_DIR_HANDLES                    = -157 = 0xFFFFFF63)
    * </p>
    */
   public static final int DSERR_NO_DIR_HANDLES                    = -157;

   /**
    * <p>(DSERR_BAD_FILE_NAME                     = -158 = 0xFFFFFF62)
    * </p>
    */
   public static final int DSERR_BAD_FILE_NAME                     = -158;

   /**
    * <p>(DSERR_DIRECTORY_ACTIVE                  = -159 = 0xFFFFFF61)
    * </p>
    */
   public static final int DSERR_DIRECTORY_ACTIVE                  = -159;

   /**
    * <p>(DSERR_DIRECTORY_NOT_EMPTY               = -160 = 0xFFFFFF60)
    * </p>
    */
   public static final int DSERR_DIRECTORY_NOT_EMPTY               = -160;

   /**
    * <p>(DSERR_DIRECTORY_IO_ERROR                = -161 = 0xFFFFFF5F)
    * </p>
    */
   public static final int DSERR_DIRECTORY_IO_ERROR                = -161;

   /**
    * <p>(DSERR_IO_LOCKED                         = -162 = 0xFFFFFF5E)
    * </p>
    */
   public static final int DSERR_IO_LOCKED                         = -162;

   /**
    * <p>(DSERR_TRANSACTION_RESTARTED             = -163 = 0xFFFFFF5D)
    * </p>
    */
   public static final int DSERR_TRANSACTION_RESTARTED             = -163;

   /**
    * <p>(DSERR_RENAME_DIR_INVALID                = -164 = 0xFFFFFF5C)
    * </p>
    */
   public static final int DSERR_RENAME_DIR_INVALID                = -164;

   /**
    * <p>(DSERR_INVALID_OPENCREATE_MODE           = -165 = 0xFFFFFF5B)
    * </p>
    */
   public static final int DSERR_INVALID_OPENCREATE_MODE           = -165;

   /**
    * <p>(DSERR_ALREADY_IN_USE                    = -166 = 0xFFFFFF5A)
    * </p>
    */
   public static final int DSERR_ALREADY_IN_USE                    = -166;

   /**
    * <p>(DSERR_INVALID_RESOURCE_TAG              = -167 = 0xFFFFFF59)
    * </p>
    */
   public static final int DSERR_INVALID_RESOURCE_TAG              = -167;

   /**
    * <p>(DSERR_ACCESS_DENIED                     = -168 = 0xFFFFFF58)
    * </p>
    */
   public static final int DSERR_ACCESS_DENIED                     = -168;

   /**
    * <p>(DSERR_INVALID_DATA_STREAM               = -190 = 0xFFFFFF42)
    * </p>
    */
   public static final int DSERR_INVALID_DATA_STREAM               = -190;

   /**
    * <p>(DSERR_INVALID_NAME_SPACE                = -191 = 0xFFFFFF41)
    * </p>
    */
   public static final int DSERR_INVALID_NAME_SPACE                = -191;

   /**
    * <p>(DSERR_NO_ACCOUNTING_PRIVILEGES          = -192 = 0xFFFFFF40)
    * </p>
    */
   public static final int DSERR_NO_ACCOUNTING_PRIVILEGES          = -192;

   /**
    * <p>(DSERR_NO_ACCOUNT_BALANCE                = -193 = 0xFFFFFF3F)
    * </p>
    */
   public static final int DSERR_NO_ACCOUNT_BALANCE                = -193;

   /**
    * <p>(DSERR_CREDIT_LIMIT_EXCEEDED             = -194 = 0xFFFFFF3E)
    * </p>
    */
   public static final int DSERR_CREDIT_LIMIT_EXCEEDED             = -194;

   /**
    * <p>(DSERR_TOO_MANY_HOLDS                    = -195 = 0xFFFFFF3D)
    * </p>
    */
   public static final int DSERR_TOO_MANY_HOLDS                    = -195;

   /**
    * <p>(DSERR_ACCOUNTING_DISABLED               = -196 = 0xFFFFFF3C)
    * </p>
    */
   public static final int DSERR_ACCOUNTING_DISABLED               = -196;

   /**
    * <p>(DSERR_LOGIN_LOCKOUT                     = -197 = 0xFFFFFF3B)
    * </p>
    */
   public static final int DSERR_LOGIN_LOCKOUT                     = -197;

   /**
    * <p>(DSERR_NO_CONSOLE_RIGHTS                 = -198 = 0xFFFFFF3A)
    * </p>
    */
   public static final int DSERR_NO_CONSOLE_RIGHTS                 = -198;

   /**
    * <p>(DSERR_Q_IO_FAILURE                      = -208 = 0xFFFFFF30)
    * </p>
    */
   public static final int DSERR_Q_IO_FAILURE                      = -208;

   /**
    * <p>(DSERR_NO_QUEUE                          = -209 = 0xFFFFFF2F)
    * </p>
    */
   public static final int DSERR_NO_QUEUE                          = -209;

   /**
    * <p>(DSERR_NO_Q_SERVER                       = -210 = 0xFFFFFF2E)
    * </p>
    */
   public static final int DSERR_NO_Q_SERVER                       = -210;

   /**
    * <p>(DSERR_NO_Q_RIGHTS                       = -211 = 0xFFFFFF2D)
    * </p>
    */
   public static final int DSERR_NO_Q_RIGHTS                       = -211;

   /**
    * <p>(DSERR_Q_FULL                            = -212 = 0xFFFFFF2C)
    * </p>
    */
   public static final int DSERR_Q_FULL                            = -212;

   /**
    * <p>(DSERR_NO_Q_JOB                          = -213 = 0xFFFFFF2B)
    * </p>
    */
   public static final int DSERR_NO_Q_JOB                          = -213;

   /**
    * <p>(DSERR_NO_Q_JOB_RIGHTS                   = -214 = 0xFFFFFF2A)
    * </p>
    */
   public static final int DSERR_NO_Q_JOB_RIGHTS                   = -214;

   /**
    * <p>(DSERR_UNENCRYPTED_NOT_ALLOWED           = -214 = 0xFFFFFF2A)
    * </p>
    */
   public static final int DSERR_UNENCRYPTED_NOT_ALLOWED           = -214;

   /**
    * <p>(DSERR_Q_IN_SERVICE                      = -215 = 0xFFFFFF29)
    * </p>
    */
   public static final int DSERR_Q_IN_SERVICE                      = -215;

   /**
    * <p>(DSERR_DUPLICATE_PASSWORD                = -215 = 0xFFFFFF29)
    * </p>
    */
   public static final int DSERR_DUPLICATE_PASSWORD                = -215;

   /**
    * <p>(DSERR_Q_NOT_ACTIVE                      = -216 = 0xFFFFFF28)
    * </p>
    */
   public static final int DSERR_Q_NOT_ACTIVE                      = -216;

   /**
    * <p>(DSERR_PASSWORD_TOO_SHORT                = -216 = 0xFFFFFF28)
    * </p>
    */
   public static final int DSERR_PASSWORD_TOO_SHORT                = -216;

   /**
    * <p>(DSERR_Q_STN_NOT_SERVER                  = -217 = 0xFFFFFF27)
    * </p>
    */
   public static final int DSERR_Q_STN_NOT_SERVER                  = -217;

   /**
    * <p>(DSERR_MAXIMUM_LOGINS_EXCEEDED           = -217 = 0xFFFFFF27)
    * </p>
    */
   public static final int DSERR_MAXIMUM_LOGINS_EXCEEDED           = -217;

   /**
    * <p>(DSERR_Q_HALTED                          = -218 = 0xFFFFFF26)
    * </p>
    */
   public static final int DSERR_Q_HALTED                          = -218;

   /**
    * <p>(DSERR_BAD_LOGIN_TIME                    = -218 = 0xFFFFFF26)
    * </p>
    */
   public static final int DSERR_BAD_LOGIN_TIME                    = -218;

   /**
    * <p>(DSERR_Q_MAX_SERVERS                     = -219 = 0xFFFFFF25)
    * </p>
    */
   public static final int DSERR_Q_MAX_SERVERS                     = -219;

   /**
    * <p>(DSERR_NODE_ADDRESS_VIOLATION            = -219 = 0xFFFFFF25)
    * </p>
    */
   public static final int DSERR_NODE_ADDRESS_VIOLATION            = -219;

   /**
    * <p>(DSERR_LOG_ACCOUNT_EXPIRED               = -220 = 0xFFFFFF24)
    * </p>
    */
   public static final int DSERR_LOG_ACCOUNT_EXPIRED               = -220;

   /**
    * <p>(DSERR_BAD_PASSWORD                      = -222 = 0xFFFFFF22)
    * </p>
    */
   public static final int DSERR_BAD_PASSWORD                      = -222;

   /**
    * <p>(DSERR_PASSWORD_EXPIRED                  = -223 = 0xFFFFFF21)
    * </p>
    */
   public static final int DSERR_PASSWORD_EXPIRED                  = -223;

   /**
    * <p>(DSERR_NO_LOGIN_CONN_AVAILABLE           = -224 = 0xFFFFFF20)
    * </p>
    */
   public static final int DSERR_NO_LOGIN_CONN_AVAILABLE           = -224;

   /**
    * <p>(DSERR_WRITE_TO_GROUP_PROPERTY           = -232 = 0xFFFFFF18)
    * </p>
    */
   public static final int DSERR_WRITE_TO_GROUP_PROPERTY           = -232;

   /**
    * <p>(DSERR_MEMBER_ALREADY_EXISTS             = -233 = 0xFFFFFF17)
    * </p>
    */
   public static final int DSERR_MEMBER_ALREADY_EXISTS             = -233;

   /**
    * <p>(DSERR_NO_SUCH_MEMBER                    = -234 = 0xFFFFFF16)
    * </p>
    */
   public static final int DSERR_NO_SUCH_MEMBER                    = -234;

   /**
    * <p>(DSERR_PROPERTY_NOT_GROUP                = -235 = 0xFFFFFF15)
    * </p>
    */
   public static final int DSERR_PROPERTY_NOT_GROUP                = -235;

   /**
    * <p>(DSERR_NO_SUCH_VALUE_SET                 = -236 = 0xFFFFFF14)
    * </p>
    */
   public static final int DSERR_NO_SUCH_VALUE_SET                 = -236;

   /**
    * <p>(DSERR_PROPERTY_ALREADY_EXISTS           = -237 = 0xFFFFFF13)
    * </p>
    */
   public static final int DSERR_PROPERTY_ALREADY_EXISTS           = -237;

   /**
    * <p>(DSERR_OBJECT_ALREADY_EXISTS             = -238 = 0xFFFFFF12)
    * </p>
    */
   public static final int DSERR_OBJECT_ALREADY_EXISTS             = -238;

   /**
    * <p>(DSERR_ILLEGAL_NAME                      = -239 = 0xFFFFFF11)
    * </p>
    */
   public static final int DSERR_ILLEGAL_NAME                      = -239;

   /**
    * <p>(DSERR_ILLEGAL_WILDCARD                  = -240 = 0xFFFFFF10)
    * </p>
    */
   public static final int DSERR_ILLEGAL_WILDCARD                  = -240;

   /**
    * <p>(DSERR_BINDERY_SECURITY                  = -241 = 0xFFFFFF0F)
    * </p>
    */
   public static final int DSERR_BINDERY_SECURITY                  = -241;

   /**
    * <p>(DSERR_NO_OBJECT_READ_RIGHTS             = -242 = 0xFFFFFF0E)
    * </p>
    */
   public static final int DSERR_NO_OBJECT_READ_RIGHTS             = -242;

   /**
    * <p>(DSERR_NO_OBJECT_RENAME_RIGHTS           = -243 = 0xFFFFFF0D)
    * </p>
    */
   public static final int DSERR_NO_OBJECT_RENAME_RIGHTS           = -243;

   /**
    * <p>(DSERR_NO_OBJECT_DELETE_RIGHTS           = -244 = 0xFFFFFF0C)
    * </p>
    */
   public static final int DSERR_NO_OBJECT_DELETE_RIGHTS           = -244;

   /**
    * <p>(DSERR_NO_OBJECT_CREATE_RIGHTS           = -245 = 0xFFFFFF0B)
    * </p>
    */
   public static final int DSERR_NO_OBJECT_CREATE_RIGHTS           = -245;

   /**
    * <p>(DSERR_NO_PROPERTY_DELETE_RIGHTS         = -246 = 0xFFFFFF0A)
    * </p>
    */
   public static final int DSERR_NO_PROPERTY_DELETE_RIGHTS         = -246;

   /**
    * <p>(DSERR_NO_PROPERTY_CREATE_RIGHTS         = -247 = 0xFFFFFF09)
    * </p>
    */
   public static final int DSERR_NO_PROPERTY_CREATE_RIGHTS         = -247;

   /**
    * <p>(DSERR_NO_PROPERTY_WRITE_RIGHTS          = -248 = 0xFFFFFF08)
    * </p>
    */
   public static final int DSERR_NO_PROPERTY_WRITE_RIGHTS          = -248;

   /**
    * <p>(DSERR_NO_PROPERTY_READ_RIGHTS           = -249 = 0xFFFFFF07)
    * </p>
    */
   public static final int DSERR_NO_PROPERTY_READ_RIGHTS           = -249;

   /**
    * <p>(DSERR_TEMP_REMAP                        = -250 = 0xFFFFFF06)
    * </p>
    */
   public static final int DSERR_TEMP_REMAP                        = -250;

   /**
    * <p>(DSERR_UNKNOWN_REQUEST                   = -251 = 0xFFFFFF05)
    * </p>
    */
   public static final int DSERR_UNKNOWN_REQUEST                   = -251;

   /**
    * <p>(DSERR_NO_SUCH_PROPERTY                  = -251 = 0xFFFFFF05)
    * </p>
    */
   public static final int DSERR_NO_SUCH_PROPERTY                  = -251;

   /**
    * <p>(DSERR_MESSAGE_QUEUE_FULL                = -252 = 0xFFFFFF04)
    * </p>
    */
   public static final int DSERR_MESSAGE_QUEUE_FULL                = -252;

   /**
    * <p>(DSERR_TARGET_ALREADY_HAS_MSG            = -252 = 0xFFFFFF04)
    * </p>
    */
   public static final int DSERR_TARGET_ALREADY_HAS_MSG            = -252;

   /**
    * <p>(DSERR_NO_SUCH_OBJECT                    = -252 = 0xFFFFFF04)
    * </p>
    */
   public static final int DSERR_NO_SUCH_OBJECT                    = -252;

   /**
    * <p>(DSERR_BAD_STATION_NUMBER                = -253 = 0xFFFFFF03)
    * </p>
    */
   public static final int DSERR_BAD_STATION_NUMBER                = -253;

   /**
    * <p>(DSERR_BINDERY_LOCKED                    = -254 = 0xFFFFFF02)
    * </p>
    */
   public static final int DSERR_BINDERY_LOCKED                    = -254;

   /**
    * <p>(DSERR_DIR_LOCKED                        = -254 = 0xFFFFFF02)
    * </p>
    */
   public static final int DSERR_DIR_LOCKED                        = -254;

   /**
    * <p>(DSERR_SPOOL_DELETE                      = -254 = 0xFFFFFF02)
    * </p>
    */
   public static final int DSERR_SPOOL_DELETE                      = -254;

   /**
    * <p>(DSERR_TRUSTEE_NOT_FOUND                 = -254 = 0xFFFFFF02)
    * </p>
    */
   public static final int DSERR_TRUSTEE_NOT_FOUND                 = -254;

   /**
    * <p>(DSERR_HARD_FAILURE                      = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_HARD_FAILURE                      = -255;

   /**
    * <p>(DSERR_FILE_NAME                         = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_FILE_NAME                         = -255;

   /**
    * <p>(DSERR_FILE_EXISTS                       = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_FILE_EXISTS                       = -255;

   /**
    * <p>(DSERR_CLOSE_FCB                         = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_CLOSE_FCB                         = -255;

   /**
    * <p>(DSERR_IO_BOUND                          = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_IO_BOUND                          = -255;

   /**
    * <p>(DSERR_NO_SPOOL_FILE                     = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_NO_SPOOL_FILE                     = -255;

   /**
    * <p>(DSERR_BAD_SPOOL_PRINTER                 = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_BAD_SPOOL_PRINTER                 = -255;

   /**
    * <p>(DSERR_BAD_PARAMETER                     = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_BAD_PARAMETER                     = -255;

   /**
    * <p>(DSERR_NO_FILES_FOUND                    = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_NO_FILES_FOUND                    = -255;

   /**
    * <p>(DSERR_NO_TRUSTEE_CHANGE_PRIV            = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_NO_TRUSTEE_CHANGE_PRIV            = -255;

   /**
    * <p>(DSERR_TARGET_NOT_LOGGED_IN              = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_TARGET_NOT_LOGGED_IN              = -255;

   /**
    * <p>(DSERR_TARGET_NOT_ACCEPTING_MSGS         = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_TARGET_NOT_ACCEPTING_MSGS         = -255;

   /**
    * <p>(DSERR_MUST_FORCE_DOWN                   = -255 = 0xFFFFFF01)
    * </p>
    */
   public static final int DSERR_MUST_FORCE_DOWN                   = -255;
}


