
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#if ! defined(jdsSwaps_H)
#define jdsSwaps_H


#if !defined (N_PLAT_MAC)
#  define LO_HI_MACH_TYPE   /* define Intel machine type */
#endif

#ifdef   N_PLAT_NLM

/* Integer byte-order swapping macros  */

   /* WATCOM 386 C pragmas for inline byte swapping functions  */

nuint16  cpu2moto16(nuint16);

#pragma  aux   cpu2moto16 =                                       \
                           0x86 0xE0         /* xchg  ah,al    */ \
                           parm nomemory [AX]                     \
                           value [AX]                             \
                           modify nomemory;

nuint32  cpu2moto32(nuint32);

#pragma  aux   cpu2moto32 =                                       \
                           0x86 0xE0         /* xchg  ah,al    */ \
                           0xC1 0xC8 0x10    /* ror   eax,16   */ \
                           0x86 0xE0         /* xchg  ah,al    */ \
                           parm nomemory [EAX]                    \
                           value [EAX]                            \
                           modify nomemory;

   /* Macros to access the inline functions  */

#define  CPU2MOTO16(x)     (cpu2moto16 (x))
#define  CPU2MOTO32(x)     (cpu2moto32 (x))

#elif defined(LO_HI_MACH_TYPE)

#define  CPU2MOTO16(x)  (\
                        ((nuint16)((x) & 0x00FF) << 8) | \
                        ((nuint16)((x) & 0xFF00) >> 8)      \
                        )

#define  CPU2MOTO32(x)  (\
                        ((nuint32)((x) & 0x000000FFL) << 24) | \
                        ((nuint32)((x) & 0x0000FF00L) <<  8) | \
                        ((nuint32)((x) & 0x00FF0000L) >>  8) | \
                        ((nuint32)((x) & 0xFF000000L) >> 24)     \
                        )
#elif defined(HI_LO_MACH_TYPE)      /* for Motorola ports... */

# define CPU2MOTO16(x)  (x)
# define CPU2MOTO32(x)  (x)

#endif

#ifdef LO_HI_MACH_TYPE
# define CPU2NET16(x)   (x)            /* wire format is Intel order */
# define CPU2NET32(x)   (x)
# define NET2CPU16(x)   (x)
# define NET2CPU32(x)   (x)

   /* define the machine type specific byte-order swapping macros */
# define CPU2INTEL16(x) (x)
# define CPU2INTEL32(x) (x)
# define INTEL2CPU16(x) (x)
# define INTEL2CPU32(x) (x)
# define MOTO2CPU16(x)  CPU2MOTO16(x)
# define MOTO2CPU32(x)  CPU2MOTO32(x)

#elif defined(HI_LO_MACH_TYPE)         /* for Motorola ports... */

# define CPU2NET16(x)   INWSwap16(x)   /* wire format is Intel order */
# define CPU2NET32(x)   INWSwap32(x)
# define NET2CPU16(x)   INWSwap16(x)
# define NET2CPU32(x)   INWSwap32(x)

   /* define the machine type specific byte-order swapping macros */
# define CPU2INTEL16(x) INWSwap16(x)
# define CPU2INTEL32(x) INWSwap32(x)
# define INTEL2CPU16(x) INWSwap16(x)
# define INTEL2CPU32(x) INWSwap32(x)
# define MOTO2CPU16(x)  CPU2MOTO16(x)
# define MOTO2CPU32(x)  CPU2MOTO32(x)

#endif

#endif /* jdsSwaps_H */


