
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <stdlib.h>

#include <jni.h>

#include "com_novell_service_jncpv2r_net_NetEntryInfoEnumerator.h"

#include <ntypes.h>
#include "JNIString.h"
#include <nwnet.h>



#include "NetEntryInfoJNI.h"
#include "NetAttributeValueFactoryJNI.h"


#if defined  (N_PLAT_NLM)
#  include "nlmsem.h"
#endif

#include "JDSFilter.h"


#ifdef __cplusplus
extern "C" {
#endif


/***** com_novell_service_jncpv2r_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    JDSPutFilter
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_JDSPutFilter
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint threadGroup,
   /*in*/   jint context,
   /*in*/   jint buf,
   /*in*/   jint cursor
)
{
   // NWNet variables
   NWDSCCODE ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext (&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      return ccode;
   }
#endif

   ccode = NWDSPutFilter (
                              (NWDSContextHandle) context,
                              (pBuf_T) buf,
                              (pFilter_Cursor_T) cursor,
                              freeValue);

#ifdef N_PLAT_NLM
   unwrapContext (saveThreadGroup);
#endif

   return (ccode);

} /* JDSPutFilter () */


#ifdef __cplusplus
}
#endif


