/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <jni.h>

#include <ntypes.h>
#include <unicode.h>

#include "NetAttributeValueFactoryJNI.h"


/* public final class NetAttributeValueFactory implements Serializable
 * {
 *    //
 * }
 */

#ifdef __cplusplus
extern "C" {
#endif


/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetAttributeValueFactory)
NetAttributeValueFactoryCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetAttributeValue;
   jclass clsNetAttributeValueFactory;
   //NJCL variables
   pNetAttributeValueFactory sNetAttributeValueFactory;

   clsNetAttributeValueFactory = (*env)->FindClass (env, NETSYNTAXPKG "NetAttributeValueFactory");
   clsNetAttributeValueFactory = (*env)->NewGlobalRef (env, clsNetAttributeValueFactory);

   clsNetAttributeValue = (*env)->FindClass (env, NETSYNTAXPKG "NetAttributeValue");
   clsNetAttributeValue = (*env)->NewGlobalRef (env, clsNetAttributeValue);

   sNetAttributeValueFactory = (pNetAttributeValueFactory) sysMalloc (sizeof (NetAttributeValueFactory));

   if (NULL != sNetAttributeValueFactory)
   {
      // assign jclass variables
      sNetAttributeValueFactory->cls = clsNetAttributeValueFactory;
      sNetAttributeValueFactory->clsNetAttributeValue = clsNetAttributeValue;

      // assign sNetAttributeValue variables
      sNetAttributeValueFactory->sNetUnknown = NetUnknownCreateStruct (env);
      sNetAttributeValueFactory->sNetDistinguishedName = NetDistinguishedNameCreateStruct (env);
      sNetAttributeValueFactory->sNetCaseExactString = NetCaseExactStringCreateStruct (env);
      sNetAttributeValueFactory->sNetCaseIgnoreString = NetCaseIgnoreStringCreateStruct (env);
      sNetAttributeValueFactory->sNetClassName = NetClassNameCreateStruct (env);
      sNetAttributeValueFactory->sNetNumericString = NetNumericStringCreateStruct (env);
      sNetAttributeValueFactory->sNetPrintableString = NetPrintableStringCreateStruct (env);
      sNetAttributeValueFactory->sNetTelephoneNumber = NetTelephoneNumberCreateStruct (env);
      sNetAttributeValueFactory->sNetEMailAddress = NetEMailAddressCreateStruct (env);
      sNetAttributeValueFactory->sNetBackLink = NetBackLinkCreateStruct (env);
      sNetAttributeValueFactory->sNetBoolean = NetBooleanCreateStruct (env);
      sNetAttributeValueFactory->sNetFAXNumber = NetFAXNumberCreateStruct (env);
      sNetAttributeValueFactory->sNetCounter = NetCounterCreateStruct (env);
      sNetAttributeValueFactory->sNetInteger = NetIntegerCreateStruct (env);
      sNetAttributeValueFactory->sNetInterval = NetIntervalCreateStruct (env);
      sNetAttributeValueFactory->sNetTime = NetTimeCreateStruct (env);
      sNetAttributeValueFactory->sNetNetAddress = NetNetAddressCreateStruct (env);
      sNetAttributeValueFactory->sNetTypedName = NetTypedNameCreateStruct (env);
      sNetAttributeValueFactory->sNetObjectACL = NetObjectACLCreateStruct (env);
      sNetAttributeValueFactory->sNetStream = NetStreamCreateStruct (env);
      sNetAttributeValueFactory->sNetOctetString = NetOctetStringCreateStruct (env);
      sNetAttributeValueFactory->sNetPath = NetPathCreateStruct (env);
      sNetAttributeValueFactory->sNetPostalAddress = NetPostalAddressCreateStruct (env);
      sNetAttributeValueFactory->sNetHold = NetHoldCreateStruct (env);
      sNetAttributeValueFactory->sNetReplicaPointer = NetReplicaPointerCreateStruct (env);
      sNetAttributeValueFactory->sNetTimestamp = NetTimestampCreateStruct (env);
      sNetAttributeValueFactory->sNetCaseIgnoreList = NetCaseIgnoreListCreateStruct (env);
      sNetAttributeValueFactory->sNetOctetList = NetOctetListCreateStruct (env);
   }
   return (sNetAttributeValueFactory);

} /* NetAttributeValueFactoryCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetAttributeValueFactoryCreateAttributeValue
(
   JNIEnv *env,
   pNetAttributeValueFactory sNetAttributeValueFactory,
   pBuf_T buf,
   nuint32 syntaxId
)
{
   // JNI variables
   jobject attributeValue;
   // NWNet variables
//   ppnstr8 curPos = (ppnstr8) &buf->curPos;
//   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   switch (syntaxId)
   {
      case SYN_UNKNOWN:
      {
         attributeValue = NetUnknownCreate (env, sNetAttributeValueFactory->sNetUnknown, buf);
         break;
      }
      case SYN_DIST_NAME:
      {
         attributeValue = NetDistinguishedNameCreate (env, sNetAttributeValueFactory->sNetDistinguishedName, buf);
         break;
      }
      case SYN_CE_STRING:
      {
         attributeValue = NetCaseExactStringCreate (env, sNetAttributeValueFactory->sNetCaseExactString, buf);
         break;
      }
      case SYN_CI_STRING:
      {
         attributeValue = NetCaseIgnoreStringCreate (env, sNetAttributeValueFactory->sNetCaseIgnoreString, buf);
         break;
      }
      case SYN_CLASS_NAME:
      {
         attributeValue = NetClassNameCreate (env, sNetAttributeValueFactory->sNetClassName, buf);
         break;
      }
      case SYN_NU_STRING:
      {
         attributeValue = NetNumericStringCreate (env, sNetAttributeValueFactory->sNetNumericString, buf);
         break;
      }
      case SYN_PR_STRING:
      {
         attributeValue = NetPrintableStringCreate (env, sNetAttributeValueFactory->sNetPrintableString, buf);
         break;
      }
      case SYN_TEL_NUMBER:
      {
         attributeValue = NetTelephoneNumberCreate (env, sNetAttributeValueFactory->sNetTelephoneNumber, buf);
         break;
      }
      case SYN_EMAIL_ADDRESS:
      {
         attributeValue = NetEMailAddressCreate (env, sNetAttributeValueFactory->sNetEMailAddress, buf);
         break;
      }
      case SYN_BACK_LINK:
      {
         attributeValue = NetBackLinkCreate (env, sNetAttributeValueFactory->sNetBackLink, buf);
         break;
      }
      case SYN_BOOLEAN:
      {
         attributeValue = NetBooleanCreate (env, sNetAttributeValueFactory->sNetBoolean, buf);
         break;
      }
      case SYN_FAX_NUMBER:
      {
         attributeValue = NetFAXNumberCreate (env, sNetAttributeValueFactory->sNetFAXNumber, buf);
         break;
      }
      case SYN_COUNTER:
      {
         attributeValue = NetCounterCreate (env, sNetAttributeValueFactory->sNetCounter, buf);
         break;
      }
      case SYN_INTEGER:
      {
         attributeValue = NetIntegerCreate (env, sNetAttributeValueFactory->sNetInteger, buf);
         break;
      }
      case SYN_INTERVAL:
      {
         attributeValue = NetIntervalCreate (env, sNetAttributeValueFactory->sNetInterval, buf);
         break;
      }
      case SYN_TIME:
      {
         attributeValue = NetTimeCreate (env, sNetAttributeValueFactory->sNetTime, buf);
         break;
      }
      case SYN_NET_ADDRESS:
      {
         attributeValue = NetNetAddressCreate (env, sNetAttributeValueFactory->sNetNetAddress, buf);
         break;
      }
      case SYN_TYPED_NAME:
      {
         attributeValue = NetTypedNameCreate (env, sNetAttributeValueFactory->sNetTypedName, buf);
         break;
      }
      case SYN_OBJECT_ACL:
      {
         attributeValue = NetObjectACLCreate (env, sNetAttributeValueFactory->sNetObjectACL, buf);
         break;
      }
      case SYN_STREAM:
      {
         attributeValue = NetStreamCreate (env, sNetAttributeValueFactory->sNetStream, buf);
         break;
      }
      case SYN_OCTET_STRING:
      {
         attributeValue = NetOctetStringCreate (env, sNetAttributeValueFactory->sNetOctetString, buf);
         break;
      }
      case SYN_PATH:
      {
         attributeValue = NetPathCreate (env, sNetAttributeValueFactory->sNetPath, buf);
         break;
      }
      case SYN_PO_ADDRESS:
      {
         attributeValue = NetPostalAddressCreate (env, sNetAttributeValueFactory->sNetPostalAddress, buf);
         break;
      }
      case SYN_HOLD:
      {
         attributeValue = NetHoldCreate (env, sNetAttributeValueFactory->sNetHold, buf);
         break;
      }
      case SYN_REPLICA_POINTER:
      {
         attributeValue = NetReplicaPointerCreate (env, sNetAttributeValueFactory->sNetReplicaPointer, buf);
         break;
      }
      case SYN_TIMESTAMP:
      {
         attributeValue = NetTimestampCreate (env, sNetAttributeValueFactory->sNetTimestamp, buf);
         break;
      }
      case SYN_CI_LIST:
      {
         attributeValue = NetCaseIgnoreListCreate (env, sNetAttributeValueFactory->sNetCaseIgnoreList, buf);
         break;
      }
      case SYN_OCTET_LIST:
      {
         attributeValue = NetOctetListCreate (env, sNetAttributeValueFactory->sNetOctetList, buf);
         break;
      }
      default:
      {
         attributeValue = (*env)->AllocObject (env, sNetAttributeValueFactory->clsNetAttributeValue);
         break;
      }
   }

   return (attributeValue);

} /* NetAttributeValueFactoryCreateAttributeValue () */


/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromString
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
);

/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromInteger
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
);

/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromBoolean
(
   JNIEnv *env,
   nptr cValue
);

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetAttributeValueFactory_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 syntaxId,
   nuint32  cValueSize
)
{
   // JNI variables
   jbyteArray value = 0;
   // NWNet variables

   switch (syntaxId)
   {
      case SYN_UNKNOWN:
      {
         value = NetUnknown_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_DIST_NAME:
      case SYN_CE_STRING:
      case SYN_CI_STRING:
      case SYN_CLASS_NAME:
      case SYN_NU_STRING:
      case SYN_PR_STRING:
      case SYN_TEL_NUMBER:
      {
         value = NetAttributeValue_toByteArray_fromString (env, cValue, cValueSize);
         break;
      }
      case SYN_EMAIL_ADDRESS:
      {
         value = NetEMailAddress_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_BACK_LINK:
      {
         value = NetBackLink_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_BOOLEAN:
      {
         value = NetAttributeValue_toByteArray_fromBoolean (env, cValue);
         break;
      }
      case SYN_COUNTER:
      case SYN_INTEGER:
      case SYN_INTERVAL:
      case SYN_TIME:
      {
         value = NetAttributeValue_toByteArray_fromInteger (env, cValue, cValueSize);
         break;
      }
      case SYN_FAX_NUMBER:
      {
         value = NetFAXNumber_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_NET_ADDRESS:
      {
         value = NetNetAddress_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_TYPED_NAME:
      {
         value = NetTypedName_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_OBJECT_ACL:
      {
         value = NetObjectACL_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_STREAM:
      {
         value = NetStream_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_OCTET_STRING:
      {
         value = NetOctetString_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_PATH:
      {
         value = NetPath_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_PO_ADDRESS:
      {
         value = NetPostalAddress_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_HOLD:
      {
         value = NetHold_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_REPLICA_POINTER:
      {
         value = NetReplicaPointer_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_TIMESTAMP:
      {
         value = NetTimestamp_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_CI_LIST:
      {
         value = NetCaseIgnoreList_toByteArray (env, cValue, cValueSize);
         break;
      }
      case SYN_OCTET_LIST:
      {
         value = NetOctetList_toByteArray (env, cValue, cValueSize);
         break;
      }
      default:
      {
//         value = (*env)->AllocObject (env, sNetAttributeValueFactory->clsNetAttributeValue);
         break;
      }
   }

   return (value);

} /* NetAttributeValueFactoryCreateByteArray () */

/*
 *
 */
N_INTERN_FUNC (nptr)
NetAttributeValue_toString_fromByteArray
(
   JNIEnv *env,
   jbyteArray value
);

/*
 *
 */
N_INTERN_FUNC (nptr)
NetAttributeValue_toInteger_fromByteArray
(
   JNIEnv *env,
   jbyteArray value
);

/*
 *
 */
N_GLOBAL_FUNC_C (nptr)
NetAttributeValueFactory_toCStruct
(
   JNIEnv *env,
   jbyteArray value,
   nuint32 syntaxId
)
{
   // JNI variables
   // NWNet variables
   nptr cValue = NULL;

   switch (syntaxId)
   {
      case SYN_UNKNOWN:
      {
         cValue = NetUnknown_toCStruct (env, value);
         break;
      }
      case SYN_DIST_NAME:
      case SYN_CE_STRING:
      case SYN_CI_STRING:
      case SYN_CLASS_NAME:
      case SYN_NU_STRING:
      case SYN_PR_STRING:
      case SYN_TEL_NUMBER:
      {
         cValue = NetAttributeValue_toString_fromByteArray (env, value);
         break;
      }
      case SYN_EMAIL_ADDRESS:
      {
         cValue = NetEMailAddress_toCStruct (env, value);
         break;
      }
      case SYN_BACK_LINK:
      {
         cValue = NetBackLink_toCStruct (env, value);
         break;
      }
      case SYN_BOOLEAN:
      case SYN_COUNTER:
      case SYN_INTEGER:
      case SYN_INTERVAL:
      case SYN_TIME:
      {
         cValue = NetAttributeValue_toInteger_fromByteArray (env, value);
         break;
      }
      case SYN_FAX_NUMBER:
      {
         cValue = NetFAXNumber_toCStruct (env, value);
         break;
      }
      case SYN_NET_ADDRESS:
      {
         cValue = NetNetAddress_toCStruct (env, value);
         break;
      }
      case SYN_TYPED_NAME:
      {
         cValue = NetTypedName_toCStruct (env, value);
         break;
      }
      case SYN_OBJECT_ACL:
      {
         cValue = NetObjectACL_toCStruct (env, value);
         break;
      }
      case SYN_STREAM:
      {
         cValue = NetStream_toCStruct (env, value);
         break;
      }
      case SYN_OCTET_STRING:
      {
         cValue = NetOctetString_toCStruct (env, value);
         break;
      }
      case SYN_PATH:
      {
         cValue = NetPath_toCStruct (env, value);
         break;
      }
      case SYN_PO_ADDRESS:
      {
         cValue = NetPostalAddress_toCStruct (env, value);
         break;
      }
      case SYN_HOLD:
      {
         cValue = NetHold_toCStruct (env, value);
         break;
      }
      case SYN_REPLICA_POINTER:
      {
         cValue = NetReplicaPointer_toCStruct (env, value);
         break;
      }
      case SYN_TIMESTAMP:
      {
         cValue = NetTimestamp_toCStruct (env, value);
         break;
      }
      case SYN_CI_LIST:
      {
         cValue = NetCaseIgnoreList_toCStruct (env, value);
         break;
      }
      case SYN_OCTET_LIST:
      {
         cValue = NetOctetList_toCStruct (env, value);
         break;
      }
      default:
      {
         cValue = NetAttributeValue_toString_fromByteArray (env, value);
         break;
      }
   }

   return (cValue);

} /* toCStruct () */

/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromString
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pnstr8 string;
   nuint8 *stringPtr;

   // NdsMemory.handle - ReplicaPointer C struct
   string = (pnstr8) cValue;

   // malloc temporary buffer
   stringPtr = (nuint8 *) sysMalloc (cLength);

   // build the temporary buffer
   unicpy ((unicode *) stringPtr, (unicode *) string);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) stringPtr);

   // free temporary buffer
   sysFree (stringPtr);

   return (byteArray);

} /* toByteArray_fromString () */

/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromInteger
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pnuint32 integer;
   nuint8 *integerPtr;

   // NdsMemory.handle - ReplicaPointer C struct
   integer = (pnuint32) cValue;

   // malloc temporary buffer
   integerPtr = (nuint8 *) sysMalloc (cLength);

   // build the temporary buffer
   *(nuint32 *)(integerPtr) = *integer;

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) integerPtr);

   // free temporary buffer
   sysFree (integerPtr);

   return (byteArray);

} /* toByteArray_fromInteger () */

/*
 *
 */
N_INTERN_FUNC (jbyteArray)
NetAttributeValue_toByteArray_fromBoolean
(
   JNIEnv *env,
   nptr cValue
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pnuint8 boolean;
   nuint8 *booleanPtr;

   // NdsMemory.handle - ReplicaPointer C struct
   boolean = (pnuint8) cValue;

   // malloc temporary buffer
   booleanPtr = (nuint8 *) sysMalloc (sizeof(nuint32));

   // build the temporary buffer
   *(nuint32 *)(booleanPtr) = *boolean;

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, sizeof(nuint32));

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, sizeof(nuint32), (jbyte *) booleanPtr);

   // free temporary buffer
   sysFree (booleanPtr);

   return (byteArray);

} /* toByteArray_fromInteger () */

/*
 *
 */
N_INTERN_FUNC (nptr)
NetAttributeValue_toString_fromByteArray
(
   JNIEnv *env,
   jbyteArray values
)
{
   // JNI variables
   jbyte *byteArray;
   // NWNet variables
   punicode string;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);

   // malloc buffer
   string = (punicode) sysMalloc ((*env)->GetArrayLength (env, values));
   // build buffer
   unicpy ((unicode *) string, (unicode *) byteArray);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) string);

} /* toString_fromByteArray () */

/*
 *
 */
N_INTERN_FUNC (nptr)
NetAttributeValue_toInteger_fromByteArray
(
   JNIEnv *env,
   jbyteArray values
)
{
   // JNI variables
   jbyte *byteArray;
   // NWNet variables
   pnuint32 integer;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);

   // malloc buffer buffer
   integer = (pnuint32) sysMalloc ((*env)->GetArrayLength (env, values));
   // build buffer
   *integer = *(nuint32 *) byteArray;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) integer);

} /* toInteger_fromByteArray () */


#ifdef __cplusplus
}
#endif


