/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>
#include <nwalias.h>

#include "jncpWire.h"

#include "NetBackLinkJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetBackLink
 *    extends NdsBackLink
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetBackLink)
NetBackLinkCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetBackLink;
   jclass clsNetBackLinkLR;
   //NJCL variables
   pNetBackLink sNetBackLink;

   clsNetBackLinkLR = (*env)->FindClass (env, NETSYNTAXPKG "NetBackLink");
   clsNetBackLink = (*env)->NewGlobalRef (env, clsNetBackLinkLR);
   (*env)->DeleteLocalRef (env, clsNetBackLinkLR);

   sNetBackLink = (pNetBackLink) sysMalloc (sizeof (NetBackLink));

   if (NULL != sNetBackLink)
   {
      // assign jclass variables
      sNetBackLink->cls = clsNetBackLink;

      // assign jfieldID variables
      sNetBackLink->ID.remoteId = (*env)->GetFieldID (env, clsNetBackLink, "remoteId", "I");
      sNetBackLink->ID.objectName = (*env)->GetFieldID (env, clsNetBackLink, "objectName", "Ljava/lang/String;");
   }
   return (sNetBackLink);

} /* NetBackLinkCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetBackLinkCreate
(
   JNIEnv *env,
   pNetBackLink sNetBackLink,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netBackLink = (*env)->AllocObject (env, sNetBackLink->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netBackLink,
                              sNetBackLink->ID.remoteId,
                        (jint)(jncpGetInt32 (env, curPos, limit)));
   }

   {
      jstring objectName;

      (*env)->SetObjectField (
                                 env,
                                 netBackLink,
                                 sNetBackLink->ID.objectName,
                        (jobject)(objectName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, objectName);
   }

   return (netBackLink);

} /* NetBackLinkCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    NWOBJ_ID   remoteID;
 *    pnchar     objectName;
 * } Back_Link_T;
 *
 * java array:
 *  | remoteId | objectName
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetBackLink_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{ 
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pBack_Link_T backLink;
   nuint8 *backLinkPtr, *ptr;

   // NdsMemory.handle - BackLink C struct
   backLink = (pBack_Link_T) cValue;
   
   // malloc temporary buffer
   backLinkPtr = (nuint8 *) sysMalloc (cLength);
   ptr = backLinkPtr;

   // build the temporary buffer
   *(NWOBJ_ID *) ptr = backLink->remoteID;
   ptr += sizeof (NWOBJ_ID);

   unicpy((unicode *) ptr, (unicode *) backLink->objectName);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) backLinkPtr);

   // free temporary buffer
   sysFree (backLinkPtr);
   
   return (byteArray);

} /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetBackLink_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pBack_Link_T backLink;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Back_Link_T);

   // malloc NetMemory buffer
   backLink = (pBack_Link_T) sysMalloc (length);
   dataPtr = (nuint8 *)(backLink) + sizeof(Back_Link_T);

   // build the buffer
   backLink->remoteID = *(NWOBJ_ID *) ptr;
   ptr += sizeof(NWOBJ_ID);

   unicpy ((unicode *)(backLink->objectName = (pnchar) dataPtr), (unicode *) ptr);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) backLink);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


