/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetSyntaxInfo.java $
  $Revision: 7 $
  $Modtime: 1/05/01 1:08p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.io.Serializable;

/** @internal
 *
 */
public final class NetSyntaxInfo implements Serializable
{
   private int    ID;
   private int    flags;
   String         defStr;

   /**
    * xxx.
    *
    * <p>(MAX_SCHEMA_NAME_CHARS = 32)
    * </p>
    */
   public final static int  MAX_SCHEMA_NAME_CHARS        = 32;

   /**
    * xxx.
    *
    * <p>(MAX_SCHEMA_NAME_BYTES = (2*(MAX_SCHEMA_NAME_CHARS+1)))
    * </p>
    */
   public final static int  MAX_SCHEMA_NAME_BYTES =
                                    (2*(MAX_SCHEMA_NAME_CHARS+1));
   /**
    * xxx.
    * </p>
    */
   public NetSyntaxInfo ()
   {
      defStr = new String ();
   }

   /**
    * xxx.
    * </p>
    */
   public NetSyntaxInfo (
         int ID,
         int flags,
         String defStr)
   {
      this.ID = ID;
      this.flags = flags;
      this.defStr = defStr;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getFlags ()
   {
      return this.flags;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public int getID ()
   {
      return this.ID;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public String getDefStr ()
   {
      return this.defStr;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setFlags (
         int flags)
   {
      this.flags = flags;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setID (
         int ID)
   {
      this.ID = ID;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setDefStr (
         String defStr)
   {
      this.defStr = defStr;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   protected void setDefStr (
         char [] defStr)
   {
      this.defStr = new StringBuffer ().append (defStr).toString ();
   }

   public void copy(NetSyntaxInfo from)
   {
      this.ID = from.ID;
      this.flags = from.flags;
      this.defStr = from.defStr;
   }
} /* NetSyntaxInfo */

