
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsNCPServer.java $
  $Revision: 11 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.util.Date;
import java.util.Enumeration;

import com.novell.service.jncp.NSIException;

/**
 * Defines NDS servers that provide NCP transport and session services.
 *
 * <p>Individual services on an NCP server do not need distinct Directory
 * names, since they can all share a common NCP session. However, individual
 * resources on a server may require distinct Directory entries. The
 * NDS NCP Server schema class is intended to represent both bindery-based
 * and NDS-based NCP servers.
 *
 * @see NdsObject 
 */
public interface NdsNCPServer extends NdsObject
{
  /**
   * Requests the server to unload and then load the DS NLM.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of XPlat libraries.
   */
   public void reloadDS ()
      throws NSIException;

  /**
   * Provides a list of replica partition names stored on this NCP
   * server.
   *
   * @return An enumeration object containing a list of replica
   *         partition names stored on this NCP server.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of XPlat libraries.
   */
   public Enumeration listPartitions ()
      throws NSIException;

  /**
   * Returns the Universal Time Coordinated (UTC) setting of a server.
   *
   * @return A date object containing the UTC time server setting.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of XPlat libraries.
   */
   public Date getUTCTime ()
      throws NSIException;

} /* NdsNCPServer */


