/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/ldap/LdapCounter.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapCounter is an Adapter for NdsCounter.
*/
public final class LdapCounter
   extends NdsCounter
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapCounter adapter for an NdsCounter.
   *
   * @param   value     Ldap string representation of Counter.
   */
   protected LdapCounter (
         String value)
      throws Exception
   {
      this.value = Integer.parseInt(value);
   }

   /**
   * Constructs an LdapCounter adapter for an NdsCounter.
   *
   * @param   value     an NdsCounter object.
   */
   protected LdapCounter (NdsCounter value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of Counter.
   *
   * @return   String containing Ldap string representation of Counter.
   */
   public String toString ()
   {
      return String.valueOf(this.value);
   }
}

