
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsNameParser.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.Properties;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

import com.novell.utility.naming.Syntax;


/**
 * Parses strings to names using the right-to-left dot-separated NDS
 * naming convention.
 *
 * <p>The NDS name parser keeps track of an optional tree name. Two
 * NDS name parsers are defined to be equal if and only if they service
 * the same tree. An NDS name parser is defined to be not equal to any
 * other name parser if the no-arg constructor is used. But it will
 * still parse names correctly.
 * </p>
 */
public class NdsNameParser implements NameParser
{
   protected static Syntax syntax = new NetSyntax ();

   private String treeName;

  /**
   *  Constructs an NdsNamePrser object with no parameters.
   */
   public NdsNameParser ()
   {
   }

  /**
   *  Constructs an NdsNamePrser object with a treeName parameter.
   *
   * @param treeName The tree name to be parsed input as a String.
   */
   public NdsNameParser (String treeName)
   {
      this.treeName = treeName;
   }

  /**
   *  Returns the Name parsed from the input name String.
   *
   * @param name The name to be parsed input as a String.
   *
   * @return The parsed Name object.
   *
   * @exception NamingException When a naming error occurs.
   */
   public Name parse (
         String name)
      throws NamingException
   {
      return (new NdsName (name, syntax));
   }

  /**
   * Determines if the current tree name is equal to the parsed
   * tree name.
   *
   * @param obj The object containing the parsed tree name.
   *
   * @return A boolean set to TRUE if the two tree names are equal;
   *         otherwise returns FALSE.
   */
   public boolean equals (
         Object obj)
   {
      if (treeName != null && obj instanceof NdsNameParser)
      {
         if (treeName.equalsIgnoreCase (((NdsNameParser) obj).treeName))
         {
            return (true);
         }
      }
      return (false);
   }

} /* NdsNameParser */


