/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsPartitionStrings.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.naming;

/** @internal
*  Repository for common strings
*/
public interface NdsPartitionStrings
{

   /**
   * Syntax direction for Partiiton name space.
   * Same as Netware name space
   */
   public final static String PARTITION_SYNTAX_DIRECTION = "left_to_right";

   /**
   * Separator character for Partition name space.
   * PARTITION_SYNTAX_SEPARATOR = /
   */
   public final static String PARTITION_SYNTAX_SEPARATOR = "/";

   /**
   * Escape character for Partition name space. PARTITION_SYNTAX_ESCAPE = \
   */
   public final static String PARTITION_SYNTAX_ESCAPE = "\\";

   /**
   * Begin quote character for Partition name space.
   * PARTITION_SYNTAX_BEGIN_QUOTE  = "
   */
   public final static String PARTITION_SYNTAX_BEGIN_QUOTE = "\"";

   /**
   * Begin quote 2 character for Partition name space.
   * PARTITION_SYNTAX_BEGIN_QUOTE2 = '
   */
   public final static String PARTITION_SYNTAX_BEGIN_QUOTE2 = "'";

   /**
   * jndi.initialContext.context property determines the starting context
   */
   public final static String PARTITION_INITIALCONTEXT_PROPERTY =
                                    "jndi.initialContext.context";

   /**
   * Replica type attribute ID.
   */
   public final static String REPLICA_ATTRIBUTE_REPLICATYPE = "replicaType";

   /**
   * Split Partition Operation Id.
   */
   public final static String SPLIT = "Split";

   /**
   * Join Partition Operation Id.
   */
   public final static String JOIN = "Join";


   /**
   * Replica Pointer Info (replica name,type, number, netaddress etc).
   */
   public final static String REPLICA_POINTER_INFO = "Replica Pointer Info";

   /**
   * Replica Sync Info (Last successful sync time etc).
   */
   public final static String REPLICA_SYNC_INFO = "Sync Info";

   /**
   * Replica Attribute Ids - Partition Name.
   */
   public final static String REPLICA_ATTRID_PARTITION_NAME = "Partition Name";

   /**
   * Replica Server info. (OS name, vendor name, partition list etc)
   */
   public final static String REPLICA_SERVER_INFO = "Server Info";

   /**
   * Replica Attribute Ids -  Replica name.
   */
   public final static String REPLICA_ATTRID_NAME = "Name";

   /**
   * Replica Attribute Ids -  Replica type.
   */
   public final static String REPLICA_ATTRID_TYPE = "Type";

   /**
   * Replica Attribute Ids -  Replica number.
   */
   public final static String REPLICA_ATTRID_NUMBER = "Number";

   /**
   * Replica Attribute Ids -  Replica state.
   */
   public final static String REPLICA_ATTRID_STATE = "State";

   /**
   * Replica Attribute Ids -  Replica address hints.
   */
   public final static String REPLICA_ATTRID_ADDRESS_HINTS =
                                    "Replica Address Hints";

   /**
   * Replica Attribute Ids -  Replica Server read.
   */
   public final static String REPLICA_ATTRID_SERVER_READ = "Server Read";

   /**
   * Replica Attribute Ids -  Replica Last Successful Sync Time.
   */
   public final static String REPLICA_ATTRID_LAST_SUCCESSFUL_SYNC_TIME =
                                    "Last Successful Sync Time";

   /**
   * Replica Attribute Ids -  Replica Sync Error.
   */
   public final static String REPLICA_ATTRID_SYNC_ERROR = "Sync Error";

   /**
   * Replica Attribute Ids -  Replica Server OS Name.
   */
   public final static String REPLICA_ATTRID_SERVER_OS_NAME =
                                    "Replica Server OS Name";

   /**
   * Replica Attribute Ids -  Replica Server Hardware Name.
   */
   public final static String REPLICA_ATTRID_SERVER_HARDWARE_NAME =
                                    "Replica Server Hardware Name";

   /**
   * Replica Attribute Ids -  Replica Server Vendor Name.
   */
   public final static String REPLICA_ATTRID_SERVER_VENDOR_NAME =
                                    "Replica Server Vendor Name";

   /**
   * Replica Attribute Ids -  Replica Server Directory Name.
   */
   public final static String REPLICA_ATTRID_SERVER_DIRECTORY_NAME =
                                    "Replica Server Directory Name";

   /**
   * Replica Attribute Ids -  Replica Server Directory Version.
   */
   public final static String REPLICA_ATTRID_SERVER_DIRECTORY_VERSION =
                                    "Replica Server Directory Version";

   /**
   * Replica Attribute Ids -  Replica Server Name.
   */
   public final static String REPLICA_ATTRID_SERVER_NAME =
                                    "Replica Server Name";

   /**
   * Replica Attribute Ids -  Replica Server Version.
   */
   public final static String REPLICA_ATTRID_SERVER_VERSION =
                                    "Replica Server Version";

   /**
   * Replica Attribute Ids -  Replica Server Addresses.
   */
   public final static String REPLICA_ATTRID_SERVER_ADDRESSES =
                                    "Replica Server Addresses";

   /**
   * Replica Attribute Ids -  Replica Server Sync Time Unit.
   */
   public final static String REPLICA_ATTRID_SERVER_SYNC_TIME_UNIT =
                                    "Replica Server Sync Time Unit";

   /**
   * Replica Attribute Ids -  Replica Server License ID.
   */
   public final static String REPLICA_ATTRID_SERVER_LICENSE_ID =
                                    "Replica Server License ID";

   /**
   * Replica Attribute Ids -  Replica Server Partition Modification Time.
   */
   public final static String REPLICA_ATTRID_SERVER_MODIFICATION_TIME =
                                    "Modification Timestamp";

   /**
   * Replica Attribute Ids -  Replica Server Busy.
   */
   public final static String REPLICA_ATTRID_SERVER_BUSY =
                                    "Busy";

   /**
   * Partition Attribute Ids - Partition Last Successful Sync Time
   */
   public final static String PARTITION_ATTRID_LAST_SUCCESSFUL_SYNC_TIME =
                                    "Last Successful Sync Time";

   /**
   * Partition Attribute Ids - Partition Last Attempted Sync Time
   */
   public final static String PARTITION_ATTRID_LAST_ATTEMPTED_SYNC_TIME =
                                    "Last Attempted Sync Time";

   /**
   * Partition Attribute Ids - Partition Name
   */
   public final static String PARTITION_ATTRID_NAME = "Name";

   /**
   * Partition Attribute Ids - Partition Server Read
   */
   public final static String PARTITION_ATTRID_SERVER_READ = "Server Read";
}