
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetPartitionNameClassEnumerator.java $
  $Revision: 9 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;
import javax.naming.*;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.naming.NdsNamingExceptionFactory;

import com.novell.service.jncpv2r.net.NetService;


/** @internal
 *
 *  NdsPartitionNameClassEnumerator class.
 */
public class NetPartitionNameClassEnumerator implements NamingEnumeration
{
   private NetPartitionEnumerator partEnum;
   private static NdsNamingExceptionFactory exceptionFactory =
       new NdsNamingExceptionFactory ();

   /**
    *  Constructs a NdsPartitionNameClassEnumerator object.
    *
    *  @param ndsContext       NDS Context handle.
    *  @param startObjectDN    FDN of the object where the search starts.
    *
    *  @exception NamingException
    */
   public NetPartitionNameClassEnumerator (
         NetService service,
         String startObjectDN)
      throws NamingException
   {
      try {
         this.partEnum = new NetPartitionEnumerator(
                         service, startObjectDN);
      }
      catch (NSIException e) {
			NamingException ne = exceptionFactory.getNamingException (e);
         throw ne;
      }
   }

   /**
    * Tests if this enumeration contains more elements.
    */
   public boolean hasMoreElements ()
   {
      return this.partEnum.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    */
   public Object nextElement ()
      throws NoSuchElementException
   {
      return new NameClassPair((String)partEnum.nextElement(),
                                 "NdsPartitionDirContext");
//      return new NameClassPair((String)this.nextElement(),
//                                 "NdsPartitionDirContext");
   }

   /**
    * Tests if this enumeration contains more elements.
    */
   public boolean hasMore()
   {
      return this.hasMoreElements();
   }

   /**
    * Returns the next element of this enumeration.
    */
   public Object next ()
         throws NamingException 
   {
      return (this.nextElement ());
   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
		partEnum.closeIteration ();
   }

} /* NetPartitionNameClassEnumerator */