
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetFAXNumber.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsFAXNumber;


/** @internal
 * NetFAXNumber is an Adapter for NdsFAXNumber.
 *
 * This class converts to/from the NWNet Fax_Number_T.
 * 
 * API Data Structure:
 *    typedef struct
 *    {
 *       pnchar         telephoneNumber;
 *       Bit_String_T   parameters;
 *    } Fax_Number_T;
 */
public final class NetFAXNumber
   extends NdsFAXNumber implements NetAttributeValue, Serializable
{
   /**
    * Constructs a FAX Number from the "API Data Structure".
    *
    * @param   value   byte[] containing a Fax_Number_T
    */
   protected NetFAXNumber (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.telephoneNumber = edis.readLoHiChars ();
         this.bitCount = edis.readLoHiInt ();
         this.parameters = new byte [this.bitCount];
         edis.readFully (this.parameters);
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetFAXNumber adapter for an NdsFAXNumber.
    *
    * @param   value   an NdsFAXNumber object.
    */
   protected NetFAXNumber (
         NdsFAXNumber value)
   {
      super (value);
   }

   /**
    * Returns a FAX Number "API Data Structure".
    *
    * @return   byte[] containing Fax_Number_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.telephoneNumber);
         eos.writeLoHiInt (this.bitCount);
         eos.write (this.parameters);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetFAXNumber */


