/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/InvalidSessionException.java $
  $Revision: 9 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session;

import com.novell.service.jncpv2r.clx.*;

/**
 * Thrown when a session is no longer valid. This typically occurs when
 * the session has been closed but the reference is still in use or
 * when the invalid method has been called for any other reason.
 */
public class InvalidSessionException extends SessionException
{
   /**
    * Constructs an InvalidSessionException with the specified detail message.
    * A detail message is a String that describes this particular exception.
    *
    * @param s The detail message describing the exception.
    */
   public InvalidSessionException
   (
      String s
   )
   {
      super(s);
   }

   /**
    * Constructs an InvalidSessionException with a detail message and a
    * root-cause exception. The root cause exception can be retrieved
    * using the getRootCause() method.
    *
    * @param s The detail message describing the exception.
    * @param rootException The root-cause exception.
    */
   public InvalidSessionException
   (
      String s,
      Throwable rootException
   )
   {
      super(s, rootException);
   }
}

