/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/nds/NDS.java $
  $Revision: 12 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.nds;

import com.novell.service.session.*;

/**
 * Provides static session attribute values for NDS.
 */
public class NDS
{
   /**
    * Attribute ID describing the raw authentication state of a session.
    * The associated value is a String.
    *
    * <p>(TREE_NAME_ATTR_ID = "TREE_NAME")
    *
    * @see SessionAttr
    * @see Session#getAttributes
    */
   public static final String TREE_NAME_ATTR_ID = "TREE_NAME";

   /**
    * Name for the NDS provider.
    *
    * <p>(PROVIDER_NAME = "NDS")
    *
    * @see SessionAttr
    * @see Session#getAttributes
    * @see Session#PROVIDER_NAME_ATTR_ID
    */
   public static final String PROVIDER_NAME = "NDS";

   /**
    * Domain name for the NDSInitialSession sessions.
    *
    * <p>(INITIAL_SESSION =
      "com.novell.service.session.nds.NDSInitialSession")
    *
    * @see SessionAttr
    * @see Session#getAttributes
    * @see Session#DOMAIN_NAME_ATTR_ID
    * @see Session#getDomainName
    */
   public static final String INITIAL_SESSION =
      "com.novell.service.session.nds.NDSInitialSession";

   /**
    * Operational Attribute ID describing the raw DS.NLM build version
    * on this server. The associated value is an Integer.
    *
    * <p>(SERVER_INFO_DS_VERSION_ATTR_ID = "SERVER_INFO_DS_VERSION")</p>
    *
    * @see SessionAttr
    */
   public static final String SERVER_INFO_DS_VERSION_ATTR_ID =
      "SERVER_INFO_DS_VERSION";

   /**
    * Operational Attribute ID describing the number of levels down from
    * the [Root] object that this server's root-most entry resides. The
    * associated value is an Integer.
    *
    * <p>(SERVER_INFO_ROOT_MOST_DEPTH_ATTR_ID = "SERVER_INFO_ROOT_MOST_DEPTH")</p>
    *
    * @see SessionAttr
    */
   public static final String SERVER_INFO_ROOT_MOST_DEPTH_ATTR_ID =
      "SERVER_INFO_ROOT_MOST_DEPTH";

   /**
    * Operational Attribute ID describing whether or not this server's
    * root-most paritition is a master replica. The associated value is
    * a Boolean.
    *
    * <p>(SERVER_INFO_IS_MASTER_ATTR_ID = "SERVER_INFO_IS_MASTER")</p>
    *
    * @see SessionAttr
    */
   public static final String SERVER_INFO_IS_MASTER_ATTR_ID =
      "SERVER_INFO_IS_MASTER";

   /**
    * Operational Attribute ID describing the fully distinguished name
    * of this server in its tree. The associated value is a String.
    *
    * <p>(SERVER_INFO_DN_ATTR_ID = "SERVER_INFO_DN")</p>
    *
    * @see SessionAttr
    */
   public static final String SERVER_INFO_DN_ATTR_ID =
      "SERVER_INFO_DN";

   private NDS()
   {
   }
}

