/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/spi/SessionManagerImpl.java $
  $Revision: 21 $
  $Modtime: 1/12/01 12:51p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import java.rmi.RemoteException;
import com.novell.service.session.*;

/** @internal
 */
public class SessionManagerImpl extends SessionImpl
implements SessionManager
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
   private int scope = SessionManagerFactory.SCOPE;
   private boolean useCustomSockets;
   RMISocketFactories sockFac;

   protected SessionManagerImpl
   (
      String domainName,
      int scope,
      SessionEnv environment,
      RMISocketFactories x
   )
   throws SessionException, RemoteException
   {
      super(null, domainName, environment, x);
      useCustomSockets = true;
      sockFac = x;
      this.scope = scope;
   }

   protected SessionManagerImpl
   (
      String domainName,
      int scope,
      SessionEnv environment
   )
   throws SessionException, RemoteException
   {
      super(null, domainName, environment);
      this.scope = scope;
   }

   public boolean useCustomSockets()
   {
      return useCustomSockets;
   }
   
   public RMISocketFactories getCustomSocketFactories()
   {
      return sockFac;
   }

   /* @internal
    * Returns the scope at which this session manager was created.
    */
   public int getScope()
   {
      return scope;
   }
}

