/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/CallsServiceRemote.java $
  $Revision: 14 $
  $Modtime: 1/18/01 4:49p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import java.io.Serializable;
import com.novell.service.session.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.jncp.NSIException;

/** @internal
 * Interface needed since CallsService has in/out parameters
 */
public interface CallsServiceRemote extends Remote
{
   public boolean areSLPCallsAvailable()
   throws NSIException, java.rmi.RemoteException;

   public int getObjectNamesBeginA
   (
      int type
   )
   throws NSIException, java.rmi.RemoteException;

   public NextObjectName getObjectNamesNextA
   (
      int handle,
      int bufLen
   )
   throws NSIException, java.rmi.RemoteException;

   public void getObjectNamesEndA
   (
      int handle
   )
   throws NSIException, java.rmi.RemoteException;

   public ObjectNameAndType getObjectName
   (
      int objectId
   )
   throws SessionException, java.rmi.RemoteException;

   public void freePtr(int mallocedPtr)
   throws SessionException, java.rmi.RemoteException;

   public int allocEAHandle()
   throws SessionException, java.rmi.RemoteException;

   public int allocEAFFStruct()
   throws SessionException, java.rmi.RemoteException;

   public void addObjectToSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException;

   public void changeObjectSecurity
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
   )
   throws SessionException, java.rmi.RemoteException;

   public void changePropertySecurity
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String propertyName,
      /*in*/   int   newPropertySecurity
   )

   throws SessionException, java.rmi.RemoteException;

   public void closeBindery ()

   throws SessionException, java.rmi.RemoteException;

   public void createObject
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity
   )
   throws SessionException, java.rmi.RemoteException;

   public void createProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
   )
   throws SessionException, java.rmi.RemoteException;
   public void deleteObject
   (
      /*in */  String objName,
      /*in*/   int objType
   )

   throws SessionException, java.rmi.RemoteException;

   public void deleteObjectFromSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )

   throws SessionException, java.rmi.RemoteException;

   public void disallowObjectPassword
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )

   throws SessionException, java.rmi.RemoteException;

   public BinderyAccessLevel getBinderyAccessLevel
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public ObjectDiskSpaceLeft getObjectDiskSpaceLeft
   (
      /*in*/   int           objID
   )
   throws SessionException, java.rmi.RemoteException;

   public int getObjectID
   (
      /*in*/   String   objName,
      /*in*/   int      objType
   )
   throws SessionException, java.rmi.RemoteException;

   public void isObjectInSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException, java.rmi.RemoteException;

   public void openBindery()

   throws SessionException, java.rmi.RemoteException;

   public PropertyValue readPropertyValue
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         propertyName,
      /*in*/   int            segmentNum
   )
   throws SessionException, java.rmi.RemoteException;

   public void renameObject
   (
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType
   )
   throws SessionException, java.rmi.RemoteException;

   public BinderyObject scanObject
   (
      /*in*/      String         searchName,
      /*in*/      int            searchType,
      /*in*/      int            objID
   )
   throws SessionException, java.rmi.RemoteException;

   public BinderyObjectProperty scanProperty
   (
      /*in*/   String         objName,
      /*in*/   int            objType,
      /*in*/   String         searchPropertyName,
      /*in*/   int            iterHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void writePropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException, java.rmi.RemoteException;

   public DirectoryEntryInformation getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask
   )
   throws SessionException, java.rmi.RemoteException;

   public DirectoryEntryInformationPlus scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask
   )
   throws SessionException, java.rmi.RemoteException;

   public String getVolumeName
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public int getVolumeNumber
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException;

   public int[] getNSLoadedList
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public int openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights
   )
   throws SessionException, java.rmi.RemoteException;

   public int openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )
   throws SessionException, java.rmi.RemoteException;

   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )
   throws SessionException, java.rmi.RemoteException;

   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void closeEA
   (
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public ReadEA readEA
   (
      int EAHandle,
      int off,
      int len
   )
   throws SessionException, java.rmi.RemoteException;

   public int writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len
   )
   throws SessionException, java.rmi.RemoteException;

   public String findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public String findNextEA
   (
      int EAFFStruct,
      int EAHandle
   )
   throws SessionException, java.rmi.RemoteException;

   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public TrusteeEnumeratorStruct scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public DirSpaceLimit getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException;

   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException, java.rmi.RemoteException;

   public int setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize
   )
   throws SessionException, java.rmi.RemoteException;

   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException, java.rmi.RemoteException;

   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'data' array must be 512 bytes long
   public byte[] readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'data' array must be 512 bytes long
   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException, java.rmi.RemoteException;

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException, java.rmi.RemoteException;

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException, java.rmi.RemoteException;

   public VolumeInformationBase getVolumeInfoWithNumber
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public VolumeInformationExtended getExtendedVolumeInfo
   (
      int volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public DirectorySpaceInformation getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException;

   public VolumeUtilization getDiskUtilization
   (
      int objID,
      int volNum
   )
   throws SessionException, java.rmi.RemoteException;

   public VolumeRestriction getObjDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException, java.rmi.RemoteException;

   public VolumeRestrictionEnumeratorStruct scanVolDiskRestrictions2
   (
      int volNumber,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException, java.rmi.RemoteException;

   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException, java.rmi.RemoteException;

   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException, java.rmi.RemoteException;

   public MountedVolumes scanMountedVolumes
   (
      int startVolNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public int allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace
   )
   throws SessionException, java.rmi.RemoteException;

   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException, java.rmi.RemoteException;

   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException, java.rmi.RemoteException;

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException, java.rmi.RemoteException;

   public int getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException;

   public int getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace
   )
   throws SessionException, java.rmi.RemoteException;

   public TrusteePath scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int iterHandle
   )
   throws SessionException, java.rmi.RemoteException;

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      String extensionName
   )
   throws SessionException, java.rmi.RemoteException;

   public NCPExtensionInfoImpl getNCPExtensionInfo
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException;

   public Object ncpExtensionRequest
   (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength
   )
   throws SessionException, java.rmi.RemoteException;

   public NCPExtensionInfoImpl scanNCPExtensions
   (
      int id
   )
   throws SessionException, java.rmi.RemoteException;

   public NWQueueJob createQueueFile2
   (
      int            queueID,
      NWQueueJob     job
   )

   throws SessionException, java.rmi.RemoteException;

   public void closeFileAndAbortQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException;

   public void closeFileAndStartQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException, java.rmi.RemoteException;

   public void abortServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public void attachQueueServerToQueue
   (
      int   queueID
   )
   throws SessionException, java.rmi.RemoteException;

   public NWQueueJob changeQueueJobEntry2
   (
      int queueID,
      NWQueueJob   job
   )
   throws SessionException, java.rmi.RemoteException;

   public void changeQueueJobPosition2
   (
      int queueID,
      int jobNumber,
      int newJobPos
   )
   throws SessionException, java.rmi.RemoteException;

   public void changeToClientRights2
   (
      int   queueID,
      int   jobNumber
   )
   throws SessionException, java.rmi.RemoteException;

   public QueueJobListReply getQueueJobList2
   (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
   )

   throws SessionException, java.rmi.RemoteException;

/*
   public void readQueueCurrentSessionAttrSet2
   (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
   )
   throws SessionException, java.rmi.RemoteException;
*/

   public QueueCurrentStatus readQueueCurrentStatus2
   (
         /*in*/   int   queueID
   )
   throws SessionException, java.rmi.RemoteException;

   public NWQueueJob readQueueJobEntry2
   (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
   )

   throws SessionException, java.rmi.RemoteException;

   public void removeJobFromQueue2
   (
      int queueID,
      int jobNumber
   )

   throws SessionException, java.rmi.RemoteException;

   public NWQueueJob serviceQueueJob2
   (
      int   queueID,
      int   targetJobType,
      NWQueueJob job
   )
   throws SessionException, java.rmi.RemoteException;
/*
   public void setQueueCurrentSessionAttrSet2
   (
      int queueID,
      int queueSessionAttrSet
   )
   throws SessionException, java.rmi.RemoteException;
*/

   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
      throws SessionException, java.rmi.RemoteException;

   public int createQueue
   (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path
   )
   throws SessionException, java.rmi.RemoteException;

   public void destroyQueue
   (
      int queueID
   )
   throws SessionException, java.rmi.RemoteException;

   public void detachQueueServerFromQueue
   (
      int   queueID
   )
   throws SessionException, java.rmi.RemoteException;

   public void finishServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException, java.rmi.RemoteException;

   public int getQueueJobFileSize2
   (
      int queueID,
      int jobNumber
   )
   throws SessionException, java.rmi.RemoteException;


/* *************************************************************************
* Server natives
****************************************************************************/

   public CVersionInfo getFileServerVersionInfo
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public CNWFSEFileServerInfo getFileServerInfo
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public boolean getFileServerLoginStatus
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public void loadNLM(String loadCommand)
   throws SessionException, java.rmi.RemoteException;

   public void unloadNLM(String NLMName)
   throws SessionException, java.rmi.RemoteException;

   public FileServerDescription getFileServerDescription
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public Object getFileServerDateAndTime
   (
   )
   throws SessionException, java.rmi.RemoteException;

   public void setFileServerDateAndTime
   (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
   )
   throws SessionException, java.rmi.RemoteException;

   public class BinderyAccessLevel implements Serializable
   {
      public IntegerBuffer accessLevel;
      public IntegerBuffer objID;

      public BinderyAccessLevel()
      {
         accessLevel  = new IntegerBuffer();
         objID        = new IntegerBuffer();
      }
   }

   public class ObjectDiskSpaceLeft implements Serializable
   {
      public IntegerBuffer systemElapsedTime;
      public IntegerBuffer unusedDiskBlocks;
      public IntegerBuffer restrictionEnforced;

      public ObjectDiskSpaceLeft()
      {
         systemElapsedTime     = new IntegerBuffer();
         unusedDiskBlocks      = new IntegerBuffer();
         restrictionEnforced   = new IntegerBuffer();
      }
   }

   public class PropertyValue implements Serializable
   {
      public byte[]        segmentData;
      public IntegerBuffer moreSegments;
      public IntegerBuffer flags;

      public PropertyValue()
      {
         segmentData  = new byte[129];
         moreSegments = new IntegerBuffer();
         flags        = new IntegerBuffer();
      }
   }

   public class BinderyObject implements Serializable
   {
      int      objID;
      String   objName;
      int      objType;
      int      hasPropertiesFlag;
      int      objFlags;
      int      objSecurity;

      public BinderyObject(
         int      objID,
         String   objName,
         int      objType,
         int      hasPropertiesFlag,
         int      objFlags,
         int      objSecurity)
      {
         this.objID              = objID;
         this.objName            = objName;
         this.objType            = objType;
         this.hasPropertiesFlag  = hasPropertiesFlag;
         this.objFlags           = objFlags;
         this.objSecurity        = objSecurity;
      }
   }

   public class BinderyObjectTrusteePath implements Serializable
   {
      IntegerBuffer iterHandle;
      StringBuffer dirPath;

      public BinderyObjectTrusteePath()
      {
         iterHandle = new IntegerBuffer();
         dirPath = new StringBuffer();
      }
   }

   public class BinderyObjectProperty implements Serializable
   {
      public IntegerBuffer  iterHandle;
      public StringBuffer   propertyName;
      public IntegerBuffer  propertyFlags;
      public IntegerBuffer  propertySecurity;
      public IntegerBuffer  valueAvailable;
      public IntegerBuffer  moreFlag;

      public BinderyObjectProperty()
      {
         iterHandle        = new IntegerBuffer();
         propertyName      = new StringBuffer();
         propertyFlags     = new IntegerBuffer();
         propertySecurity  = new IntegerBuffer();
         valueAvailable    = new IntegerBuffer();
         moreFlag          = new IntegerBuffer();
      }
   }

   public class QueueCurrentStatus implements Serializable
   {
      IntegerBuffer  queueStatus;
      IntegerBuffer  numberOfJobs;
      IntegerBuffer  numberOfServers;
      int[]          serverIDlist;
      int[]          serverConnList;

      public QueueCurrentStatus()
      {
         queueStatus       = new IntegerBuffer();
         numberOfJobs      = new IntegerBuffer();
         numberOfServers   = new IntegerBuffer();
         serverIDlist      = new int[25];
         serverConnList    = new int[25];
      }
   }

   public class NextObjectName implements Serializable
   {
      StringBuffer   name;
      IntegerBuffer  length;

      public NextObjectName()
      {
         name = new StringBuffer();
         length = new IntegerBuffer();
      }
   }

   public class ObjectNameAndType implements Serializable
   {
      StringBuffer   name;
      IntegerBuffer  type;

      public ObjectNameAndType()
      {
         name = new StringBuffer();
         type = new IntegerBuffer();
      }
   }

   public class ReadEA implements Serializable
   {
      int[] totalEASize;
      int[] bytesRead;
      byte[] buf;
      int ccode; //Used to handle the special return code of "1";

      public ReadEA(int bufSize)
      {
         totalEASize = new int[1];
         bytesRead = new int[1];
         buf = new byte[bufSize];
         ccode = 0;
      }
   }

   public class TrusteeEnumeratorStruct implements Serializable
   {
      public int iterHandle;
      public int entryCount;
      public int[] objectRights;
      public int[] objectIds;

      public TrusteeEnumeratorStruct()
      {
         iterHandle = 0;
         entryCount = 0;
         objectRights = new int[20];
         objectIds = new int[20];
      }
   }

   public class DirectoryEntryInformationPlus implements Serializable
   {
      DirectoryEntryInformation dei;
      int[] volNumber;
      int[] dirNumber;
      int[] searchDirNumber;
   }
      
   public class DirSpaceLimit implements Serializable
   {
      int[] maxAvailable;
      int[] currentUse;

      public DirSpaceLimit()
      {
         maxAvailable = new int[1];
         currentUse = new int[1];
      }
   }

   public class VolumeInformationBase implements Serializable
   {
      public String volName;
      public int totalBlocks;
      public int sectorsPerBlock;
      public int availableBlocks;
      public int totalDirEntries;
      public int availableDirEntries;
      public int volIsRemovableFlag;

      public VolumeInformationBase()
      {
      }
   }

   public class VolumeInformationExtended implements Serializable
   {
      public int volType;
      public int statusFlag;
      public int sectorSize;
      public int sectorsPerCluster;
      public int volSizeInClusters;
      public int freeClusters;
      public int subAllocFreeableClusters;
      public int freeableLimboSectors;
      public int nonfreeableLimboSectors;
      public int availSubAllocSectors;
      public int nonuseableSubAllocSectors;
      public int subAllocClusters;
      public int numDataStreams;
      public int numLimboDataStreams;
      public int oldestDelFileAgeInTicks;
      public int numCompressedDataStreams;
      public int numCompressedLimboDataStreams;
      public int numNoncompressibleDataStreams;
      public int precompressedSectors;
      public int compressedSectors;
      public int numMigratedDataStreams;
      public int migratedSectors;
      public int clustersUsedByFAT;
      public int clustersUsedByDirs;
      public int clustersUsedByExtDirs;
      public int totalDirEntries;
      public int unusedDirEntries;
      public int totalExtDirExtants;
      public int unusedExtDirExtants;
      public int extAttrsDefined;
      public int extAttrExtantsUsed;
      public String directoryServicesName;
      public int volLastModifiedDateAndTime;
      public int directoryServicesObjectId;

      public VolumeInformationExtended()
      {
      }
   }

   public class VolumeRestrictionEnumeratorStruct implements Serializable
   {
      public int iterHandle;
      public int entryCount;
      public VolumeRestriction[] vRestrictions;

      public VolumeRestrictionEnumeratorStruct(int iterHandle)
      {
         this.iterHandle = iterHandle;
         vRestrictions = new VolumeRestriction[16];
         for(int x=0; x<16; x++)
            vRestrictions[x] = new VolumeRestriction();
      }
   }

/*
   public class VolumeRestictionStruct implements Serializable
   {
      private int objectId;
      private int restriction;

      public VolumeRestictionStruct()
      {
      }
   }
*/

   public class MountedVolumes implements Serializable
   {
      int[][] numbers;
      String[][] names;       // return new array of vol names in first elem.
      int[] nextVolNumber;    // return next vol number in first element

      public MountedVolumes()
      {
         numbers = new int[1][];
         names = new String[1][];
         nextVolNumber = new int[1];
      }
   }

   public class TrusteePath implements Serializable
   {
      int[] iterHandle;
      int[] rights;
      String[] path;

      public TrusteePath()
      {
         iterHandle = new int[1];
         rights = new int[1];
         path = new String[1];
      }
   }

   public class FileServerDescription implements Serializable
   {
      StringBuffer companyName;
      StringBuffer revision;
      StringBuffer revisionDate;
      StringBuffer copyrightNotice;

      public FileServerDescription()
      {
         companyName = new StringBuffer();
         revision = new StringBuffer();
         revisionDate = new StringBuffer();
         copyrightNotice = new StringBuffer();
      }
   }
}
