/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/JCEHelper.java $
  $Revision: 3 $
  $Modtime: 1/25/01 11:33a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.math.*;
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import com.novell.service.session.SessionException;

public class JCEHelper
{
   private static final boolean debug = false; //only used for debugging
   
   static final String skip1024String = 
      "F488FD584E49DBCD20B49DE49107366B336C380D451D0F7C88B31C7C5B2D8EF6"+
      "F3C923C043F0A55B188D8EBB558CB85D38D334FD7C175743A31D186CDE33212C"+
      "B52AFF3CE1B1294018118D7C84A70A72D686C40319C807297ACA950CD9969FAB"+
      "D00A509B0246D3083D66A45D419F9C7CBD894B221926BAABA25EC355E92F78C7";
   static BigInteger skip1024Modulus = new BigInteger(skip1024String, 16);
   static BigInteger skip1024Base = BigInteger.valueOf(2);
   
   static DHParameterSpec sDHParameterSpec = new DHParameterSpec(skip1024Modulus, skip1024Base);
   
   static final String transformationType = "DESede/CBC/PKCS5Padding";

   static void loadProvider()
   {
      int prefPos = Security.addProvider(new com.sun.crypto.provider.SunJCE());
      if(debug)
         System.out.println("Provider was added at position:" + prefPos);
   }
   
   static KeyPair genDHKeyPair() throws GeneralSecurityException
   {
      KeyPairGenerator kpg = KeyPairGenerator.getInstance("DiffieHellman");
      kpg.initialize(sDHParameterSpec);
      KeyPair keyPair = kpg.genKeyPair();
      return keyPair;
   }
   
   static PublicKey unencodePublicKey(byte[] pubKeyEncoded) throws GeneralSecurityException
   {
      KeyFactory keyFac = KeyFactory.getInstance("DiffieHellman");
      X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyEncoded);
      PublicKey pubKey = keyFac.generatePublic(x509KeySpec);
      return pubKey;
   }
}
