/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/Xplat.java $
  $Revision: 24 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncpv2r.clx.*;
import com.novell.service.session.*;
import com.novell.service.toolkit.jcl.NWLong;
import com.novell.service.toolkit.jcl.NWVersion;
import com.novell.java.lang.IntegerBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

/**
 * Provides static attribute values and environment keys for Xplat-based
 * providers.
 *
 * <p>All the attribute ID variables (with _ATTR_ID suffix) that
 * have a CONN_ or DCK_ prefix are operational and will not usually be
 * returned by the Session.getAttributes() method. Operational attributes
 * are those attributes that are normally only returned when explicitly
 * requested in the attrIds[] parameter of the
 * Session.getAttributes(java.lang.String) method. Alternatively, all
 * attributes (including operational attributes) are always returned
 * from the getAttributes() method that takes no parameters if the
 * FORCE_OPERATIONAL_ATTRIBUTES variable (environment key) value is set
 * to TRUE.
 * 
 * @see #FORCE_OPERATIONAL_ATTRIBUTES
 * @see Session#getAttributes(java.lang.String[] attrIds)
 */
public class Xplat
{
   // SessionEnv
   /**
    * Environment key used for changing the behavior of XplatUtil sessions
    * during Session.getSession()operations by passing an existing domain
    * name.
    *
    * <p>Certain sessions need to lookup a new domain name on an existing
    * session. This operation is normally handled automatically, but
    * can be forced if needed. A case where this needs to be forced is
    * when routing on a network keeps certain file servers from seeing
    * other file servers.
    *
    * <p>(LOOKUP_DOMAIN =
      "com.novell.service.session.xplat.LookupDomain")
    *
    * <p>Example:
    *    LOOKUP_DOMAIN, "MY_SERVER"
    * </p>
    * @see  SessionEnv
    */
   public final static String LOOKUP_DOMAIN =
      "com.novell.service.session.xplat.LookupDomain";

   /**
    * Environment key used for changing the behavior of XplatUtil Sessions
    * during Session.getSession()operations by passing an existing domain
    * address.
    *
    * <p>As an alternative to LOOKUP_DOMAIN, DOMAIN_ADDRESS allows Sessions
    * to be opened by directly accessing their address.
    *
    * <p>NOTE: In the case of NDSServerSessionState, the DOMAIN_ADDRESS is
    * not inherited from the parent environment because in Xplat Sessions
    * each Session must have it's own unique address.
    *
    * <p>(DOMAIN_ADDRESS =
      "com.novell.service.session.xplat.DomainAddress")
    *
    * <p>Example:
    *    DOMAIN_ADDRESS, new Address(Address.TYPE_IPX, new byte[]
    *       ({01, 01, 01, 01, 00, 00, 00, 00, 00, 01, 05, 51}));
    * </p>
    * @see  SessionEnv
    */
   public final static String DOMAIN_ADDRESS =
      "com.novell.service.session.xplat.DomainAddress";

   /**
    * Environment key used for changing the behavior of XplatUtil sessions
    * during Session.getAttributes() operations by forcing operational
    * attributes to be returned when all attributes are requested.
    *
    * <p>Operational attributes are those attributes that are normally only
    * returned when explicitly requested. By setting this environment key's
    * value to TRUE, these attributes are always returned from the
    * Session.getAttributes() method that takes no parameters.
    *
    * <p>(FORCE_OPERATIONAL_ATTRIBUTES =
    *    "com.novell.service.session.xplat.OperationalAttributes")
    *
    * <p>Example:
    *    FORCE_OPERATIONAL_ATTRIBUTES, "TRUE"
    * </p>
    * @see  SessionEnv
    */
   public final static String FORCE_OPERATIONAL_ATTRIBUTES =
      "com.novell.service.session.xplat.OperationalAttributes";

   /**
    * Attribute ID describing the preferred tree name stored by the
    * underlying requester. The associated value is a String.
    *
    * <p>(PREFERRED_TREE_NAME_ATTR_ID = "PREFERRED_TREE_NAME")
    *
    * @see  SessionAttr
    * @see  Session#getAttributes
    */
   public static final String PREFERRED_TREE_NAME_ATTR_ID = "PREFERRED_TREE_NAME";

   /**
    * Attribute ID describing the preferred server name stored by the
    * underlying requester. The associated value is a String.
    *
    * <p>(PREFERRED_SERVER_NAME_ATTR_ID = "PREFERRED_SERVER_NAME")
    *
    * @see  SessionAttr
    * @see  Session#getAttributes
    */
   public static final String PREFERRED_SERVER_NAME_ATTR_ID = "PREFERRED_SERVER_NAME";

   // SessionAttr
   // Connections
   /**
    * Attribute ID describing the raw authentication state of a session's
    * connection. This is an operational attribute ID. The associated value
    * is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_AUTHENTICATION_STATE_ATTR_ID = "CONN_AUTHENT_STATE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_AUTHENTICATION_STATE_ATTR_ID =
      "CONN_AUTHENT_STATE";

   /**
    * Attribute ID describing the raw broadcast state of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_BROADCAST_STATE_ATTR_ID = "CONN_BROADCAST_STATE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_BROADCAST_STATE_ATTR_ID =
      "CONN_BROADCAST_STATE";

   /**
    * Attribute ID describing the raw connection reference
    * of a Session's connection. This is an operational attribute ID.
    * The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_CONNECTION_REFERENCE_ATTR_ID = "CONN_REFERENCE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_CONNECTION_REFERENCE_ATTR_ID =
      "CONN_REFERENCE";

   /**
    * Attribute ID describing the raw tree name of a Session's connection.
    * This is an operational attribute ID. The associated value is a String.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_TREE_NAME_ATTR_ID = "CONN_TREE_NAME")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_TREE_NAME_ATTR_ID =
      "CONN_TREE_NAME";

   /**
    * Attribute ID describing the raw connection number of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_CONNECTION_NUMBER_ATTR_ID = "CONN_NUMBER")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_CONNECTION_NUMBER_ATTR_ID =
      "CONN_NUMBER";

   /**
    * Attribute ID describing the raw user ID of a Session's connection.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_USER_ID_ATTR_ID = "CONN_USER_ID")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_USER_ID_ATTR_ID =
      "CONN_USER_ID";

   /**
    * Attribute ID describing the raw server name of a Session's connection.
    * This is an operational attribute ID. The associated value is a String.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_SERVER_NAME_ATTR_ID = "CONN_SERVER_NAME")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_SERVER_NAME_ATTR_ID =
      "CONN_SERVER_NAME";

   /**
    * Attribute ID describing the raw NDS state of a Session's connection.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_NDS_STATE_ATTR_ID = "CONN_NDS_STATE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_NDS_STATE_ATTR_ID =
      "CONN_NDS_STATE";

   /**
    * Attribute ID describing the raw maximum packet size of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_MAX_PACKET_SIZE_ATTR_ID = "CONN_MAX_PACKET_SIZE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_MAX_PACKET_SIZE_ATTR_ID =
      "CONN_MAX_PACKET_SIZE";

   /**
    * Attribute ID describing the raw license state of a Session's connection.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_LICENSE_STATE_ATTR_ID = "CONN_LICENSE_STATE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_LICENSE_STATE_ATTR_ID =
      "CONN_LICENSE_STATE";

   /**
    * Attribute ID describing the raw round trip time of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_DISTANCE_ATTR_ID = "CONN_DISTANCE")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_DISTANCE_ATTR_ID =
      "CONN_DISTANCE";

   /**
    * Attribute ID describing the raw server version of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is a Version.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_SERVER_VERSION_ATTR_ID = "CONN_SERVER_VERSION")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_SERVER_VERSION_ATTR_ID =
      "CONN_SERVER_VERSION";

   /**
    * Attribute ID describing the raw server address of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Address.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_SERVER_ADDRESS_ATTR_ID = "CONN_SERVER_ADDRESS")</p>
    *
    * @see  SessionAttr
    */
   public static final String CONN_SERVER_ADDRESS_ATTR_ID =
      "CONN_SERVER_ADDRESS";

   /*
    * Attribute ID describing the raw server IP address of a Session's
    * connection. This is an operational attribute ID. The associated
    * value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_SERVER_IP_ADDRESS_ATTR_ID = "CONN_SERVER_IP_ADDRESS")</p>
    *
    * @see  SessionAttr
    */
//   public static final String CONN_SERVER_IP_ADDRESS_ATTR_ID =
//      "CONN_SERVER_IP_ADDRESS";

   /*
    * Attribute ID describing the raw server ipx address of a Session's
    * connection. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library connection services.
    *
    * <p>(CONN_SERVER_IPX_ADDRESS_ATTR_ID = "CONN_SERVER_IPX_ADDRESS")</p>
    *
    * @see  SessionAttr
    */
//   public static final String CONN_SERVER_IPX_ADDRESS_ATTR_ID =
//      "CONN_SERVER_IPX_ADDRESS";

   // Contexts

   /**
    * Attribute ID describing the raw flags of a Session's context.
    * This is an operational attribute ID. The associated value is an
    * Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_FLAGS_ATTR_ID = "DCK_FLAGS")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_FLAGS_ATTR_ID = "DCK_FLAGS";

   /**
    * Attribute ID describing the raw confidence of a Session's context.
    * This is an operational attribute ID. The associated value is an
    * Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_CONFIDENCE_ATTR_ID = "DCK_CONFIDENCE")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_CONFIDENCE_ATTR_ID = "DCK_CONFIDENCE";

   /**
    * Attribute ID describing the raw name of a Session's context.
    * This is an operational attribute ID. The associated value is a
    * String.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_NAME_CONTEXT_ATTR_ID = "DCK_NAME_CONTEXT")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_NAME_CONTEXT_ATTR_ID = "DCK_NAME_CONTEXT";

   /**
    * Attribute ID describing the raw transport type of a Session's context.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_TRANSPORT_TYPE_ATTR_ID = "DCK_TRANSPORT_TYPE")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_TRANSPORT_TYPE_ATTR_ID =
      "DCK_TRANSPORT_TYPE";

   /**
    * Attribute ID describing the raw referral scope of a Session's context.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_REFERRAL_SCOPE_ATTR_ID = "DCK_REFERRAL_SCOPE")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_REFERRAL_SCOPE_ATTR_ID =
      "DCK_REFERRAL_SCOPE";

   /**
    * Attribute ID describing the raw last connection of a Session's context.
    * This is an operational attribute ID. The associated value is an Integer.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_LAST_CONNECTION_ATTR_ID = "DCK_LAST_CONNECTION")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_LAST_CONNECTION_ATTR_ID =
      "DCK_LAST_CONNECTION";

   /**
    * Attribute ID describing the raw tree name of a Session's context.
    * This is an operational attribute ID. The associated value is a String.
    *
    * <p>This attribute is provided to aid in transition to the
    * cross-platform C library nds context services.
    *
    * <p>(DCK_TREE_NAME_ATTR_ID = "DCK_TREE_NAME")</p>
    *
    * @see  SessionAttr
    */
   public final static String  DCK_TREE_NAME_ATTR_ID = "DCK_TREE_NAME";

   /**
    * Attribute value returned for SESSION_TYPE_ATTR_ID for tree session
    * types.
    *
    * <p>(TREE_SESSION_TYPE = "TREE")</p>
    *
    * @see  SessionAttr
    * @see  com.novell.service.session#SESSION_TYPE_ATTR_ID
    */
   public static final String TREE_SESSION_TYPE = "TREE";

   /**
    * Attribute value returned for SESSION_TYPE_ATTR_ID for server Session
    * types.
    *
    * <p>(SERVER_SESSION_TYPE = "SERVER")</p>
    *
    * @see  SessionAttr
    * @see  com.novell.service.session#SESSION_TYPE_ATTR_ID
    */
   public static final String SERVER_SESSION_TYPE = "SERVER";

   //NOTE: this needs to be fixed as these names are duplicated in calJNI.java

   /**@internal
    */
   public final static int  NW_MAX_OBJECT_NAME_LEN    = 48; // includes null

   /**@internal
    */
   public final static int  NW_MAX_USER_NAME_LEN      = 49;

   /**@internal
    */
   public final static int  NW_MAX_VOLUME_NAME_LEN    = 17;

   /**@internal
    */
   public final static int  NW_MAX_SERVER_NAME_LEN    = 49;

   /**@internal
    */
   public final static int  NW_MAX_TREE_NAME_LEN      = 33;

   /**@internal
    */
   public final static int  NW_MAX_SERVICE_TYPE_LEN   = 49;

   // Bindery Object types come in two forms, wire-format and human-readable

   /**@internal
    */
   public final static int NW_ANY_TYPE = -1;

   /**@internal
    */
   public final static int NW_PRINT_QUEUE_TYPE      = 0x0300;

   /**@internal
    */
   public final static int NW_SERVER_TYPE           = 0x0400;

   /**@internal
    */
   public final static int NW_ARCHIVE_QUEUE_TYPE    = 0x0800;

   /**@internal
    */
   public final static int NW_JOB_QUEUE_TYPE        = 0x0a00;

   /**@internal
    */
   public final static int NDS_TREE_TYPE            = 0x7802;

   /**@internal
    */
   public final static int NDS_TREE                 = 0x6b02;

   /**@internal
    */
   public final static int NW_PRINT_QUEUE_TYPE_HR   = 0x0003;

   /**@internal
    */
   public final static int NW_SERVER_TYPE_HR        = 0x0004;

   /**@internal
    */
   public final static int NW_ARCHIVE_QUEUE_TYPE_HR = 0x0008;

   /**@internal
    */
   public final static int NW_JOB_QUEUE_TYPE_HR     = 0x000a;

   /**@internal
    */
   public final static int NDS_TREE_TYPE_HR         = 0x0278;

   // Need your ID set to -1 on first call to NWScanObject()

   /**@internal
    */
   public final static int NW_FIRST_SCAN_ID  = -1;

   // Bits for bindery object and property flags.
   // Bindery objects and properties can be static or dynamic.

   /**@internal
    */
   public final static int BF_STATIC        = 0x00;

   /**@internal
    */
   public final static int BF_DYNAMIC       = 0x01;

   // Bindery object properties can have one item or a set of items.

   /**@internal
    */
   public final static int BF_ITEM          = 0x00;

   /**@internal
    */
   public final static int BF_SET           = 0x02;

   // Security access levels

   /**@internal
    */
   public final static int BS_ANY_READ      = 0x00;  // anyone can read this

   /**@internal
    */
   public final static int BS_LOGGED_READ   = 0x01;  // only logged in users

   /**@internal
    */
   public final static int BS_OBJECT_READ   = 0x02;  // by same obj or super

   /**@internal
    */
   public final static int BS_SUPER_READ    = 0x03;  // by supervisor only

   /**@internal
    */
   public final static int BS_BINDERY_READ  = 0x04;  // by the bindery only

   /**@internal
    */
   public final static int BS_ANY_WRITE     = 0x00;  // anyone can WRITE this

   /**@internal
    */
   public final static int BS_LOGGED_WRITE  = 0x10;  // only logged in users

   /**@internal
    */
   public final static int BS_OBJECT_WRITE  = 0x20;  // by same obj or super

   /**@internal
    */
   public final static int BS_SUPER_WRITE   = 0x30;  // by supervisor only

   /**@internal
    */
   public final static int BS_BINDERY_WRITE = 0x40;  // by the bindery only

   private Xplat()
   {
   }
}

