/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/XplatSession.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.*;
import com.novell.service.session.nds.NDS;
import com.novell.service.session.bindery.Bindery;

/**@internal
 * A consolidation of Xplat-related statics for use by applications that only
 * require session management of the Xplat-based providers:
 *
 *    com.novell.service.session.bindery
 *    com.novell.service.session.nds
 */
public class XplatSession
{
   /**
    * Attribute id describing the provider of a Session.  The
    * associated value is a String.
    *
    * <p>The value of this attribute id is Session.PROVIDER_NAME_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String PROVIDER_NAME_ATTR_ID =
      Session.PROVIDER_NAME_ATTR_ID;

   /**
    * Attribute id describing the state of a Session.  The
    * associated value is a String.
    *
    * NOTE: The state of a session is ALWAYS subject to change.
    *
    * <p>The value of this attribute id is Session.SESSION_STATE_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String SESSION_STATE_ATTR_ID =
      Session.SESSION_STATE_ATTR_ID;

   /**
    * Attribute id describing the domain name of a Session.  The
    * associated value is a String.
    *
    * <p>The value of this attribute id is Session.DOMAIN_NAME_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String DOMAIN_NAME_ATTR_ID =
      Session.DOMAIN_NAME_ATTR_ID;

   /**
    * Attribute id describing the type of a Session.  The
    * associated value is a String.
    *
    * The session type uniquely identifies sessions at a certain
    * level, including: "INITIAL_SESSION" for all initial sessions, as
    * well as "TREE" and "SERVER" types under the NDS provider, and "SERVER"
    * under the Bindery provider.
    *
    * <p>The value of this attribute id is Session.SESSION_TYPE_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String SESSION_TYPE_ATTR_ID =
      Session.SESSION_TYPE_ATTR_ID;

   /**
    * Type returned for session manager types.
    *
    * <p>The value of this attribute id is Session.MANAGER_SESSION_TYPE
    *
    * @see  SessionAttr
    */
   public static final String MANAGER_SESSION_TYPE =
      Session.MANAGER_SESSION_TYPE;

   /**
    * Type returned for initial session types.
    *
    * <p>The value of this attribute id is Session.INITIAL_SESSION_TYPE
    *
    * @see  SessionAttr
    */
   public static final String INITIAL_SESSION_TYPE =
      Session.INITIAL_SESSION_TYPE;

   /**
    * Attribute id describing the "realness" of a Session.  The
    * associated value is a Boolean.
    *
    * "Real" sessions are those sessions whose domain name is non-
    * deterministic.  Sessions of type SESSION_MANAGER and INITIAL_SESSION
    * are NOT considered "real" sessions.
    *
    * <p>The value of this attribute id is Session.IS_REAL_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String IS_REAL_ATTR_ID =
      Session.IS_REAL_ATTR_ID;

   /**
    * Attribute id describing the state of a session.  The associated value is
    * a Boolean.
    *
    * <p>The value of this attribute id is
    * Authenticatable.IS_AUTHENTICATED_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String IS_AUTHENTICATED_ATTR_ID =
      Authenticatable.IS_AUTHENTICATED_ATTR_ID;

   /**
    * Attribute id describing the user name of a Session.  The
    * associated value is a String.
    *
    * <p>The value of this attribute id is Authenticatable.USER_NAME_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String USER_NAME_ATTR_ID =
      Authenticatable.USER_NAME_ATTR_ID;

   /**
    * Provider name for the Bindery provider.
    *
    * <p>The value of this attribute value is Bindery.PROVIDER_NAME
    *
    * @see  SessionAttr
    */
   public static final String BINDERY_PROVIDER_NAME =
      Bindery.PROVIDER_NAME;

   /**
    * Class name for Bindery initial session.
    *
    * <p>The value of this attribute value is Bindery.INITIAL_SESSION
    *
    * @see  SessionAttr
    */
   public static final String BINDERY_INITIAL_SESSION =
      Bindery.INITIAL_SESSION;

   /**
    * Attribute id describing the raw authentication state of a Session's
    * connection.  The associated value is an Integer.
    *
    * <p>The value of this attribute id is NDS.TREE_NAME_ATTR_ID
    *
    * @see  SessionAttr
    */
   public static final String TREE_NAME_ATTR_ID =
      NDS.TREE_NAME_ATTR_ID;

   /**
    * Provider name for the NDS provider.
    *
    * <p>The value of this attribute value is NDS.PROVIDER_NAME
    *
    * @see  SessionAttr
    */
   public static final String NDS_PROVIDER_NAME =
      NDS.PROVIDER_NAME;

   /**
    * Class name for NDS initial session.
    *
    * <p>The value of this attribute value is NDS.INITIAL_SESSION
    *
    * @see  SessionAttr
    */
   public static final String NDS_INITIAL_SESSION =
      NDS.INITIAL_SESSION;

   /**
    * Environment key used for changing the behavior of XplatUtil sessions
    * during getSession()operations by passing an existing domain name.
    *
    * Certain sessions need to lookup a new domain name on an existing
    * session.  This operation is normally handled automatically, but
    * can be forced if needed.  A case where this needs to be forced is
    * when routing on a network keeps certain file servers from seeing
    * other file servers.
    *
    * <p>Example:
    *    LOOKUP_DOMAIN,
    *    "MY_SERVER"
    *
    * @see  SessionEnv
    */
   public final static String LOOKUP_DOMAIN =
      Xplat.LOOKUP_DOMAIN;

   /**
    * Environment key used for changing the behavior of XplatUtil sessions
    * during getSession()operations by passing an existing domain name.
    *
    * An alternative to LOOKUP_DOMAIN, DOMAIN_ADDRESS allows sessions to
    * be opened by directly accessing their address.
    *
    * <p>Example:
    *    DOMAIN_ADDRESS,
    *    new Address(
    *       Address.TYPE_IPX,
    *       new byte[] ({01, 01, 01, 01, 01, 00, 00, 00, 00, 00, 01, 05, 51)};
    *
    * @see  SessionEnv
    */
   public final static String DOMAIN_ADDRESS =
      Xplat.DOMAIN_ADDRESS;

   /**
    * Type returned for tree session types.
    *
    * <p>The value of this attribute value is Xplat.TREE_SESSION_TYPE
    *
    * @see  SessionAttr
    */
   public static final String TREE_SESSION_TYPE =
      Xplat.TREE_SESSION_TYPE;

   /**
    * Type returned for server session types.
    *
    * <p>The value of this attribute value is Xplat.SERVER_SESSION_TYPE
    *
    * @see  SessionAttr
    */
   public static final String SERVER_SESSION_TYPE =
      Xplat.SERVER_SESSION_TYPE;
}


