
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/Syntax.java $
  $Revision: 4 $
  $Modtime: 4/23/98 3:48p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming;


import java.util.Properties;


/** @internal
 * Repository for jndi syntax strings
 */
public interface Syntax
{
   String DIRECTION = "jndi.syntax.direction";
   String SEPARATOR = "jndi.syntax.separator";
   String SEPARATOR2 = "jndi.syntax.separator2";
   String ESCAPE = "jndi.syntax.escape";
   String IGNORE_CASE = "jndi.syntax.ignorecase";
   String TRIM_BLANKS = "jndi.syntax.trimblanks";
   String BEGIN_QUOTE = "jndi.syntax.beginquote";
   String END_QUOTE = "jndi.syntax.endquote";
   String BEGIN_QUOTE2 = "jndi.syntax.beginquote2";
   String END_QUOTE2 = "jndi.syntax.endquote2";
   String AVA_SEPARATOR = "jndi.syntax.separator.ava";
   String TYPEVAL_SEPARATOR = "jndi.syntax.separator.typeval";

   /**
    *
    */
   public Properties getProperties ();

   /**
    *
    */
   public String getDirection ();

   /**
    *
    */
   public String getSeparator ();

   /**
    *
    */
   public String getSeparator2 ();

   /**
    *
    */
   public boolean getIgnoreCase ();

   /**
    *
    */
   public boolean getTrimBlanks ();

   /**
    *
    */
   public String getEscape ();

   /**
    *
    */
   public String getBeginQuote ();

   /**
    *
    */
   public String getEndQuote ();

   /**
    *
    */
   public String getBeginQuote2 ();

   /**
    *
    */
   public String getEndQuote2 ();

   /**
    *
    */
   public String getAvaSeparator ();

   /**
    *
    */
   public String getTypevalSeparator ();

} /* Syntax */


