
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/directory/DirContextWrapper.java $
  $Revision: 1 $
  $Modtime: 4/22/98 8:38a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.directory;


import java.util.Hashtable;

import javax.naming.Name;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import javax.naming.directory.DirContext;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

import com.novell.utility.naming.ContextWrapper;


/** @internal
 * The DirContextWrapper class provides "type-safe" containment of a 
 * DirContextWrappable object.
 *
 * This class implements the DirContext interface.  The methods of 
 * DirContextWrapper call the DirContextWrappable implementation.
 */
public class DirContextWrapper extends ContextWrapper implements DirContext
{
   /**
    *
    */
   protected DirContextWrapper (
         DirContextWrappable impl)
   {
      super (impl);

   } /* DirContextWrapper () */


   // ******************** DirContext Interface ********************

   /**
    *
    */
   public Attributes getAttributes (
         String name)
      throws NamingException
   {
      return (getAttributes (name, null));
   }

   /**
    *
    */
   public Attributes getAttributes (
         Name name)
      throws NamingException
   {
      return (getAttributes (name, null));
   }

   /**
    *
    */
   public Attributes getAttributes (
         String name,
         String[] attrIds)
      throws NamingException
   {
      return (getAttributes (new CompositeName(name), attrIds));
   }

   /**
    *
    */
   public Attributes getAttributes (
         Name name,
         String[] attrIds)
      throws NamingException
   {
      return (((DirContext) impl).getAttributes (name, attrIds));
   }

   /**
    *
    */
   public void modifyAttributes (
         String name,
         int mod_op,
         Attributes attrs)
      throws NamingException
   {
      modifyAttributes (new CompositeName (name), mod_op, attrs);
   }

   /**
    *
    */
   public void modifyAttributes (
         Name name,
         int mod_op,
         Attributes attrs)
      throws NamingException
   {
      ((DirContext) impl).modifyAttributes (name, mod_op, attrs);
   }

   /**
    *
    */
   public void modifyAttributes (
         String name,
         ModificationItem[] mods)
      throws NamingException
   {
      modifyAttributes (new CompositeName (name), mods);
   }

   /**
    *
    */
   public void modifyAttributes (
         Name name,
         ModificationItem[] mods)
      throws NamingException
   {
      ((DirContext) impl).modifyAttributes (name, mods);
   }

   /**
    *
    */
   public void bind (
         String name,
         Object object,
         Attributes attrs)
      throws NamingException
   {
      bind (new CompositeName (name), object, attrs);
   }

   /**
    *
    */
   public void bind (
         Name name,
         Object object,
         Attributes attrs)
      throws NamingException
   {
      ((DirContext) impl).bind (name, object, attrs);
   }

   /**
    *
    */
   public void rebind (
         String name,
         Object object,
         Attributes attrs)
      throws NamingException
   {
      rebind (new CompositeName (name), object, attrs);
   }

   /**
    *
    */
   public void rebind (
         Name name,
         Object object,
         Attributes attrs)
      throws NamingException
   {
      ((DirContext) impl).rebind (name, object, attrs);
   }

   /**
    *
    */
   public DirContext createSubcontext (
         String name,
         Attributes attrs)
      throws NamingException
   {
      return (createSubcontext (new CompositeName (name), attrs));
   }

   /**
    *
    */
   public DirContext createSubcontext (
         Name name,
         Attributes attrs)
      throws NamingException
   {
      return (((DirContext) impl).createSubcontext (name, attrs));
   }

   /**
    *
    */
   public DirContext getSchema (
         String name)
      throws NamingException
   {
      return (getSchema (new CompositeName (name)));
   }

   /**
    *
    */
   public DirContext getSchema (
         Name name)
      throws NamingException
   {
      return (((DirContext) impl).getSchema (name));
   }

   /**
    *
    */
   public DirContext getSchemaClassDefinition (
         String name)
      throws NamingException
   {
      return (getSchemaClassDefinition (new CompositeName (name)));
   }

   /**
    *
    */
   public DirContext getSchemaClassDefinition (
         Name name)
      throws NamingException
   {
      return (((DirContext) impl).getSchemaClassDefinition (name));
   }

   /* *************** searches *************** */

   /**
    *
    */
   public NamingEnumeration search (
         String name,
         Attributes matchingAttributes)
      throws NamingException
   {
      return (search (name, matchingAttributes, null));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         Attributes matchingAttributes)
      throws NamingException
   {
      return (search (name, matchingAttributes, null));
   }

   /**
    *
    */
   public NamingEnumeration search (
         String name,
         Attributes matchingAttributes,
         String[] attributesToReturn)
      throws NamingException
   {
      return (search (
                  new CompositeName (name), 
                  matchingAttributes, 
                  attributesToReturn));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         Attributes matchingAttributes,
         String[] attributesToReturn)
      throws NamingException
   {
      return (((DirContext) impl).search (name, matchingAttributes, attributesToReturn));
   }

   /**
    *
    */
   public NamingEnumeration search (
         String name,
         String filter,
         SearchControls cons)
      throws NamingException
   {
      return (search (new CompositeName (name), filter, cons));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         String filter,
         SearchControls cons)
      throws NamingException
   {
      return (((DirContext) impl).search (name, filter, cons));
   }

   /**
    *
    */
   public NamingEnumeration search (
         String name,
         String filterExpr,
         Object [] filterArgs,
         SearchControls cons)
      throws NamingException
   {
      return (search (
                  new CompositeName (name),
                  filterExpr,
                  filterArgs,
                  cons));
   }

   /**
    *
    */
   public NamingEnumeration search (
         Name name,
         String filterExpr,
         Object [] filterArgs,
         SearchControls cons)
      throws NamingException
   {
      return (((DirContext) impl).search (name, filterExpr, filterArgs, cons));
   }


} /* DirContextWrapper */


