/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/directory/StaticClassDefContext.java $
  $Revision: 3 $
  $Modtime: 10/04/99 9:53a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.directory;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;


/** @internal
 * Class definition context for an abstract system (intended to be
 * subclassed).
 *
 * <p>This class is designed to be the class definition for a static schema.
 * It inherits from StaticSchemaContext to simplify and reuse the code for
 * handling the wide variety of Context and DirContext methods.
 * </p>
 *
 * <p>See com.novell.service.bindery.naming.BinderyObjectClassDef for an example of
 * how to subclass this class for a class definition.
 * </p>
 */
public class StaticClassDefContext extends StaticSchemaContext
{
   // This variable maintains the complete list of attributes available.
   // This array may be setup using initAttributes ().
   protected javax.naming.directory.Attribute attrs[];

   /**
    *
    */
   public StaticClassDefContext (
         String name)
   {
      super (name);
   }

   /**
    * Allows a subclass to reuse the construction of the attribute list.
    *
    * @param   attrNames         (in) Custom attribute names list.
    * @param   attrValues        (in) Custom attribute value list. This is
    *                            an array of arrays for multiple value attrs.
    */
   public void initAttributes (
         String attrNames[],
         Object attrValues[][])
   {
      // Initialize the attrs array using the attrNames and attrValues arrays
      attrs = new Attribute [attrNames.length];
      for (int i = 0; i < attrNames.length; i++)
      {  // Add an attribute to the attrs array
         attrs [i] = new javax.naming.directory.BasicAttribute (attrNames [i]);
         for (int j = 0; j < attrValues [i].length; j++)
         {  // Add the values to the new attribute
            attrs [i].add (attrValues [i][j]);
         }
      }

   } /* initAttributes() */

   /* ***********************************************************************
    * DirContext Methods (overriding those in StaticSchemaContext)
    ************************************************************************/
   public Attributes getAttributes (
         Name name,
         String[] attrIds)
      throws NamingException
   {
      Attributes attrSet = new NAttributes ();

      // Determine what attributes the caller wants
      if (null == attrIds)
      {  // The caller wants everything so give it to him
         for (int i = 0; i < attrs.length; i++)
            attrSet.put (attrs [i]);
      }
      else
      {  // The caller has selected a set of attributes to be returned
         for (int i = 0; i < attrIds.length; i++)
         {  // Check each attr ID the caller passed
            for (int j = 0; j < attrs.length; j++)
            {  // Check the caller's attr ID against our set
               if (attrIds[i].equals (attrs[j].getID ()))
               {
                  attrSet.put (attrs[j]);    // found it so add it
                  break;                     // Done with inner loop
               }
               // NOTE: What should we do if the caller's attr ID is bogus?
            }
         }
      }
      return (attrSet);
   }

} /* StaticClassDefContext */


