/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/io/NoSubordinateAccessException.java $
  $Revision: 3 $
  $Modtime: 9/13/99 4:31p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;

import java.io.IOException;

/**
 * Signals that subordinate streams access to the given device is not 
 * supported.
 * 
 * <p>The DataAccessable interface provides support for Input/Output
 * streams and random access to the data of the DataAccessable object.
 * There are two modes of opening access to these devices. First is to
 * open the actual DataAccessable object. The second is to open
 * subordinate access to the DataAccessable object. Some data objects,
 * such as a File, might not support the second type of open (subordinate)
 * and would throw this exception.</p>
 *
 * @see RandomAccess
 * @see NInputStream
 * @see NOutputStream
 */
 
public class NoSubordinateAccessException extends IOException
{
   /**
    * Constructs a NoSubordinateAccessException object with no
    * detail message. 
    */
    
   public NoSubordinateAccessException()
   {
   }


   /**
    * Constructs a NoSubordinateAccessException object with the
    * specified detail message. 
    *
    * @param s The detail message.
    */
    
   public NoSubordinateAccessException(String s)
   {
      super(s);
   }
}   