/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/NoAuthenticatorChannelServiceException.java $
  $Revision: 5 $
  $Modtime: 5/21/98 9:44p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

/**@internal
 *
 * This exception is thrown if no authentication responder was found at
 * the configured location.
 *
 *
 * @author  Jan Sture Nielsen
 * @version 1.0.0 97/11/01
 *
 * @see AuthenticatorException
 */
public class NoAuthenticatorChannelServiceException extends AuthenticatorException
{
  /**
   * default constructor
   */
   public NoAuthenticatorChannelServiceException()
   {
      super(I2L.getString(XMsg.NO_AUTHENTICATOR_CHANNEL_SERVICE));
   }

  /**
   * constructor with message
   *
   * @param message message associated with exception
   */
   public NoAuthenticatorChannelServiceException(String message)
   {
      super(message);
   }

   /**
    * constructor with message and a root cause
    *
    * @param message message associated with the exception
    * @param exception root cause exception
    */
   public NoAuthenticatorChannelServiceException(String message,java.lang.Throwable exception)
   {
      super(message,exception);
   }

   /**
    * constructor with a root cause
    *
    * @param exception root cause exception
    */
   public NoAuthenticatorChannelServiceException(java.lang.Throwable exception)
   {
      this(I2L.getString(XMsg.NO_AUTHENTICATOR_CHANNEL_SERVICE),exception);
   }
}
