/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/TrusteeEnumerator.java $
  $Revision: 5 $
  $Modtime: 12/13/99 3:34p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import java.util.Enumeration;

/** 
 * Provides an enumeration of the Trustees from a given directory entry.
 *
 * <p>Trustees can be associated with a given directory entry (file or
 * directory), which can have multiple Trustees.</p>
 *
 * @see Trustee
 */

public interface TrusteeEnumerator extends Enumeration
{
/* *************************************************************************
* constants
***************************************************************************/

   /**
    * Attribute ID of the TrusteeEnumerator.
    *
    * <p>(ATTRIBUTE_ID = com.novell.service.file.nw.Trustee.ATTRIBUTE_ID)
    * 
    * @see Trustee
    */

   public static final String ATTRIBUTE_ID =
      Trustee.ATTRIBUTE_ID;

   /**
    * Schema Name of the TrusteeEnumerator.
    *
    * <p>(SCHEMA_BINDING_NAME =
    *       com.novell.service.file.nw.Trustee.SCHEMA_BINDING_NAME)
    *
    * @see Trustee
    */

   public static final String SCHEMA_BINDING_NAME =
      Trustee.SCHEMA_BINDING_NAME;

   /**
    * Schema Syntax of the TrusteeEnumerator.
    *
    * <p>(COMPARE_SYNTAX_STRING =
    *       com.novell.service.file.nw.Trustee.COMPARE_SYNTAX_STRING)
    *
    * @see ExtendedAttribute
    */

   public static final String COMPARE_SYNTAX_STRING =
      Trustee.COMPARE_SYNTAX_STRING;

/* *************************************************************************
* public abstract methods
***************************************************************************/

   /**
    * Return the typed (nextElement) Trustee value.
    *
    * @return The next Trustee in the enumeration.
    *
    * @exception NoSuchElementException If no nextElement trustee
    *            value exists.
    *
    * @see Trustee
    */

   public Trustee next();

   /**
    * Returns a boolean indicating if more elements are available.
    *
    * @return A boolean set to TRUE if more trustee elements
    *         will be returned; otherwise FALSE is returned.
    *
    * @see Trustee
    */

   public boolean hasMore();

}
