/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/cal/CalJNI.java $
  $Revision: 20 $
  $Modtime: 1/05/01 1:11p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2r.cal;

import java.util.*;
import com.novell.java.lang.*;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;

import com.novell.service.session.xplat.CallsServiceRemote.*;
/** @internal
* Native method declarations
*/

public class CalJNI
{
/* *************************************************************************
* Bindery natives
****************************************************************************/
   // Miscellaneous string lengths

   public final static int  NW_MAX_OBJECT_NAME_LEN    = 48; // includes null
   public final static int  NW_MAX_USER_NAME_LEN      = 49;
   public final static int  NW_MAX_VOLUME_NAME_LEN    = 17;
   public final static int  NW_MAX_SERVER_NAME_LEN    = 49;
   public final static int  NW_MAX_TREE_NAME_LEN      = 33;
   public final static int  NW_MAX_SERVICE_TYPE_LEN   = 49;

   // Bindery Object types come in two forms, wire-format and human-readable

   public final static int NW_ANY_TYPE = -1;

   public final static int NW_PRINT_QUEUE_TYPE      = 0x0300;
   public final static int NW_SERVER_TYPE           = 0x0400;
   public final static int NW_ARCHIVE_QUEUE_TYPE    = 0x0800;
   public final static int NW_JOB_QUEUE_TYPE        = 0x0a00;
   public final static int NDS_TREE_TYPE            = 0x7802;
   public final static int NDS_TREE                 = 0x6b02;

   public final static int NW_PRINT_QUEUE_TYPE_HR   = 0x0003;
   public final static int NW_SERVER_TYPE_HR        = 0x0004;
   public final static int NW_ARCHIVE_QUEUE_TYPE_HR = 0x0008;
   public final static int NW_JOB_QUEUE_TYPE_HR     = 0x000a;
   public final static int NDS_TREE_TYPE_HR         = 0x0278;


   // Need your ID set to -1 on first call to NWScanObject()

   public final static int NW_FIRST_SCAN_ID  = -1;


   // Bits for bindery object and property flags.

   // Bindery objects and properties can be static or dynamic.

   public final static int BF_STATIC        = 0x00;
   public final static int BF_DYNAMIC       = 0x01;

   // Bindery object properties can have one item or a set of items.

   public final static int BF_ITEM          = 0x00;
   public final static int BF_SET           = 0x02;

   // Security access levels

   public final static int BS_ANY_READ      = 0x00;  // anyone can read this
   public final static int BS_LOGGED_READ   = 0x01;  // only logged in users
   public final static int BS_OBJECT_READ   = 0x02;  // by same obj or super
   public final static int BS_SUPER_READ    = 0x03;  // by supervisor only
   public final static int BS_BINDERY_READ  = 0x04;  // by the bindery only
   public final static int BS_ANY_WRITE     = 0x00;  // anyone can WRITE this
   public final static int BS_LOGGED_WRITE  = 0x10;  // only logged in users
   public final static int BS_OBJECT_WRITE  = 0x20;  // by same obj or super
   public final static int BS_SUPER_WRITE   = 0x30;  // by supervisor only
   public final static int BS_BINDERY_WRITE = 0x40;  // by the bindery only

public static native boolean areSLPCallsAvailable();

public static native int NWGetObjectNamesBeginA(int type, IntegerBuffer handle);

public static native int NWGetObjectNamesNextA(
   IntegerBuffer handle,
   IntegerBuffer bufLen, // in - how much space to allocate to hold the next name
                         // out - if an overflow, set to how much space needed
   StringBuffer buf      // out - will be set with the next name
   );

public static native int NWGetObjectNamesEndA(IntegerBuffer handle);

 public static native int NWAddObjectToSet(
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType);

// NWChangeObjectPassword is in client.java
// public static native int NWChangeObjectPassword(
//       int connHandle,
//       String objName,
//       int objType,
//       String oldPassword,
//       String newPassword);

 public static native int NWChangeObjectSecurity(
      /*in*/   int connHandle,
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity);

 public static native int NWChangePropertySecurity(
      /*in*/   int connHandle,
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String propertyName,
      /*in*/   int   newPropertySecurity);

 public static native int NWCloseBindery (
      /*in*/   int connHandle);

 public static native int NWCreateObject (
      /*in*/   int connHandle,
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity);

 public static native int NWCreateProperty (
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity);

 public static native int NWDeleteObject (
      /*in*/   int connHandle,
      /*in */  String objName,
      /*in*/   int objType);

 public static native int NWDeleteObjectFromSet (
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType);

 public static native int NWDeleteProperty (
      /*in*/   int      connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName);

 public static native int NWDisallowObjectPassword (
      /*in*/   int connHandle,
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword);

 public static native int NWGetBinderyAccessLevel (
      /*in*/   int      connHandle,
      /*out*/  IntegerBuffer accessLevel,
      /*out*/  IntegerBuffer objID);

 public static native int NWGetObjectDiskSpaceLeft (
      /*in*/   int   connHandle,
      /*in*/   int   objID,
      /*out*/  IntegerBuffer systemElapsedTime,
      /*out*/  IntegerBuffer unusedDiskBlocks,
      /*out*/  IntegerBuffer restrictionEnforced);

 public static native int NWGetObjectID (
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*out*/  IntegerBuffer  objID);

   public static native int NWGetObjectName (
       /*in*/   int connHandle,
       /*in*/   int objID,
       /*out*/  StringBuffer objName,
       /*out*/  IntegerBuffer objType);

   public static native int NWIsObjectInSet (
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType);

   public static native int NWOpenBindery(
      /*in*/   int connHandle);

   public static native int NWReadPropertyValue(
      /*in*/   int connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*out*/  byte[]  segmentData,
      /*out*/  IntegerBuffer   moreSegments,
      /*out*/  IntegerBuffer      flags);

 public static native int NWRenameObject(
      /*in*/   int connHandle,
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType);
//done
   public static native int NWScanObject
   (
      /*in*/      int conn,
      /*in*/      String searchName,
      /*in*/      int searchType,
      /*out*/     IntegerBuffer objID,              // optional
      /*out*/     StringBuffer objName,             // optional
      /*out*/     IntegerBuffer objType,            // optional
      /*out*/     IntegerBuffer hasPropertiesFlag,  // optional
      /*out*/     IntegerBuffer objFlags,           // optional
      /*out*/     IntegerBuffer objSecurity         // optional
   );

 public static native int NWScanProperty(
      /*in*/   int      connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   searchPropertyName,
      /*out*/  IntegerBuffer   iterHandle,
      /*out*/  StringBuffer      propertyName,
      /*out*/  IntegerBuffer      propertyFlags,
      /*out*/  IntegerBuffer      propertySecurity,
      /*out*/  IntegerBuffer      valueAvailable,
      /*out*/  IntegerBuffer      moreFlag);

 public static native int NWWritePropertyValue(
      /*in*/   int      connHandle,
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments);

/* *************************************************************************
* File natives
****************************************************************************/

   public static native int NWGetNSEntryInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask,
      DirectoryEntryInformation entryInfo
   );

   public static native int NWScanNSEntryInfo
   (
      int connHandle,
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask,
      DirectoryEntryInformation entryInfo
   );

   public static native int NWGetVolumeName
   (
      int connHandle,
      int volNumber,
      String[] volName  // return a new string in first element
   );

   public static native int NWGetVolumeNumber
   (
      int connHandle,
      String volName,
      int[] volNumber   // return vol number in first element
   );

   public static native int NWGetNSLoadedList
   (
      int connHandle,
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   );

   public static native int NWOpenCreateNSEntry
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchAttributes,
      int createAttributes,
      int accessRights,
      int[] fileHandle
   );

   public static native int NWOpenNSEntry
   (
      int connHandle,
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchAttributes,
      int createAttributes,
      int accessRights,
      int[] fileHandle
   );

   public static native int NWDeleteNSEntry
   (
      int connHandle,
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   );

   public static native int NWNSRename
   (
      int connHandle,
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   );

   public static native int allocEAHandle ();

   public static native int allocEAFFStruct ();

   public static native void freePtr
   (
      int mallocedPtr
   );

   public static native int NWOpenEA
   (
      int connHandle,
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   );

   public static native int NWCloseEA
   (
      int EAHandle
   );

   public static native int NWReadEA
   (
      int EAHandle,
      byte[] buf,
      int off,
      int len,
      int[] totalEASize,
      int[] bytesRead
   );

   public static native int NWWriteEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   );

   public static native int NWFindFirstEA
   (
      int conn,
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   );

   public static native int NWFindNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   );

   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public static native int NWScanForTrustees
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorStruct tEnum
   );

   // assumes that there are already 102 elements allocated in 'list'
   public static native int NWGetDirSpaceLimitList
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   );

   public static native int NWSetDirSpaceLimit
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   );

   public static native int NWSetCompressedFileSize
   (
      int connHandle,   // only valid under NETX
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   );

   public static native int NWAddTrustee
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   );

   public static native int NWDeleteTrustee
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   );

   public static native int NWGetNSInfo
   (
      int connHandle,
      int volume,
      int nameSpace
//      NSInformation info
   );

   // the 'data' array must be 512 bytes long
   public static native int NWReadNSInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // output parameter
   );

   // the 'data' array must be 512 bytes long
   public static native int NWWriteNSInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   );

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public static native int NWReadExtendedNSInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   );

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public static native int NWWriteExtendedNSInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   );

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public static native int NWSetNSEntryDOSInfo
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   );

   public static native int NWGetVolumeInfoWithNumber
   (
      int connHandle,
      int volNumber,
      VolumeInformationBase info
   );

   public static native int NWGetExtendedVolumeInfo
   (
      int connHandle,
      int volNumber,
      VolumeInformationExtended info
   );

   public static native int NWGetDirSpaceInfo
   (
      int connHandle,
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   );

   public static native int NWGetDiskUtilization
   (
      int connHandle,
      int objID,
      int volNum,
      VolumeUtilization data
   );

   public static native int NWGetObjDiskRestrictions
   (
      int connHandle,
      int volNumber,
      int objectId,
      VolumeRestriction data
   );

   public static native int NWScanVolDiskRestrictions2
   (
      int connHandle,
      int volNumber,
      VolumeRestrictionEnumeratorStruct data
   );

   public static native int NWRemoveObjectDiskRestrictions
   (
      int connHandle,
      int volNumber,
      int objectId
   );

   public static native int NWSetObjectVolSpaceLimit
   (
      int connHandle,
      int volNumber,
      int objectId,
      int restriction
   );

   public static native int NWSMMountVolume
   (
      int connHandle,
      String volName,
      int[] volNumber
   );

   public static native int NWSMDismountVolumeByName
   (
      int connHandle,
      String volName
   );

   public static native int NWScanMountedVolumes
   (
      int connHandle,
      int startVolNumber,
      int[][] numbers,
      String[][] names,
      int[] nextVolNumber
   );

   public static native int NWAllocTempNSDirHandle
   (
      int connHandle,
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   );

   public static native int NWDeallocateDirectoryHandle
   (
      int connHandle,
      int dirHandle
   );

   public static native int NWScanForDeletedFiles
   (
      int connHandle,
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   );

   public static native int NWPurgeDeletedFile
   (
      int connHandle,
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   );

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public static native int NWRecoverDeletedFile
   (
      int connHandle,
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   );

   public static native int NWGetEffectiveRights
   (
      int connHandle,
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   );

   public static native int NWGetObjectEffectiveRights
   (
      int connHandle,
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   );

   public static native int NWScanObjectTrusteePaths
   (
      int connHandle,
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   );

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   public static native int NWGetNCPExtensionInfoByName (
      /*in*/   int                     conn,
      /*out*/  NCPExtensionInfoImpl   extension);

   public static native int NWNCPExtensionRequest(
      /*in*/   int      conn,
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength,
      /*out*/  Object[] replyHolder); //replyHolder is a one element array

   public static native int NWScanNCPExtensions (
      /*in*/   int                     conn,
      /*out*/  NCPExtensionInfoImpl   extension);

/* *************************************************************************
* QMS natives
****************************************************************************/

   public static native int NWAbortServicingQueueJob2
   (
      /*in*/   int   conn,
      /*in*/   int   QueueID,
      /*in*/   int   JobNumber,
      /*in*/   int   fileHandle
   );

   public static native int NWAttachQueueServerToQueue
   (
      /*in*/   int   conn,
      /*in*/   int   queueID
   );

   public static native int NWChangeQueueJobEntry2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   NWQueueJob   job
   );

   public static native int NWChangeQueueJobPosition2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*in*/   int   newJobPos
   );

   public static native int NWChangeToClientRights2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber
   );

   public static native int NWCloseFileAndAbortQueueJob2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*in*/   int   fileHanadle
   );

   public static native int NWCloseFileAndStartQueueJob2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*in*/   int   fileHandle
   );

   public static native int NWCreateQueue
   (
      /*in*/   int   conn,
      /*in*/   String queueName,
      /*in*/   int   queueType,
      /*in*/   int   dirPath,
      /*in*/   String path,
      /*out*/  IntegerBuffer queueID
   );

   public static native int NWCreateQueueFile2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in/out*/ NWQueueJob job,
      /*out*/  IntegerBuffer fileHandle
   );

   public static native int NWDestroyQueue
   (
      /*in*/   int   conn,
      /*in*/   int   queueID
   );

   public static native int NWDetachQueueServerFromQueue
   (
      /*in*/   int   conn,
      /*in*/   int   queueID
   );

   public static native int NWFinishServicingQueueJob2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*in*/   int   fileHandle
   );

   public static native int NWGetQueueJobFileSize2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*out*/  IntegerBuffer fileSize
   );

   public static native int NWGetQueueJobList2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   queueStartPos,
      /*out*/  QueueJobListReply job
   );

   public static native int NWReadQueueCurrentStatus2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*out*/  IntegerBuffer queueStatus,
      /*out*/  IntegerBuffer numberOfJobs,
      /*out*/  IntegerBuffer numberOfServers,
      /*out*/  int[] serverIDlist,
      /*out*/  int[] serverConnList
   );

   public static native int NWReadQueueJobEntry2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber,
      /*out*/  NWQueueJob job
   );

   public static native int NWRemoveJobFromQueue2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   jobNumber
   );

   public static native int NWServiceQueueJob2
   (
      /*in*/   int   conn,
      /*in*/   int   queueID,
      /*in*/   int   targetJobType,
      /*out*/  NWQueueJob job,
      /*out*/  IntegerBuffer fileHandle
   );

   public static native int NWSetQueueCurrentStatus2
   (
      /*in*/   int conn,
      /*in*/   int queueID,
      /*in*/   int queueStatus
   );

/* *************************************************************************
* Server natives
****************************************************************************/

   public static native int NWGetFileServerVersionInfo(
         int connHandle,
         CVersionInfo info);

   public static native int NWGetFileServerInfo(
         int connHandle,
         CNWFSEFileServerInfo info);

   public static native int NWGetFileServerLoginStatus(
         int connHandle,
         BooleanBuffer info);

   public static native int NWSMLoadNLM(
         int connHandle,
         String loadCommand);

   public static native int NWSMUnloadNLM(
         int connHandle,
         String NLMName);

   public static native int NWGetFileServerDescription(
         int connHandle,
         StringBuffer companyName,
         StringBuffer revision,
         StringBuffer revisionDate,
         StringBuffer copyrightNotice);

   public static native int NWGetFileServerDateAndTime(
         int connHandle,
         Object[] holder); //holder is a one element array

   public static native int NWSetFileServerDateAndTime(
         int connHandle,
         int year,
         int month,
         int day,
         int hour,
         int minute,
         int second);

   public static native int NWOpenSemaphore(
      int connHandle,
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount);

   public static native int NWExamineSemaphore(
      int connHandle,
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount);

   public static native int NWWaitOnSemaphore(
      int connHandle,
      int semaphoreHandle,
      int timeOutValue);

   public static native int NWSignalSemaphore(
      int connHandle,
      int semaphoreHandle);

   public static native int NWCloseSemaphore(
      int connHandle,
      int semaphoreHandle);
}
