
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <jni.h>

#include <ntypes.h>

#include "JNIString.h"

#include <nwdsdefs.h>
#include <nwdsdc.h>
#include <nwdsbuft.h>
#include <nwdsdsa.h>

#ifdef N_PLAT_NLM
#  include "nlmsem.h"
#endif


#include "jncpWire.h"
#include "jdsEntryList.h"

#include "com_novell_service_jncpv2r_net_NetJNI.h"


#define NETPKG         "com/novell/service/jncpv2r/net/"
#define JNCPPKG        "com/novell/service/jncp/"


/***** com_novell_service_jncpv2r_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    JDSListObjectEntries
 * Signature: (IIILjava/lang/String;I[[Lcom/novell/service/jncpv2r/net/NetEntryInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_JDSListObjectEntries
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint           threadGroup,
   /*in*/   jint           context,
   /*in*/   jint           sNetEntryInfo,
   /*in*/   jstring        objectName,
   /*in*/   jint           bufferSize,
   /*out*/  jobjectArray   entries
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS+1];
   nint32 cIterationHandle = NO_MORE_ITERATIONS;
   // NJCL variables
   JDSList list = NULL;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext (&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   list = jdsEntryListCreate (env, (pNetEntryInfo) sNetEntryInfo);

   do
   {
      // NWNet variables
      pBuf_T cSubordinates;

      // Alloc Buf_T
      if (N_SUCCESS != (ccode = NWDSAllocBuf (bufferSize, &cSubordinates)))
      {
         goto CLEANUP;
      }

      // Make C API call
      ccode = NWDSList (
                           (NWDSContextHandle) context,
                           (pnstr8) cObjectName,
                           &cIterationHandle,
                           cSubordinates);

      list->AddBuffer (list, cSubordinates);

   } while (N_SUCCESS == ccode && NO_MORE_ITERATIONS != cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      (*env)->SetObjectArrayElement (
                                       env,
									   entries,
									   0,
									   list->GetObjects (list));
   }

CLEANUP:

   list->Destroy (&list);

#ifdef N_PLAT_NLM
   unwrapContext (saveThreadGroup);

EXIT:
#endif

   return (ccode);

} /* NJCLListObjectEntries () */


