/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetPostalAddressJNI.h"


/* public final class NetPostalAddress
 *    extends NdsPostalAddress
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetPostalAddress)
NetPostalAddressCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsString;
   jclass clsNetPostalAddress;
   //NJCL variables
   pNetPostalAddress sNetPostalAddress;

   {
      jclass clsNetPostalAddressLR;

      clsNetPostalAddressLR = (*env)->FindClass (env, NETSYNTAXPKG "NetPostalAddress");
      clsNetPostalAddress = (*env)->NewGlobalRef (env, clsNetPostalAddressLR);
      (*env)->DeleteLocalRef (env, clsNetPostalAddressLR);
   }

   {
      jclass clsStringLR;

      clsStringLR = (*env)->FindClass (env, "java/lang/String");
      clsString = (*env)->NewGlobalRef (env, clsStringLR);
      (*env)->DeleteLocalRef (env, clsStringLR);
   }

   sNetPostalAddress = (pNetPostalAddress) sysMalloc (sizeof (NetPostalAddress));

   if (NULL != sNetPostalAddress)
   {
      // assign jclass variables
      sNetPostalAddress->cls = clsNetPostalAddress;
      sNetPostalAddress->clsString = clsString;

      // assign jfieldID variables
      sNetPostalAddress->ID.value = (*env)->GetFieldID (env, clsNetPostalAddress, "value", "[Ljava/lang/String;");
   }
   return (sNetPostalAddress);

} /* NetPostalAddressCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetPostalAddressCreate
(
   JNIEnv *env,
   pNetPostalAddress sNetPostalAddress,
   pBuf_T buf
)
{
   // JNI variables
   jobjectArray values;
   // NWNet variables
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netPostalAddress = (*env)->AllocObject (env, sNetPostalAddress->cls);

   {
      // NWNet variables
      nuint32 i, length, count;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);

      count = jncpGetInt32 (env, curPos, limit);

      values = (*env)->NewObjectArray (env, count, sNetPostalAddress->clsString, NULL);

      for (i = 0; i < count; i++)
      {
         jstring value;

         NAlign32 (curPos);
         (*env)->SetObjectArrayElement (
                                             env,
											 values,
									 (jsize) i,
									        (value = jncpGetString (env, curPos, limit)));
         (*env)->DeleteLocalRef (env, value);
      }

      (*env)->SetObjectField (
                                 env,
                                 netPostalAddress,
                                 sNetPostalAddress->ID.value,
                       (jobject) values);
      (*env)->DeleteLocalRef (env, values);
   }

   return (netPostalAddress);

} /* NetPostalAddressCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef pnchar Postal_Address_T[6];
 *
 * java array:
 *  | address | address | address | address | address | address
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetPostalAddress_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   Postal_Address_T *postalAddress;
   nuint8 *postalAddressPtr, *ptr;
   nuint i;

   // NdsMemory.handle - PostalAddress C struct
   postalAddress = (Postal_Address_T *) cValue;

   // malloc temporary buffer
   postalAddressPtr = (nuint8 *) sysMalloc (cLength);
   ptr = postalAddressPtr;

   // build the temporary buffer
   for (i = 0; i < NUM_POSTAL_ADDRESS_ELEMENTS; i++)
   {
      unicpy((unicode *) ptr, (unicode *) (*postalAddress)[i]);
      ptr += (unilen ((unicode *) ptr) + 1) * sizeof(unicode);
   }

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) postalAddressPtr);

   // free temporary buffer
   sysFree (postalAddressPtr);

   return (byteArray);

} /* fromCStruct () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetPostalAddress_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   Postal_Address_T *postalAddress;
   nchar *dataPtr;
   nuint32 i;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Postal_Address_T);

   // malloc NetMemory buffer
   postalAddress = (Postal_Address_T *) sysMalloc (length);
   dataPtr = (pnchar)(postalAddress) + sizeof(Postal_Address_T);

   // build the buffer
   for (i = 0; i < NUM_POSTAL_ADDRESS_ELEMENTS; i++)
   {
      (*postalAddress)[i] = dataPtr;
      unicpy((unicode *) dataPtr, (unicode *) ptr);
      length = (unilen ((unicode *) ptr) + 1) * sizeof(unicode);
      ptr += length;
      dataPtr += length;
   }

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) postalAddress);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


