/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetTimestampJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetTimestamp
 *    extends NdsTimestamp
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetTimestamp)
NetTimestampCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetTimestamp;
   jclass clsNetTimestampLR;
   //NJCL variables
   pNetTimestamp sNetTimestamp;

   clsNetTimestampLR = (*env)->FindClass (env, NETSYNTAXPKG "NetTimestamp");
   clsNetTimestamp = (*env)->NewGlobalRef (env, clsNetTimestampLR);
   (*env)->DeleteLocalRef (env, clsNetTimestampLR);

   sNetTimestamp = (pNetTimestamp) sysMalloc (sizeof (NetTimestamp));

   if (NULL != sNetTimestamp)
   {
      // assign jclass variables
      sNetTimestamp->cls = clsNetTimestamp;

      // assign jfieldID variables
      sNetTimestamp->ID.wholeSeconds = (*env)->GetFieldID (env, clsNetTimestamp, "wholeSeconds", "J");
      sNetTimestamp->ID.replicaNumber = (*env)->GetFieldID (env, clsNetTimestamp, "replicaNumber", "I");
      sNetTimestamp->ID.eventId = (*env)->GetFieldID (env, clsNetTimestamp, "eventId", "I");
   }
   return (sNetTimestamp);

} /* NetTimestampCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetTimestampCreate
(
   JNIEnv *env,
   pNetTimestamp sNetTimestamp,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netTimestamp = (*env)->AllocObject (env, sNetTimestamp->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetLongField (
                                 env,
                                 netTimestamp,
                                 sNetTimestamp->ID.wholeSeconds,
                         (jlong) jncpGetInt32 (env, curPos, limit));
   }

   {
      (*env)->SetIntField (
                              env,
                              netTimestamp,
                              sNetTimestamp->ID.replicaNumber,
                       (jint) jncpGetInt16 (env, curPos, limit));
   }

   {
      (*env)->SetIntField (
                              env,
                              netTimestamp,
                              sNetTimestamp->ID.eventId,
                       (jint) jncpGetInt16 (env, curPos, limit));
   }

   return (netTimestamp);

} /* NetTimestampCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    nuint32  wholeSeconds;
 *    nuint16  replicaNum;
 *    nuint16  eventID;
 * } TimeStamp_T, N_FAR *pTimeStamp_T;
 *
 * java array:
 *  | wholeSeconds | replicaNum | eventID
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetTimestamp_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   nuint8 *timestampPtr;

   // malloc temporary buffer
   if (NULL != (timestampPtr = (nuint8 *) sysMalloc (cLength)))
   {
      // NWNet variables
      pTimeStamp_T timestamp;
      nuint8 *ptr;

      // NdsMemory.handle - ReplicaPointer C struct
      timestamp = (pTimeStamp_T) cValue;

      ptr = timestampPtr;

      // build the temporary buffer
      *(nuint32 *)(ptr) = timestamp->wholeSeconds;
      ptr += sizeof (nuint32);

      *(nuint16 *)(ptr) = timestamp->replicaNum;
      ptr += sizeof (nuint16);

      *(nuint16 *)(ptr) = timestamp->eventID;
      ptr += sizeof (nuint16);

      // allocate return byte[]
      byteArray = (*env)->NewByteArray (env, cLength);

      // copy temporary buffer to byte[]
      (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) timestampPtr);

      // free temporary buffer
      sysFree (timestampPtr);
   }

   return (byteArray);

} /* toByteArray () */

N_GLOBAL_FUNC_C (nptr) 
NetTimestamp_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pTimeStamp_T timestamp;

   // get byte[]
   byteArray = ptr = (*env)->GetByteArrayElements (env, values, 0);

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(TimeStamp_T);

   // malloc NetMemory buffer
   timestamp = (pTimeStamp_T) sysMalloc (length);

   // build the buffer
   timestamp->wholeSeconds = *(nuint32 *) ptr;
   ptr += sizeof(nuint32);

   timestamp->replicaNum = *(nuint16 *) ptr;
   ptr += sizeof(nuint16);

   timestamp->eventID = *(nuint16 *) ptr;
   ptr += sizeof(nuint16);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) timestamp);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


