/* **************************************************************************

  %name:  qmsJNI.c %
  %version:  12 %
  %date_modified: Tue Jan  6 15:10:34 1998 %
 
  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
#include <jni.h>
#include "com_novell_service_jncpv2r_cal_CalJNI.h"
#include <ntypes.h>
#include <nwqms.h>
#include "JNIString.h"
#include "jncp.h"

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWCreateQueueFile2
 * Signature: (IILcom/novell/service/qms/NWQueueJob;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWCreateQueueFile2
(
   JNIEnv   *env, 
   jobject  obj, 
   jint     conn, 
   jint     QueueID, 
   jobject  JobInfo, 
   jobject  fileHandle
)
{
   NWCCODE ccode;
   NWQueueJobStruct cJob;
   jclass clazz;
   jbyteArray tempByteArray;
   jmethodID mid;
   jstring javaString;
   punicode uniStr;
   NWFILE_HANDLE cFileHandle;

   clazz = (*env)->GetObjectClass(env,JobInfo);

   mid = (*env)->GetMethodID( env, clazz,"getClientTask","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientTask = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getClientStation","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientStation = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getClientID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getTargetServerID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.targetServerID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getTargetExecutionTimeBytes", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);

   mid = (*env)->GetMethodID( env, clazz,"getJobEntryTimeBytes", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);

   mid = (*env)->GetMethodID( env, clazz,"getJobNumber","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobNumber = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobType","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobType = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobPosition","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobPosition = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobControlFlags","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobControlFlags = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobFileName","()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);

   mid = (*env)->GetMethodID( env, clazz,"getJobFileHandle","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobFileHandle = (*env)->CallIntMethod( env, JobInfo, mid );
                         
   mid = (*env)->GetMethodID( env, clazz,"getServicingServerStation","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerStation = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getServicingServerTask","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerTask = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getServicingServerID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobDescription", "()Ljava/lang/String;" );
   if (0 == mid)
   {
      return(-1);
   }
   javaString = (*env)->CallObjectMethod( env, JobInfo, mid );
   uniStr = (punicode) (*env)->GetStringChars( env, javaString, 0 );
   ccode = __UnicodeToLocalStr (
               cJob.jobDescription,
               sizeof( cJob.jobDescription ),
               uniStr,
               (*env)->GetStringLength( env, javaString ));
   if (ccode != 0)
      return( (jint) ccode );
   (*env)->ReleaseStringChars( env, javaString, uniStr );
   
   mid = (*env)->GetMethodID( env, clazz,"getClientRecordArea", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);

   ccode = NWCreateQueueFile2(conn, QueueID, &cJob, &cFileHandle);
   if (N_SUCCESS == ccode)
   {
      unicode uniBuf[50];  // big enough for the description

      // now copy all the data from cJob(c) into JobInfo(java)
      mid = (*env)->GetMethodID( env, clazz,"setClientTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientTask );

      mid = (*env)->GetMethodID( env, clazz,"setClientStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientStation );

      mid = (*env)->GetMethodID( env, clazz,"setClientID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientID );

      mid = (*env)->GetMethodID( env, clazz,"setTargetServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.targetServerID );

      // Allocate a known array size for use in setting all byteArray fields
      tempByteArray = (*env)->NewByteArray( env, 150 );
      if (tempByteArray == NULL)  // out of memory
         return (-1);

      mid = (*env)->GetMethodID( env, clazz,"setJobEntryTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setTargetExecutionTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobNumber","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobNumber );

      mid = (*env)->GetMethodID( env, clazz,"setJobType","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, (nuint32) cJob.jobType );

      mid = (*env)->GetMethodID( env, clazz,"setJobPosition","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, (nuint32) cJob.jobPosition );

      mid = (*env)->GetMethodID( env, clazz,"setJobControlFlags","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, (nuint32) cJob.jobControlFlags );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileName","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileHandle","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobFileHandle );
                         
      mid = (*env)->GetMethodID( env, clazz,"setServicingServerStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerStation );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerTask );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerID );

      mid = (*env)->GetMethodID( env, clazz,"setJobDescription","(Ljava/lang/String;)V" );
      if (0 == mid)
      {
         return(-1);
      }
      ccode = __LocalToJavaStr (
                  env,
                  &javaString,
                  uniBuf,
                  cJob.jobDescription);
      if (ccode != 0)
         return( (jint) ccode );
      (*env)->CallVoidMethod( env, JobInfo, mid, javaString );

      mid = (*env)->GetMethodID( env, clazz,"setClientRecordArea","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );
      
      // Send the file handle back.
      clazz = (*env)->GetObjectClass(env, fileHandle);
      mid = (*env)->GetMethodID(env, clazz, "setValue","(I)V");
      (*env)->CallVoidMethod(env, fileHandle, mid, cFileHandle);
   }
   return( (jint) ccode );
}  /* NWCreateQueueFile2 */ 

/*    2
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWCloseFileAndAbortQueueJob2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWCloseFileAndAbortQueueJob2
(
   JNIEnv   *env, 
   jobject  obj, 
   jint     conn, 
   jint     queueID, 
   jint     jobNumber, 
   jint     fileHandle
)
{
   
   NWCCODE ccode;

   ccode = NWCloseFileAndAbortQueueJob2(conn, 
                                        queueID, 
                                        jobNumber,
                                        (NWFILE_HANDLE)fileHandle);

   return(ccode);
                     
}   /* QmsJNI_NWCloseFileAndAbortQueueJob2 */



/*     3
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWCloseFileAndStartQueueJob2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWCloseFileAndStartQueueJob2
(
   JNIEnv   *env,  
   jobject  obj,  
   jint     conn, 
   jint     queueID, 
   jint     jobNumber, 
   jint     fileHandle
)
{
   NWCCODE ccode;

   ccode =NWCloseFileAndStartQueueJob2(conn, 
                                       queueID, 
                                       jobNumber, 
                                       (NWFILE_HANDLE)fileHandle);

   return(ccode);   
}  /*QmsJNI_NWCloseFileAndStartQueueJob2 */ 

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWChangeQueueJobEntry2
 * Signature: (IILcom/novell/service/qms/NWQueueJob;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWChangeQueueJobEntry2
(
   JNIEnv   *env, 
   jobject  obj, 
   jint     conn, 
   jint     QueueID, 
   jobject  JobInfo 
)
{
   NWCCODE ccode;
   NWQueueJobStruct cJob;
   jclass clazz;
   jbyteArray tempByteArray;
   jmethodID mid;
   jstring javaString;
   punicode uniStr;

   clazz = (*env)->GetObjectClass(env,JobInfo);

   mid = (*env)->GetMethodID( env, clazz,"getClientTask","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientTask = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getClientStation","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientStation = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getClientID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.clientID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getTargetServerID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.targetServerID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getTargetExecutionTimeBytes", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);

   mid = (*env)->GetMethodID( env, clazz,"getJobEntryTimeBytes", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);

   mid = (*env)->GetMethodID( env, clazz,"getJobNumber","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobNumber = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobType","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobType = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobPosition","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobPosition = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobControlFlags","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobControlFlags = (nuint16) (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobFileName","()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);

   mid = (*env)->GetMethodID( env, clazz,"getJobFileHandle","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.jobFileHandle = (*env)->CallIntMethod( env, JobInfo, mid );
                         
   mid = (*env)->GetMethodID( env, clazz,"getServicingServerStation","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerStation = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getServicingServerTask","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerTask = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getServicingServerID","()I" );
   if (0 == mid)
   {
      return(-1);
   }
   cJob.servicingServerID = (*env)->CallIntMethod( env, JobInfo, mid );

   mid = (*env)->GetMethodID( env, clazz,"getJobDescription", "()Ljava/lang/String;" );
   if (0 == mid)
   {
      return(-1);
   }
   javaString = (*env)->CallObjectMethod( env, JobInfo, mid );
   uniStr = (punicode) (*env)->GetStringChars( env, javaString, 0 );
   ccode = __UnicodeToLocalStr (
               cJob.jobDescription,
               sizeof( cJob.jobDescription ),
               uniStr,
               (*env)->GetStringLength( env, javaString ));
   if (ccode != 0)
      return( (jint) ccode );
   (*env)->ReleaseStringChars( env, javaString, uniStr );

   mid = (*env)->GetMethodID( env, clazz,"getClientRecordArea", "()[B" );
   if (0 == mid)
   {
      return(-1);
   }
   tempByteArray = (*env)->CallObjectMethod( env, JobInfo, mid );
   (*env)->GetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);

   ccode = NWChangeQueueJobEntry2( conn, QueueID, &cJob );
   if (N_SUCCESS == ccode)
   {
      unicode uniBuf[50];  // big enough for job description

      // now copy all the data from cJob(c) into JobInfo(java)
      mid = (*env)->GetMethodID( env, clazz,"setClientTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientTask );

      mid = (*env)->GetMethodID( env, clazz,"setClientStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientStation );

      mid = (*env)->GetMethodID( env, clazz,"setClientID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientID );

      mid = (*env)->GetMethodID( env, clazz,"setTargetServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.targetServerID );

      // Allocate a known array size for use in setting all byteArray fields
      tempByteArray = (*env)->NewByteArray( env, 150 );
      if (tempByteArray == NULL)  // out of memory
         return (-1);

      mid = (*env)->GetMethodID( env, clazz,"setJobEntryTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setTargetExecutionTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobNumber","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobNumber );

      mid = (*env)->GetMethodID( env, clazz,"setJobType","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobType );

      mid = (*env)->GetMethodID( env, clazz,"setJobPosition","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobPosition );

      mid = (*env)->GetMethodID( env, clazz,"setJobControlFlags","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobControlFlags );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileName","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileHandle","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobFileHandle );
                         
      mid = (*env)->GetMethodID( env, clazz,"setServicingServerStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerStation );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerTask );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerID );

      mid = (*env)->GetMethodID( env, clazz,"setJobDescription","(Ljava/lang/String;)V" );
      if (0 == mid)
      {
         return(-1);
      }
      ccode = __LocalToJavaStr (
                  env,
                  &javaString,
                  uniBuf,
                  cJob.jobDescription);
      if (ccode != 0)
         return( (jint) ccode );
      (*env)->CallVoidMethod( env, JobInfo, mid, javaString );

      mid = (*env)->GetMethodID( env, clazz,"setClientRecordArea","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );
   }

   return( (jint) ccode );
} /*QmsJNI_NWChangeQueueJobEntry2 */ 


 /*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWAbortServicingQueueJob2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWAbortServicingQueueJob2
(
   JNIEnv   *env, 
   jobject  obj, 
   jint     conn, 
   jint     QueueID, 
   jint     JobNumber, 
   jint     fileHandle
)
{

   NWCCODE ccode;

   ccode = NWAbortServicingQueueJob2(conn, 
                                     QueueID, 
                                     JobNumber, 
                                     (NWFILE_HANDLE)fileHandle);

   return(ccode);
}  /* NWAbortServicingQueueJob2 */ 

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWChangeQueueJobPosition2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWChangeQueueJobPosition2
(
   JNIEnv *env,  
   jclass obj, 
   jint   conn, 
   jint   queueID, 
   jint   jobNumber, 
   jint   newJobPos
)
{
   NWCCODE ccode;

   ccode = NWChangeQueueJobPosition2(  (NWCONN_HANDLE)conn,
                                       queueID,
                                       jobNumber,
                                       newJobPos);
   return(ccode);
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWGetQueueJobList2
 * Signature: (IIILcom/novell/service/qms/QueueJobListReply;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWGetQueueJobList2
(
   JNIEnv *env,  
   jclass obj, 
   jint   conn, 
   jint   queueID, 
   jint   queueStartPos, 
   jobject job
)
{
   jmethodID mid;
   jclass clazz;
   NWCCODE ccode;
   jintArray jobNumberList;
   QueueJobListReply cJob;

   /* fill in cJob from job */
   clazz = (*env)->GetObjectClass( env, job );
   mid = (*env)->GetMethodID( env, clazz, "getTotalQueueJobs", "()I" );
   cJob.totalQueueJobs = (*env)->CallIntMethod( env, job, mid );

   mid = (*env)->GetMethodID(env, clazz, "getReplyQueueJobNumbers", "()I" );
   cJob.replyQueueJobNumbers = (*env)->CallIntMethod( env, job, mid);

   mid = (*env)->GetMethodID( env, clazz, "getJobNumberList", "()[I" );
   jobNumberList = (*env)->CallObjectMethod( env, job, mid );

   (*env)->GetIntArrayRegion(env,
                             jobNumberList, 
                             0,
                             250,
                             (jint *) cJob.jobNumberList);
   /* end of code that fills in cJob */

   ccode = NWGetQueueJobList2((NWCONN_HANDLE)conn,
                                 queueID,
                                 queueStartPos,
                                 &cJob);
   if (N_SUCCESS == ccode)
   {
        /* fill in job object with cJob info */
      mid = (*env)->GetMethodID(env, clazz, "setTotalQueueJobs", "(I)V" );
      (*env)->CallVoidMethod( env, job, mid, cJob.totalQueueJobs );

      mid = (*env)->GetMethodID( env, clazz, "setReplyQueueJobNumbers", "(I)V" );
      (*env)->CallVoidMethod( env, job, mid, cJob.replyQueueJobNumbers );

      (*env)->SetIntArrayRegion( env,
                                 jobNumberList, 
                                 0,
                                 250,
                                 (jint *) cJob.jobNumberList );

      mid = (*env)->GetMethodID( env, clazz, "setJobNumberList", "([I)V" );
      (*env)->CallVoidMethod( env, job, mid, jobNumberList );
   }
   return( (jint) ccode );
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWReadQueueCurrentStatus2
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;[I;[I;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWReadQueueCurrentStatus2
(
   JNIEnv      *env,  
   jclass      obj, 
   jint        conn, 
   jint        queueID, 
   jobject     queueStatus, 
   jobject     numberOfJobs, 
   jobject     numberOfServers,
   jintArray   serverIDList,
   jintArray   serverConnList
)
{
   NWCCODE  ccode;
   int      i;
   nuint32  cQueueStatus,
            cNumberOfJobs,
            cNumberOfServers,
            cServerIDList[25],
            cServerConnList[25];
   jint     *arrayRef;
   jsize    len;      

   ccode = NWReadQueueCurrentStatus2(  conn, queueID, &cQueueStatus, 
                                       &cNumberOfJobs, &cNumberOfServers,
                                       cServerIDList, cServerConnList );
   if ( 0 == ccode )
   {
      len = (*env)->GetArrayLength( env, serverIDList );
      arrayRef = (*env)->GetIntArrayElements( env, serverIDList, 0 );
      for ( i=0; i < len && i < ( sizeof( cServerIDList ) / sizeof( int ) ); i++ )
      {
         arrayRef[i] = cServerIDList[i];
      }
      (*env)->ReleaseIntArrayElements( env, serverIDList, arrayRef, 0 );
      
      len = (*env)->GetArrayLength( env, serverConnList );
      arrayRef = (*env)->GetIntArrayElements( env, serverConnList, 0 );
      for ( i=0; i < len && i < ( sizeof( cServerConnList ) / sizeof( int ) ); i++ )
      {
         arrayRef[i] = cServerConnList[i];
      }
      (*env)->ReleaseIntArrayElements( env, serverConnList, arrayRef, 0 );
   }
   return( ccode );
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWReadQueueJobEntry2
 * Signature: (IIILcom/novell/service/qms/NWQueueJob;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWReadQueueJobEntry2
(
  JNIEnv    *env,  
  jclass    obj, 
  jint      conn, 
  jint      QueueID, 
  jint      JobNumber, 
  jobject   JobInfo
)
{
   NWCCODE ccode;
   NWQueueJobStruct cJob;
   jclass clazz;
   jbyteArray tempByteArray;
   jmethodID mid;
   jstring javaString;

   ccode = NWReadQueueJobEntry2( conn, QueueID, JobNumber, &cJob );
   if (N_SUCCESS == ccode)
   {
      unicode uniBuf[50];  // for the job description

      // now copy all the data from cJob(c) into JobInfo(java)
      clazz = (*env)->GetObjectClass( env, JobInfo );

      mid = (*env)->GetMethodID( env, clazz,"setClientTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientTask );

      mid = (*env)->GetMethodID( env, clazz,"setClientStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientStation );

      mid = (*env)->GetMethodID( env, clazz,"setClientID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.clientID );

      mid = (*env)->GetMethodID( env, clazz,"setTargetServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.targetServerID );

      // Allocate a known array size for use in setting all byteArray fields
      tempByteArray = (*env)->NewByteArray( env, 152 );
      if (tempByteArray == NULL)  // out of memory
         return (-1);

      mid = (*env)->GetMethodID( env, clazz,"setJobEntryTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setTargetExecutionTime","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobNumber","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobNumber );

      mid = (*env)->GetMethodID( env, clazz,"setJobType","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobType );

      mid = (*env)->GetMethodID( env, clazz,"setJobPosition","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobPosition );

      mid = (*env)->GetMethodID( env, clazz,"setJobControlFlags","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobControlFlags );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileName","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );

      mid = (*env)->GetMethodID( env, clazz,"setJobFileHandle","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.jobFileHandle );
                         
      mid = (*env)->GetMethodID( env, clazz,"setServicingServerStation","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerStation );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerTask","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerTask );

      mid = (*env)->GetMethodID( env, clazz,"setServicingServerID","(I)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod( env, JobInfo, mid, cJob.servicingServerID );

      mid = (*env)->GetMethodID( env, clazz,"setJobDescription","(Ljava/lang/String;)V" );
      if (0 == mid)
      {
         return(-1);
      }
      ccode = __LocalToJavaStr (
                  env,
                  &javaString,
                  uniBuf,
                  cJob.jobDescription);
      if (ccode != 0)
         return( (jint) ccode );
      (*env)->CallVoidMethod( env, JobInfo, mid, javaString );

      mid = (*env)->GetMethodID( env, clazz,"setClientRecordArea","([B)V" );
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->SetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);
      (*env)->CallVoidMethod( env, JobInfo, mid, tempByteArray );
   }

   return( (jint) ccode );
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWRemoveJobFromQueue
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWRemoveJobFromQueue2
(
   JNIEnv *env,  
   jclass obj, 
   jint   conn, 
   jint   queueID, 
   jint   jobNumber
)          
{
   NWCCODE ccode;
   ccode = NWRemoveJobFromQueue2((NWCONN_HANDLE)conn, 
                                 (nuint32)queueID, 
                                 (nuint32)jobNumber);
   return(ccode);
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWSetQueueCurrentStatus2
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWSetQueueCurrentStatus2
(
   JNIEnv   *env,  
   jclass   obj, 
   jint     conn, 
   jint     queueID, 
   jint     queueStatus 
)          
{
   NWCCODE ccode;
   ccode = NWSetQueueCurrentStatus2(conn, 
                                    (nuint32)queueID,
                                    (nuint32)queueStatus);
   return(ccode);
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWCreateQueue
 * Signature: (ILjava/lang/String;IILjava/lang/String;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWCreateQueue
(
   JNIEnv   *env,  
   jclass   obj, 
   jint     conn, 
   jstring  queueName,
   jint     queueType,
   jint     dirPath,
   jstring  path,
   jobject  queueID
)
{
   NWCCODE ccode;
   nstr8 cQueueName[49], cPath[255];
   punicode uniQueueName, uniPath;
   nuint32 cQueueID;
   
   uniQueueName = (punicode) (*env)->GetStringChars( env, queueName, 0 );
   uniPath = (punicode) (*env)->GetStringChars( env, path, 0 );
   
   ccode = __UnicodeToLocalStr (
               cQueueName,
               sizeof( cQueueName ),
               uniQueueName,
               (*env)->GetStringLength( env, queueName ));
   if (ccode != 0)
      goto EXIT;

   ccode = __UnicodeToLocalStr (
               cPath,
               sizeof( cPath ),
               uniPath,
               (*env)->GetStringLength( env, path ));
   if (ccode != 0)
      goto EXIT;

   ccode = NWCreateQueue( conn, cQueueName, (nuint16) queueType, (nuint8) dirPath, cPath, 
                          &cQueueID );
   if ( N_SUCCESS == ccode )                           
   {
      jclass clazz;
      jmethodID mid;
      
      clazz = (*env)->GetObjectClass( env, queueID );
      mid = (*env)->GetMethodID( env, clazz, "setValue", "(I)V");
      (*env)->CallVoidMethod( env, queueID, mid, cQueueID );
   }

EXIT:

   (*env)->ReleaseStringChars( env, queueName, uniQueueName );
   (*env)->ReleaseStringChars( env, path, uniPath );

   return( ccode );
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWDestroyQueue
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWDestroyQueue
(
   JNIEnv *env,  
   jclass obj, 
   jint   conn, 
   jint   queueID
)         
{         
   NWCCODE ccode;
   ccode = NWDestroyQueue(conn, queueID);
   return(ccode);
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWGetQueueJobFileSize2
 * Signature: (IIILcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_cal_CalJNI_NWGetQueueJobFileSize2
(
  JNIEnv  *env,  
  jclass  obj, 
  jint    conn, 
  jint    queueID, 
  jint    jobNumber, 
  jobject fileSize
)
{
   jmethodID mid;
   jclass clazz;
   NWCCODE ccode;
   nuint32 cFileSize;

   ccode = NWGetQueueJobFileSize2(conn, queueID, jobNumber, &cFileSize);
   if (N_SUCCESS == ccode)
   {
      clazz = (*env)->GetObjectClass(env, fileSize);
      mid = (*env)->GetMethodID(env, clazz, "setValue", "(I)V");     
      (*env)->CallVoidMethod(env, fileSize, mid, cFileSize);  
   }  
   return(ccode);
}   

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWAttacheQueueServerToQueue
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWAttachQueueServerToQueue
(
   JNIEnv *env,
   jclass obj,
   jint conn,
   jint queueID
)
{
   NWCCODE ccode;

   ccode = NWAttachQueueServerToQueue (conn, queueID);
   return (ccode);
} // NWAttachQueueServerToQueue ()

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWChangeToClientRights
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWChangeToClientRights2
(
   JNIEnv *env,
   jclass obj,
   jint conn,
   jint queueID,
   jint jobNumber
)
{
   NWCCODE ccode;

   ccode = NWChangeToClientRights2 (
               conn,
               queueID,
               jobNumber);
   return (ccode);
} // NWChangeToClientRights2 ()

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWDetatchQueueServerFromQueue
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWDetachQueueServerFromQueue
(
   JNIEnv *env,
   jclass obj,
   jint conn,
   jint queueID
)
{
   NWCCODE ccode;

   ccode = NWDetachQueueServerFromQueue (conn, queueID);
   return (ccode);
} // NWDetachQueueServerFromQueue ()

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWFinishServicingQueueJob2
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWFinishServicingQueueJob2
(
   JNIEnv *env,
   jclass obj,
   jint conn,
   jint queueID,
   jint jobNumber,
   jint fileHandle
)
{
   NWCCODE ccode;

   ccode = NWFinishServicingQueueJob2 (
               conn,
               queueID,
               jobNumber,
               (NWFILE_HANDLE)fileHandle);
   return (ccode);
} // NWFinishServicingQueueJob2 ()

/*
 * This routine copies the data from the 'C' structure to the Java structure
 * NOTE: This code is duplicated in the older code and should be used instead
 * to reduce the redundancy.
 */

jint CopyQueueJobInfoFromCToJava
(
   JNIEnv    *env,
   NWQueueJobStruct cJob,
   jobject   jobInfo
)
{
   NWCCODE ccode;
   jmethodID mid;
   jclass clazz;
   jstring javaString;
   jbyteArray tempByteArray;
   unicode uniBuf[50];  // for the job description

   // now copy all the data from cJob(c) into jobInfo(java)
   clazz = (*env)->GetObjectClass( env, jobInfo );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setClientTask","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.clientTask );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setClientStation","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.clientStation );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setClientID","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.clientID );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setTargetServerID","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.targetServerID );

   // Allocate a known array size for use in setting all byteArray fields
   if (NULL == (tempByteArray = (*env)->NewByteArray( env, 150 )))
      return (-1);

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobEntryTime","([B)V" )))
      return(-1);
   (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.jobEntryTime);
   (*env)->CallVoidMethod( env, jobInfo, mid, tempByteArray );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setTargetExecutionTime","([B)V" )))
      return(-1);
   (*env)->SetByteArrayRegion(env, tempByteArray, 0, 6, (jbyte *) cJob.targetExecutionTime);
   (*env)->CallVoidMethod( env, jobInfo, mid, tempByteArray );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobNumber","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.jobNumber );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobType","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.jobType );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobPosition","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.jobPosition );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobControlFlags","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.jobControlFlags );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobFileName","([B)V" )))
      return(-1);
   (*env)->SetByteArrayRegion(env, tempByteArray, 0, 14, (jbyte *) cJob.jobFileName);
   (*env)->CallVoidMethod( env, jobInfo, mid, tempByteArray );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobFileHandle","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.jobFileHandle );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setServicingServerStation","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.servicingServerStation );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setServicingServerTask","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.servicingServerTask );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setServicingServerID","(I)V" )))
      return(-1);
   (*env)->CallVoidMethod( env, jobInfo, mid, cJob.servicingServerID );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setJobDescription","(Ljava/lang/String;)V" )))
      return(-1);
   ccode = __LocalToJavaStr (
               env,
               &javaString,
               uniBuf,
               cJob.jobDescription);
   if (ccode != 0)
      return( (jint) ccode );
   (*env)->CallVoidMethod( env, jobInfo, mid, javaString );

   if (0 == (mid = (*env)->GetMethodID( env, clazz,"setClientRecordArea","([B)V" )))
      return(-1);
   (*env)->SetByteArrayRegion(env, tempByteArray, 0, 152, (jbyte *) cJob.clientRecordArea);
   (*env)->CallVoidMethod( env, jobInfo, mid, tempByteArray );
   return (0);
} // CopyQueueJobInfoFromCToJava ()

/*
 * Class:     com_novell_service_jncpv2r_cal_CalJNI
 * Method:    NWServiceQueueJob2
 * Signature: (IIILcom/novell/service/qms/NWQueueJob;Lcom/novell/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWServiceQueueJob2
(
   JNIEnv *env,
   jclass obj,
   jint conn,
   jint queueID,
   jint targetJobType,
   jobject job,
   jobject fileHandle
)
{
   NWCCODE ccode;
   jmethodID mid;
   NWQueueJobStruct cJob;
   NWFILE_HANDLE cFileHandle;
   jclass clazz;

   ccode = NWServiceQueueJob2 (
               conn,
               queueID,
               (nuint16) targetJobType,
               &cJob,
               &cFileHandle);
   if (N_SUCCESS == ccode)
   {
      // Copy the job info back.
      ccode = CopyQueueJobInfoFromCToJava (env, cJob, job);
      if (0 != ccode)
         return (ccode);

      // Send the file handle back.
      clazz = (*env)->GetObjectClass(env, fileHandle);
      mid = (*env)->GetMethodID(env, clazz, "setValue","(I)V");
      (*env)->CallVoidMethod(env, fileHandle, mid, cFileHandle);
   }
   return (ccode);
} // NWServiceQueueJob2 ()

