
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsIteratorInfo.java $
  $Revision: 10 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


/**
 * Encapsulates information about an NdsIterator.
 */
public interface NdsIteratorInfo
{
   /**
    * Determines whether the NdsIterator was created on an NDS v8 server
    * or is running in emulation mode. 
    *
    * @return A boolean set to TRUE if the iterator was created on an
    *         NDS v8 server and thus is scalable; otherwise, set to FALSE
    *         indicating the iterator is running in emulation mode.
    */
   boolean isScalable ();

   /**
    * Determines if the getPosition() and setPosition() methods work
    * for this NdsIterator.
    *
    * @return A boolean set to TRUE if the getPosition() and setPosition()
    *         methods work for this iterator; otherwise, set to FALSE.
    */
   boolean isPositionable ();

} /* NdsIteratorInfo */


