
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsPostalAddress.java $
  $Revision: 9 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;

import java.util.Enumeration;
import java.util.Vector;

import com.novell.service.schema.SchemaSequence;


/**
 * Provides access to values of the Postal Address attribute.
 * It is used for attributes whose values are postal addresses.
 * An attribute value for Postal Address is typically
 * composed of selected attributes from the MHS Unformatted
 * Postal O/R Address version 1 according to Recommendation
 * F.401. The value is limited to 6 lines of 30 characters
 * each, including a Postal Country Name. Normally the
 * information contained in such an address could include a
 * name, street address, city, state or province, postal code
 * and possibly a postal office box number, depending on the
 * specific requirements of the named object. A blank line is
 * a zero-length Unicode string.
 *
 * <p>Two postal addresses match for equality if, and only if,
 * the number of strings in each is the same and all
 * corresponding strings match. For two corresponding strings
 * in the list to match, they must be the same length and
 * their corresponding characters must be identical.
 * In matching attributes that conform to this syntax, NDS
 * omits those spaces that are not significant (leading spaces,
 * trailing spaces, and multiple consecutive internal spaces).
 * NDS stores insignificant spaces with the attribute value.
 * 
 * <p>Matching Rules: Equality</p>
 * 
 * @see NdsSyntaxId
 */
public class NdsPostalAddress 
   implements NdsAttributeValue, SchemaSequence, Cloneable, Serializable
{
   private static final int matchingRules = equality;

  /**
   * @internal
   */
   public static final int postalAddressCount = 6;

  /**
   * @internal
   */
   protected String[] value;

   private String name;


  /**
   * Constructs an NdsPostalAddress object based on the specified
   * value variable.
   * 
   * @param value The value of the postal address to be stored as a
   *              String array. The elements of the address depend
   *              on the specific requirements of the named object.
   */
   public NdsPostalAddress (
         String[] value)
   {
      this.value = (String[]) value.clone ();
   }

  /**
   * @internal
   */
   protected NdsPostalAddress ()
   {
      this.value = new String[postalAddressCount];
   }

   private NdsPostalAddress (
         String name,
         String[] value)
   {
      this.name = name;
      this.value = (String[]) value.clone ();
   }

  /**
   * @internal
   */
   protected NdsPostalAddress (
         NdsPostalAddress aPostalAddress)
   {
      this.value = (String[]) aPostalAddress.value.clone ();
      this.name = aPostalAddress.name;
   }


   // ******************** SchemaValue Interface ********************

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically.
   *
   * The compareTo method does not apply to the Postal Address syntax
   * because this syntax does not support the ordering and substrings
   * matching rules.
   */
   public int compareTo (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * <p>The equals method implements the most discriminating possible
   * equivalence relation on objects; that is, for any reference values
   * X and Y, this method returns TRUE if and only if X and Y refer to
   * the same object (X==Y has the value TRUE).</p>
   * 
   * @param anObject The reference object with which to compare.
   *
   * @return A boolean set to TRUE if and only if the argument is not
   *         NULL and is an NDS integer object that contains the
   *         same value as this object, otherwise set to FALSE.
   */
   public boolean equals (
         Object anObject)
   {
      if ((anObject != null) && (anObject instanceof NdsPostalAddress))
      {
         NdsPostalAddress anotherPostalAddress = (NdsPostalAddress) anObject;

         for (int i = 0; i < postalAddressCount; i++)
         {
            if (false == value[i].equals (anotherPostalAddress.value[i]))
            {
               return (false);
            }
         }
         return (true);
      }
      return (false);
   }

  /**
   * @internal
   */
   public String getName ()
   {
      return (name);
   }

  /**
   * @internal
   */
   public String getSyntaxId ()
   {
      return (NdsSyntaxId.POSTAL_ADDRESS);
   }


   // ******************** SchemaSequence Interface ********************

   /**
    * Returns the number of elements in this sequence.
    *
    * @return The number of elements in this sequence as an int.
    */
   public int count ()
   {
      return (value.length);
   }

   /**
    * Returns an enumeration of this sequence's values.
    *
    * @return An enumeration of this sequence's values.
    */
   public Enumeration getValues ()
   {
      Vector vector = new Vector ();

      for (int i = 0; i < postalAddressCount; i++)
         vector.addElement (value[i]);
      return (vector.elements ());
   }


   // ******************** NdsAttributeValue Interface ********************

  /**
   * Compares two Objects using the approximate matching rule.
   * 
   * The approximate method does not apply to the Postal Address
   * syntax because this syntax does not support the approximate
   * equals matching rule.
   */
   public boolean approximate (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Returns the int that represents this NDS syntax ID.
   *
   * @return The syntax ID as an int.
   */
   public int getNdsSyntaxId ()
   {
      return (NdsSyntaxId.POSTAL_ADDRESS_ID);
   }

  /**
   * Checks to see if this object supports the specified
   * matching rules. The Postal Address syntax supports only
   * the equality matching rule.
   *
   * @param matchingRules The set of matching rules to check.
   *
   * @return A Boolean set to TRUE if the matching rules for this
   *         object are equal to the matchingRules parameter.
   */
   public boolean supportsMatchingRules (
         int matchingRules)
   {
      if ((matchingRules & this.matchingRules) == matchingRules)
      {
         return (true);
      }
      return (false);
   }


   // ******************** Object Class ********************

  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * Them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      try
      {
         NdsPostalAddress postal = (NdsPostalAddress) super.clone ();

         postal.value[0] = this.value[0];
         postal.value[1] = this.value[1];
         postal.value[2] = this.value[2];
         postal.value[3] = this.value[3];
         postal.value[4] = this.value[4];
         postal.value[5] = this.value[5];

         postal.name = this.name;

         return (postal);
      }
      catch (CloneNotSupportedException e)
      {
         // this shouldn't happen, since we are Cloneable
         throw (new InternalError ());
      }

   } /* clone () */

  /**
   * Generates a string representation of the object. It
   * returns a string that textually represents the object.
   * The result should be a concise but informative
   * representation that is easy to read.
   *
   * @return The String representation of the object.
   */
   public String toString ()
   {
      return (value[0] + ";\n"
                  + value [1] + ";\n"
                  + value [2] + ";\n"
                  + value [3] + ";\n"
                  + value [4] + ";\n"
                  + value [5]);
   }


   // ******************** NdsPostalAddress Class ********************

  /**
   * Returns the String array of Postal Address values stored in
   * the NDS attribute.
   *
   * @return The String array of Postal Address values.
   */
   public String[] getPostalAddress ()
   {
      return (value);
   }

} /* NdsPostalAddress */


