/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetQueueDirContext.java $
  $Revision: 16 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.util.Hashtable;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;
import com.novell.service.qms.naming.*;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2r.net.*;
import com.novell.java.lang.*;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ReferenceFactory;

import com.novell.service.session.Session;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionManager;
import com.novell.service.session.SessionManagerFactory;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.jncpv2r.net.BasicNetService;

import com.novell.service.session.*;



/** @internal
 *
 */
public class NetQueueDirContext extends NetDirContext
{
   private Object nnsp;

   /**
    *
    */
   protected NetQueueDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, objectInfo, netEnvironment);

   }

   /** @internal
    *
    * The server name is the last component of the "Host Server" attribute
    * value.  The component has also had types removed.
    */
   private String getServerName ()
      throws NamingException
   {
      Name target = ((NdsName)nameParser.parse (getHostServer ())).
                                          getTypelessName ();
      return (target.get (target.size () - 1));

   } /* getServerName () */

   /**
    *
    */
   private String getHostServer ()
      throws NamingException
   {
      String attributeIds[];
      Attributes attributeSet;
      Attribute hostServer;
      NdsDistinguishedName hostServerValue;

      attributeIds = new String[1];
      attributeIds[0] = "Host Server";
      attributeSet = this.getAttributes ("", attributeIds);

      hostServer = attributeSet.get ("Host Server");

      hostServerValue = (NdsDistinguishedName) hostServer.getAll ().nextElement ();

      return (hostServerValue.getDistinguishedName ());
   }

   /**
    *
    */
   private Session getHostServerSession ()
      throws NamingException, SessionException, RemoteException
   {
      SessionManager manager = environment.getSessionManager ();
      Session session = manager.findSession (getTreeName ());

      return (session.getSession (getHostServer ()));
   }

   /**
    *
    */
   public NetService getService (String serverName)
      throws NamingException
   {
      NetService service = null;
      
      try
      {
         Session session = getSession (serverName);

         service = (NetService) session.getService (BasicNetService.KEY);
      }
      catch (SessionException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }
      
      return (service);

   } /* getService () */

   /**
    *
    */
   public Session getSession (String serverName)
      throws NamingException
   {
      SessionManager manager;
      SessionEnv environment = new SessionEnv ();
      Session session = null;

      try
      {
         Session found;

         environment.put (
                        SessionEnv.INITIAL_SESSION_FACTORY,
                        "com.novell.service.session.nds.NDSInitialSessionFactory:" +
                        "com.novell.service.session.bindery.BinderyInitialSessionFactory");

         manager = SessionManagerFactory.getSessionManager (environment);

         // Search for NDSInitialSession
         SessionAttrs as = new SessionAttrs ();
         as.add (Session.DOMAIN_NAME_ATTR_ID,"com.novell.service.session.nds.NDSInitialSession");
         as.add (Session.SESSION_TYPE_ATTR_ID,"INITIAL_SESSION");

         SessionEnumerator enum = manager.search (as);
         if (enum.hasMoreElements ())
         {
            found = enum.next();
         }
         else
         {
            throw (new NSIException ());
         }
         
         session = found.getSession (serverName);
      }
      catch (Exception e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }

      return (session);

   } /* getSession () */

   String getResourceID ()
      throws NamingException
   {
      // Get a Session based on the server name
      // Get a Service from that Session
      // call mapNameToID from that Service
      NetService service = getService (getServerName ());
      IntegerBuffer objectID = new IntegerBuffer(0);

      try
      {
         service.mapNameToID (
                           distinguishedName,
                           objectID );
      }
      catch (SessionException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NamingException ne = new AuthenticationException ();

         ne.setRootCause (e);
         throw (ne);
      }

      return (objectID.toString ());
      
   } /* getResourceID () */


   // ******************** NDSComponentDirContext methods ********************

   /**
    *
    */
   protected Object getNNSP ()
      throws NamingException
   {
      if (null == nnsp)
      {
         try
         {
            Class cls;
            Hashtable properties;
            ReferenceFactory referenceFactory;
            Reference reference;

            // Guarantee NDS server session
            Session session = getHostServerSession ();

            cls = Class.forName ("com.novell.service.qms.naming.ReferenceFactoryImpl");
            referenceFactory = (ReferenceFactory) cls.newInstance ();

            properties = ((NetEnvironment) environment).getEnvironment();

            properties.put (Context.PROVIDER_URL, getServerName ());
            properties.put (QMSEnvironment.QUEUE_ID, getResourceID ());

            // set SESSION_OBJECT to NDS Server Session
            properties.put (Environment.SESSION_OBJECT, session);

            reference = referenceFactory.createReference (properties);

            nnsp = NamingManager.getObjectInstance (reference, null, null, properties);
         }
         catch (Exception e)
         {
            // nnsp remains null
         }
      }
      return (nnsp);
   }

} /* NetQueueDirContext */


