/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetReplicaAttribute.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;

/** @internal
 *
 */
public class NetReplicaAttribute extends BasicAttribute
{
   //* **********************************************************************
   // Public Constructors
   //************************************************************************

   /**
     * Constructs a new instance of an attribute.
     *
     * @param replicaName Name of the replica
     * @param partnName Name of the partition
     * @param netEnv netEnvironment.
     * @param id The attribute's id.
     * @param rpi Reference to the NdsReplicaPointer Object
     * @param rsyi Reference to the NdsReplicaSyncInfo Object
     * @param rsi Reference to the NdsReplicaServer Object
     * @exception NamingException
     */
   public NetReplicaAttribute (
         String replicaName,
         String partnName,
         NetEnvironment netEnv,
         String id,
         NdsReplicaPointer rpi,
         NetReplicaSyncInfo rsyi,
         NetReplicaServerInfo rsi
         )
      throws NamingException
   {
      super (id);
      PartitionFunctions pf = new PartitionFunctions(netEnv);
      if(id.equalsIgnoreCase(NdsPartitionStrings.REPLICA_ATTRID_NAME))
      {
         // Add this value to the attribute
         add(replicaName);
      }
      else if(id.equalsIgnoreCase(NdsPartitionStrings.REPLICA_ATTRID_TYPE))
      {
         // Lower 16 bits are the type
         int type = rpi.getReplicaType() & 0xFFFF;
         add(new NdsInteger(type));
      }
      else if(id.equalsIgnoreCase(NdsPartitionStrings.REPLICA_ATTRID_STATE))
      {
         // Higher 16 bits are the state
         int state = rpi.getReplicaType() & 0xFFFF0000;
         state = state >> 16;
         add(new NdsInteger(state));
      }
      else if(id.equalsIgnoreCase(NdsPartitionStrings.REPLICA_ATTRID_NUMBER))
      {
         add(new NdsInteger(rpi.getReplicaNumber()));
      }
      else if(id.equalsIgnoreCase(
                    NdsPartitionStrings.REPLICA_ATTRID_ADDRESS_HINTS))
      {
         NdsNetAddress[] addrHint = rpi.getReplicaAddressHint();
         for(int i = 0; i < addrHint.length; i++)
         {
            add(addrHint[i]);
         }
      }
      else if(id.equalsIgnoreCase(
                    NdsPartitionStrings.REPLICA_ATTRID_SERVER_READ))
      {
         add(rsi.getServerRead());
      }
      else if(id.equalsIgnoreCase(
                    NdsPartitionStrings.REPLICA_ATTRID_PARTITION_NAME))
      {
         add(partnName);
      }
      else if(id.equalsIgnoreCase(
              NdsPartitionStrings.REPLICA_ATTRID_LAST_SUCCESSFUL_SYNC_TIME))
      {
         add(new NdsInteger(rsyi.getLastSyncTime()));
      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SYNC_ERROR))
      {
         add(new NdsInteger(rsyi.getErrorCode()));
      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_OS_NAME))
//      {
//         add(rsi.getOSName());
//      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_HARDWARE_NAME))
//      {
//         add(rsi.getHardwareName());
//      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_VENDOR_NAME))
//      {
//         add(rsi.getVendorName());
//      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_NAME))
//      {
//         add(rsi.getDirectoryName());
//      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_DIRECTORY_VERSION))
//      {
//         add(rsi.getDirectoryVersion());
//      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_NAME))
      {
         add(rsi.getServerName());
      }
//      else if(id.equalsIgnoreCase(
//                NdsPartitionStrings.REPLICA_ATTRID_SERVER_VERSION))
//      {
//         add(rsi.getServerVersion());
//      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_ADDRESSES))
      {
         Vector v = rsi.getNetAddresses();
         for(int i = 0; i < v.size(); i++)
         {
             add(v.elementAt(i));
         }
      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_SYNC_TIME_UNIT))
      {
         add(new NdsInteger(rsi.getTimeInSync()));
      }
/*      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_LICENSE_ID))
      {
         add(rsi.getLicenseID());
      }
*/
/*      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_PARTITION_LIST))
      {
         Vector v = rsi.getReplicaInfo();
         for(int i = 0; i < v.size(); i++)
         {
             add((NetReplicaInfo)v.elementAt(i));
         }
      }
*/
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_MODIFICATION_TIME))
      {
         add(rsi.getModificationTime());
      }
      else if(id.equalsIgnoreCase(
                NdsPartitionStrings.REPLICA_ATTRID_SERVER_BUSY))
      {
         add(rsi.getBusyState());
      }
      else
         throw new InvalidAttributeIdentifierException(id);
   }
} /* NDSAttribute */



