/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/qms/QMSOutputStream.java $
  $Revision: 11 $
  $Modtime: 10/18/99 2:22p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms;

import java.io.IOException;
import com.novell.java.io.NOutputStream;
import com.novell.java.io.DataAccessable;
import com.novell.java.io.spi.DataAccessor;

/**
 * Provides the standard output stream functionality for NetWare
 * queue jobs. It extends NOutputStream by adding support for the
 * custom parameter data used to create a stream for a queue job.
 *
 * <p>In addition to the conventional output stream functionality
 * (see java.io.OutputStream), the QMSOutputStream class includes an
 * abort() method for closing the queue job.</p> 
 *
 * @see com.novell.java.io.NOutputStream
 */

public class QMSOutputStream
   extends NOutputStream
{
   // Private data members ===================================================
   private QMSAccessor qmsDA;

   // Constructors ===========================================================

   /**
    * @internal
    *
    * Creates and opens an output stream that will write to a NetWare
    * queue job file.
    *
    * <p>Given a NWQueueJob object, QMSOutputStream opens an output
    * stream through the specified Streamable implementation.
    *
    * <p>This constructor is intended for use by the Queue System
    * rather than by applications.
    * <p/>
    *
    * @param opener The Streamable opener that will be called
    *               to open the stream.
    * @param custom NWQueueJob object containing the necessary
    *               information to use as the custom data to the
    *               Streamable.openStream() method.
    *
    * @exception IOException When an I/O error occurs.
    */
   public QMSOutputStream (DataAccessable opener, Object custom)
      throws IOException
   {
      qmsDA = (QMSAccessor) opener.openStream (DataAccessor.WRITE, custom);

      if (qmsDA == null)
         throw new IOException ();

      setDataAccessor (qmsDA);
   }

   // Public methods =========================================================
   /**
    * Aborts a currently open stream.
    *
    * <p>This abort() method extends the NOutputStream interface to
    * allow for aborting streams that have already been opened. This
    * will cancel the job that has been created on this stream.
    * </p>
    *
    * @exception IOException When an error occurs while creating the job.
    */
   public void abort()
      throws IOException
   {
      qmsDA.abort();
   } /* abort() */
} /* class QMSOutputStream */
