/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QMSContextFactory.java $
  $Revision: 7 $
  $Modtime: 12/15/98 10:45a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;


import java.util.*;
import java.lang.Integer;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.utility.naming.Environment;
import com.novell.service.qms.*;
import com.novell.service.session.*;

/** @internal
 */
public class QMSContextFactory implements ObjectFactory
{

   /**
    * @param object              Should be a reference containing <info>.
    * @param environment         Contains properties.
    * @return                    The object created if successful.
    * @exception Exception       On failure.
    */
   public Object getObjectInstance (
         Object object,
         Name name,           //NOTE: name needs to be implemented
         Context nameCtx,     //NOTE: name needs to be implemented
         Hashtable environment)
      throws Exception
   {
      QueueDirContext qdsc;
      QueueJobDirContext qjdsc;

      // Need to make sure we keep track of the right session manager
      SessionManager sm;
      sm = (SessionManager) environment.get (
                                   Environment.SESSION_MANAGER_OBJECT);
      if (null == sm)
      {
         SessionEnv env = new SessionEnv ();
         env.put (SessionEnv.INITIAL_SESSION_FACTORY,
            "com.novell.service.session.nds.NDSInitialSessionFactory:" +
            "com.novell.service.session.bindery.BinderyInitialSessionFactory");
         sm = SessionManagerFactory.getSessionManager (env);
         environment.put (Environment.SESSION_MANAGER_OBJECT, sm);
      }
      Session session;

      if (object instanceof Reference)
      {
         Reference myRef = (Reference) object;

         // Return new QueueAtomicDirContext or QueueJobAtomicDirContext
         StringRefAddr tmpRefAddr;
         String   host,
                  queueName = null,
                  queueType = null,
                  queueID = null,
                  jobID = null;

         host = (String) ((StringRefAddr) myRef.get (Context.PROVIDER_URL)).
                                                   getContent();

         tmpRefAddr = (StringRefAddr) myRef.get (QMSEnvironment.QUEUE_NAME);
         if (null != tmpRefAddr)
            queueName = (String) tmpRefAddr.getContent ();

         tmpRefAddr = (StringRefAddr) myRef.get (QMSEnvironment.QUEUE_TYPE);
         if (null != tmpRefAddr)
            queueType = (String) tmpRefAddr.getContent ();

         tmpRefAddr = (StringRefAddr) myRef.get (QMSEnvironment.QUEUE_ID);
         if (null != tmpRefAddr)
            queueID = (String) tmpRefAddr.getContent ();

         tmpRefAddr = (StringRefAddr) myRef.get (QMSEnvironment.QUEUE_JOB_ID);
         if (null != tmpRefAddr)
            jobID = (String) tmpRefAddr.getContent ();

         if ((null == queueName) && (null == queueID))
            return (null);

         if (null != jobID)             // return a job
         {
            if (null == queueName)      // use queueID
            {
               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                    environment,
                                    session,
                                    Integer.valueOf (queueID).intValue ());

                  // Create a queue job using its job ID
                  qjdsc = new QueueJobDirContext (
                                 qdsc,
                                 Integer.valueOf (jobID).intValue ());
                  return (qjdsc);
               }
               catch (NamingException e)
               {
                  return(null);
               }
            }
            else                          // use queueName and queueType
            {
               if (null == queueType)  // Default to print queue of no type
                  queueType = String.valueOf (QMSQueue.OT_PRINT_QUEUE);

               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                 environment,
                                 session,
                                 queueName,
                                 Integer.valueOf (queueType).intValue ());

                  // Create a queue job using its job ID
                  qjdsc = new QueueJobDirContext (
                                 qdsc,
                                 Integer.valueOf (jobID).intValue ());
                  return (qjdsc);
               }
               catch (NamingException e)
               {
                  return(null);
               }
            }
         }
         else                             // return a queue
         {
            if (null == queueName)      // use queueID
            {
               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                 environment,
                                 session,
                                 Integer.valueOf (queueID).intValue ());
                  return (qdsc);
               }
               catch (NamingException e)
               {
                  return(null);
               }
            }
            else                          // use queueName and queueType
            {
               if (null == queueType)
                  queueType = String.valueOf (QMSQueue.OT_PRINT_QUEUE);

               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                 environment,
                                 session,
                                 queueName,
                                 Integer.valueOf (queueType).intValue ());
                  return (qdsc);
               }
               catch (NamingException e)
               {
                  return (null);
               }
            }
         }
      }

      else if ( object instanceof String) // only valid for finding a job in a queue
      {
         String   host,
                  queueName,
                  queueType,
                  queueID,
                  jobID = (String) object;


         if ((host = (String) environment.get (Context.PROVIDER_URL)) != null)
         {
            queueName   = (String) environment.get (QMSEnvironment.QUEUE_NAME);
            queueType   = (String) environment.get (QMSEnvironment.QUEUE_TYPE);
            queueID     = (String) environment.get (QMSEnvironment.QUEUE_ID);

            if (null == queueName)      // use queueID
            {
               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                 environment,
                                 session,
                                 Integer.valueOf (queueID).intValue ());

                  qjdsc = new QueueJobDirContext (
                                 (QueueDirContext) qdsc,
                                 Integer.valueOf (jobID).intValue ());
                  return (qjdsc);
               }
               catch (NamingException e)
               {
                  return (null);
               }
            }
            else                          // use queueName and queueType
            {
               if (null == queueType)
                  queueType = String.valueOf (QMSQueue.OT_PRINT_QUEUE);

               try
               {
                  session = sm.getSessionTop (host);
                  qdsc = new QueueDirContext (
                                 environment,
                                 session,
                                 queueName,
                                 Integer.valueOf (queueType).intValue ());

                  qjdsc = new QueueJobDirContext (
                                 qdsc,
                                 Integer.valueOf (jobID).intValue ());
                  return (qjdsc);
               }
               catch (NamingException e)
               {
                  return(null);
               }
            }
         }
      }

      return(null);
   } /* getObjectInstance () */
} /* class QMSContextFactory */
