/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/QMSQueueJobAttribute.java $
  $Revision: 2 $
  $Modtime: 4/08/98 11:19a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import com.novell.service.qms.*;

/** @internal
 *  public class QMSQueueJobAttribute
 *    extends Attribute
 */

public class QMSQueueJobAttribute extends BasicAttribute
{

   /*
    * Constructs a new instance of an attribute.
    *
    * @param ID         (in) the ID of the attribute
    * @param job        (in) the job to get the attribute from
    */
   public QMSQueueJobAttribute ( String id, QMSJob job  )
      throws NamingException
   {
      super (id);

      if( id.equals( QMSStrings.QUEUE_JOB_ATTRID_CLIENTSTATION ) )
      {
         // Add this value to the attribute
         add( new Integer( job.getClientStation() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_CLIENTTASK ) )
      {
         add( new Integer( job.getClientTask() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_CLIENTID ) )
      {
         add( new Integer( job.getClientID() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_TARGETSERVERID ) )
      {
         add( new Integer( job.getTargetServerID() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_TARGETEXECUTIONTIME ) )
      {
         add( job.getTargetExecutionTime() );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_ENTRYTIME ) )
      {
         add( job.getEntryTime() );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_ID ) )
      {
         add( new Integer( job.getID() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_TYPE ) )
      {
         add( new Integer( job.getType() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_POSITION ) )
      {
         add( new Integer( job.getPosition() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_CONTROLFLAGS ) )
      {
         add( new Integer( job.getControlFlags() ) );
      }
      else if ( id.equals( QMSStrings.QUEUE_JOB_ATTRID_DESCRIPTION ) )
      {
         add( job.getDescription() );
      }
      else
         throw new InvalidAttributeIdentifierException("Unknown attribute");
   }
} /* QMSQueueJobAttribute */



