/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/qms/naming/ReferenceFactoryImpl.java $
  $Revision: 4 $
  $Modtime: 11/19/98 4:17p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.qms.naming;

import com.novell.utility.naming.URLParser;
import javax.naming.*;
import java.util.*;

/** @internal
*  Implements the ReferenceFactory interface to construct a reference
*  for a QueueDirContext
*/
public class ReferenceFactoryImpl
implements com.novell.utility.naming.spi.ReferenceFactory
{
   /**
   * Uses Context.PROVIDER_URL to construct reference.
   */
   public Reference createReference(
         Hashtable props)
      throws NamingException
   {
      Reference ret = null;
      String   serverName,
               queueName,
               queueType,
               queueID,
               jobID;

		String url = (String)props.get(Context.PROVIDER_URL);
		serverName = new URLParser (url).getHost ();
      if (serverName != null)
      {
         StringRefAddr refAddr =
            new StringRefAddr(Context.PROVIDER_URL, serverName);

         queueName = (String) props.get( QMSEnvironment.QUEUE_NAME );
         queueType = (String) props.get( QMSEnvironment.QUEUE_TYPE );
         queueID = (String) props.get( QMSEnvironment.QUEUE_ID );
         jobID = (String) props.get(QMSEnvironment.QUEUE_JOB_ID);

         // We must have one of these to determine which queue we want
         if ( (null == queueName) && (null == queueID) )
            return( ret );

         // check to see if we are talking about a job or a queue
         if ( null == jobID )          // create a QueueDirContext
            ret = new Reference(
               QMSStrings.QUEUE_DSCONTEXT_FULLNAME,
               refAddr,
               QMSStrings.QUEUE_OBJECTFACTORY_FULLNAME,
               "");
         else                          // create a JobDirContext
         {
            ret = new Reference(
               QMSStrings.QUEUE_JOB_DSCONTEXT_FULLNAME,
               refAddr,
               QMSStrings.QUEUE_OBJECTFACTORY_FULLNAME,
               "");
            ret.add(new StringRefAddr( QMSEnvironment.QUEUE_JOB_ID, jobID ) );
         }

         if ( null != queueID )
            ret.add( new StringRefAddr( QMSEnvironment.QUEUE_ID, queueID ) );
         else // since we already tested this above, we must have the name
         {
            ret.add( new StringRefAddr( QMSEnvironment.QUEUE_NAME, queueName ) );
            if ( null != queueType)
               ret.add( new StringRefAddr( QMSEnvironment.QUEUE_TYPE, queueType ) );
         }
      }
      return ret;
   }
}
