/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/schema/SchemaValue.java $
  $Revision: 3 $
  $Modtime: 4/08/98 2:04p $
 
  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

*****************************************************************************/

package com.novell.service.schema;

//##begin module.additionalImports preserve=no
//##end module.additionalImports

//##begin module.imports preserve=yes
//##end module.imports



// ==================================================================

//##begin module.declarations preserve=no
//##end module.declarations

//##begin module.additionalDeclarations preserve=yes
//##end module.additionalDeclarations

/** @internal
The SchemaValue interface associates a 'Syntax Id', a 'Name', and
a 'Value'.  This interface defines access methods for the 'Syntax
Id' and the 'Name'.
*/
public interface SchemaValue {
    //##begin SchemaValue.initialDeclarations preserve=yes
    //##end SchemaValue.initialDeclarations


    /**
    Compares this SchemaValue with the parameter anObject.

    @param   anotherSchemaValue   the SchemaValue to be compared.
    @return
    the 0 if the argument is equal to this value; a integer less than
    0 if this value is less than the argument; and a number greater than
    0 if this value is greater than the argument.
    */
    public int compareTo(Object anObject)throws Exception
;

    /**
    Compares this object to the specified object.
    The result is true if and only if the argument is not null and is
    an SchemaString object that contains the same value as this object.

    @param
    object   the object to compare with.
    @return  true if the objects are the same; false otherwise.
    */
    public boolean equals(Object anObject);

    public String getName();

    /**
    Returns the provider specific string that identifies this syntax.

    @return
    string value representing syntax.
    */
    public String getSyntaxId();

    //##begin SchemaValue.additionalDeclarations preserve=yes
    //##end SchemaValue.additionalDeclarations

}

