/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerDiagnosticsImpl.java $
  $Revision: 11 $
  $Modtime: 1/28/00 12:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import javax.naming.*;
import javax.naming.directory.*;
import com.novell.service.jncp.*;
import com.novell.service.session.*;
import com.novell.service.session.xplat.*;
import com.novell.service.rfc1960.SearchStringComponent;

/**
* Provides the Attribute value of an attribute of a ServerDirContext.
*
* @see ServerDiagnostics
*/
public class ServerDiagnosticsImpl implements
com.novell.utility.naming.directory.StaticAttributeValue,
com.novell.service.server.ServerDiagnostics
{
   private int serverUpTime;
   private int currentCPUUtilization;
   private int replyCanceledCount;
   private int writeHeldOffCount;
   private int writeHeldOffWithDupRequest;
   private int invalidRequestTypeCount;
   private int beingAbortedCount;
   private int alreadyDoingReallocCount;
   private int deAllocInvalidSlotCount;
   private int deAllocBeingProcessedCount;
   private int deAllocForgedPacketCount;
   private int deAllocStillTransmittingCount;
   private int startStationErrorCount;
   private int invalidSlotCount;
   private int beingProcessedCount;
   private int forgedPacketCount;
   private int stillTransmittingCount;
   private int reExecuteRequestCount;
   private int invalidSequenceNumCount;
   private int duplicateIsBeingSentAlreadyCount;
   private int sentPositiveAcknowledgeCount;
   private int sentDuplicateReplyCount;
   private int noMemForStationCtrlCount;
   private int noAvailableConnsCount;
   private int reallocSlotCount;
   private int reallocSlotCameTooSoonCount;
   private short tooManyHops;
   private short unknownNetwork;
   private short noSpaceForService;
   private short noReceiveBuffers;
   private short notMyNetwork;
   private int netBIOSProgatedCount;
   private int totalPacketsServiced;
   private int totalPacketsRouted;
   private boolean empty = true;
   private Session session;

   /**
   * Constructs a ServerDiagnosticsImpl attribute value. This
   * constructor is used to manually create attributes for methods
   * such as search()
   */
   public ServerDiagnosticsImpl()
   {
   }

   /** @internal
   * Constructs this attribute value and stores the session to the server.
   * This constructor is for use by ServerDirContext
   * @param session The session to the server this attribute is for.
   */
   protected ServerDiagnosticsImpl(
         Session session)
   {
      this.session = session;
   }

  /**
   * Returns the time in ticks (about 1/18 second) since the server
   * was started. When ServerUpTime reaches 0xFFFFFFFF, it wraps
   * to 0.
   *
   * @return The time since the server was started.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getServerUpTime() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return serverUpTime;
   }

  /**
   * Returns the current percentage of CPU utilization for the server.
   *
   * @return Current CPU utilization.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getCurrentCPUUtilization() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return currentCPUUtilization;
   }

  /**
   * Returns the number of replies that were canceled because the
   * connection was reallocated while the request was being processed. 
   *
   * @return The number of canceled replies.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getReplyCanceledCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return replyCanceledCount;
   }

  /**
   * Returns the number of times that writes were delayed because of
   * a pending TTS(tm) transaction or cache busy condition.
   *
   * @return The number of times write delays occurred.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getWriteHeldOffCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return writeHeldOffCount;
   }

  /**
   * Returns the number of times that writes were canceled since a
   * duplicate request was received.
   *
   * @return The number of times writes were canceled.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getWriteHeldOffWithDupRequest() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return writeHeldOffWithDupRequest;
   }

  /**
   * Returns the number of packets received which had an invalid request
   * type or were received after the server was shut down.
   *
   * @return The number of invalid request type packets received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getInvalidRequestTypeCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return invalidRequestTypeCount;
   }

  /**
   * Returns the number of packets received for a connection being
   * terminated.
   *
   * @return The number of packets received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getBeingAbortedCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return beingAbortedCount;
   }

  /**
   * Returns the number of times a connection is requested when
   * a connection already exists.
   *
   * @return The number of times a connection is requested.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getAlreadyDoingReallocCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return alreadyDoingReallocCount;
   }

  /**
   * Returns the number of times an attempt was made to deallocate a
   * connection slot that was not valid.
   *
   * @return The number of attempts made to deallocate a connection
   *         slot.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getDeAllocInvalidSlotCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return deAllocInvalidSlotCount;
   }

  /**
   * Returns the number of times the server was deallocated because
   * requests were still being processed.
   *
   * @return The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getDeAllocBeingProcessedCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return deAllocBeingProcessedCount;
   }

  /**
   * Returns the number of times the server was deallocated because a
   * forged packet was received.
   *
   * @return The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getDeAllocForgedPacketCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return deAllocForgedPacketCount;
   }

  /**
   * Returns the number of times the server was deallocated because
   * information was still being transmitted.
   *
   * @return The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getDeAllocStillTransmittingCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return deAllocStillTransmittingCount;
   }

  /**
   * Returns the number of times the server was unable to allocate
   * a connection for any reason. 
   *
   * @return The number of times the server was unable to allocate
   *         a connection.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getStartStationErrorCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return startStationErrorCount;
   }

  /**
   * Returns the number of requests received for an invalid connection
   * slot.
   *
   * @return The number of requests received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getInvalidSlotCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return invalidSlotCount;
   }

  /**
   * Returns the number of times a duplicate request was received
   * during processing of the first request.
   *
   * @return The number of times a duplicate request was received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getBeingProcessedCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return beingProcessedCount;
   }

  /**
   * Returns the number of suspicious invalid packets received.
   *
   * @return The number of suspicious invalid packets received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getForgedPacketCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return forgedPacketCount;
   }

  /**
   * Returns the number of times a new request is received before
   * a reply to a previous request has been sent.
   *
   * @return The number of times a new request is received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getStillTransmittingCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return stillTransmittingCount;
   }

  /**
   * Returns the number of times the requester did not receive the reply
   * and the request had to be reprocessed. 
   *
   * @return The number of times the requester did not receive the reply.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getReExecuteRequestCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return reExecuteRequestCount;
   }

  /**
   * Returns the number of request packets the server received from
   * a connection where the sequence number in the packet did not
   * match the current sequence number or the next sequence number. 
   *
   * @return The number of invalid sequence number packets.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getInvalidSequenceNumCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return invalidSequenceNumCount;
   }

  /**
   * Returns the number of times a duplicate reply was requested when
   * the reply had already been sent.
   *
   * @return The number of times a duplicate reply was requested.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getDuplicateIsBeingSentAlreadyCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return duplicateIsBeingSentAlreadyCount;
   }

  /**
   * Returns the number of acknowledgments sent by the server (sent
   * when a connection repeats a request being serviced).
   *
   * @return The number of acknowledgments sent by the server.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getSentPositiveAcknowledgeCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return sentPositiveAcknowledgeCount;
   }

  /**
   * Returns the number of request packets for which the server had
   * to send a duplicate reply (sent only for requests the server
   * cannot process). 
   *
   * @return The number of request packets for which the server had
   * to send a duplicate reply.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getSentDuplicateReplyCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return sentDuplicateReplyCount;
   }

  /**
   * Returns the number of times the server could not allocate
   * memory to expand the connection table for a new connection. 
   *
   * @return The number of times the server could not allocate
   *         memory.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getNoMemForStationCtrlCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return noMemForStationCtrlCount;
   }

  /**
   * Returns the number of times no slots were available in the
   * connection table for a new connection. 
   *
   * @return The number of times no slots were available.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getNoAvailableConnsCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return noAvailableConnsCount;
   }

  /**
   * Returns the number of times the server reallocated the same
   * slot in the connection table for a client that logged out and
   * relogged in. 
   *
   * @return The number of times the server reallocated the same
   * slot in the connection table.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getReallocSlotCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return reallocSlotCount;
   }

  /**
   * Returns the number of times that a request came from a client
   * to relog in before that client had been completely logged out.
   *
   * @return The number of times that a request came from a client
   * to relog in.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getReallocSlotCameTooSoonCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return reallocSlotCameTooSoonCount;
   }

  /**
   * Returns the number of packets discarded because they had passed
   * through more than 16 bridges without reaching their destination. 
   *
   * @return The number of packets discarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public short getTooManyHops() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return tooManyHops;
   }

  /**
   * Returns the number of packets discarded because their destination
   * network was unknown to the server. 
   *
   * @return The number of packets discarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public short getUnknownNetwork() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return unknownNetwork;
   }

  /**
   * Reserved (pass 0).
   *
   * @return Zero (0).
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public short getNoSpaceForService() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return noSpaceForService;
   }

  /**
   * Returns the number of times a packet was discarded because no
   * buffers existed to receive it.
   *
   * @return The number of times a packet was discarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public short getNoReceiveBuffers() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return noReceiveBuffers;
   }

  /**
   * Returns the number of received packets not destined for
   * the server. 
   *
   * @return The number of received packets.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public short getNotMyNetwork() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return notMyNetwork;
   }

  /**
   * Returns the number of NetBIOS packets received that were
   * sent forward. 
   *
   * @return The number of NetBIOS packets received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getNetBIOSProgatedCount() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return netBIOSProgatedCount;
   }

  /**
   * Returns the total packets received by the server.
   *
   * @return The total packets received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getTotalPacketsServiced() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return totalPacketsServiced;
   }

  /**
   * Returns the number of all packets forwarded by the server.
   *
   * @return The number of all packets forwarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public int getTotalPacketsRouted() throws NSIException
   {
      if(empty)
         getFileServerInfo();
      return totalPacketsRouted;
   }

  /**
   * Sets as the search value the time in ticks (about 1/18 second)
   * since the server was started. This is used to search for
   * all servers matching the upTime parameter. 
   *
   * @param upTime The time since the server was started. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setServerUpTime(
         int upTime)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      serverUpTime = upTime;
   }

  /**
   * Sets as the search value the current percentage of CPU
   * utilization for the server. This is used to search for
   * all servers matching the upTime parameter.
   *
   * @param utilization The current percentage of CPU utilization
   *                    for the server.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setCurrentCPUUtilization(
         int utilization)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      currentCPUUtilization = utilization;
   }

  /**
   * Sets as the search value the number of replies that were
   * canceled because the connection was reallocated while the
   * request was being processed. This is used to search for
   * all servers matching the value parameter.
   *
   * @param value The number of canceled replies. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setReplyCanceledCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      replyCanceledCount = value;
   }

  /**
   * Sets as the search value the number of times that writes were
   * delayed because of a pending TTS(tm) transaction or cache busy
   * condition. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value the number of times that writes were delayed.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setWriteHeldOffCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      writeHeldOffCount = value;
   }

  /**
   * Sets as the search value the number of times that writes were
   * canceled since a duplicate request was received. This is used
   * to search for all servers matching the value parameter.
   *
   * @param value The number of times that writes were canceled.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setWriteHeldOffWithDupRequest(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      writeHeldOffWithDupRequest = value;
   }

  /**
   * Sets as the search value the number of packets received that
   * had an invalid request type or were received after the server
   * was shut down. This is used to search for all servers matching
   * the value parameter.
   *
   * @param value The number of packets received. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setInvalidRequestTypeCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      invalidRequestTypeCount = value;
   }

  /**
   * Sets as the search value the number of packets received for
   * a connection being terminated. This is used to search for all
   * servers matching the value parameter. 
   *
   * @param value The number of packets received. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setBeingAbortedCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      beingAbortedCount = value;
   }

  /**
   * Sets as the search value the number of times that a connection
   * is requested when a connection already exists. This is used to
   * search for all servers matching the value parameter. 
   *
   * @param value The number of times a connection is requested.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setAlreadyDoingReallocCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      alreadyDoingReallocCount = value;
   }

  /**
   * Sets as the search value the number of times an attempt was
   * made to deallocate a connection slot that was not valid. This
   * is used to search for all servers matching the value parameter.
   *
   * @param value The number of times an attempt was made to
   *              deallocate a connection slot.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setDeAllocInvalidSlotCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      deAllocInvalidSlotCount = value;
   }

  /**
   * Sets as the search value the number of times the server was
   * deallocated because requests were still being processed. This
   * is used to search for all servers matching the value parameter. 
   *
   * @param value The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setDeAllocBeingProcessedCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      deAllocBeingProcessedCount = value;
   }

  /**
   * Sets as the search value the number of times the server was
   * deallocated because a forged packet was received. This is used
   * to search for all servers matching the value parameter. 
   *
   * @param value The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setDeAllocForgedPacketCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      deAllocForgedPacketCount = value;
   }

  /**
   * Sets as the search value the number of times the server was
   * deallocated because information was still being transmitted.
   * This is used to search for all servers matching the value
   * parameter. 
   *
   * @param value The number of times the server was deallocated.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setDeAllocStillTransmittingCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      deAllocStillTransmittingCount = value;
   }

  /**
   * Sets as the search value the number of times the server was
   * unable to allocate a connection for any reason. This is used
   * to search for all servers matching the value parameter. 
   *
   * @param value The number of times the server was unable to
   *              allocate a connection.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setStartStationErrorCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      startStationErrorCount = value;
   }

  /**
   * Sets as the search value the number of requests received
   * for an invalid connection slot. This is used to search for
   * all servers matching the value parameter. 
   *
   * @param value The number of requests received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setInvalidSlotCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      invalidSlotCount = value;
   }

  /**
   * Sets as the search value the number of times a duplicate request
   * was received during processing of the first request. This is used
   * to search for all servers matching the value parameter.
   *
   * @param value The number of times a duplicate request was received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setBeingProcessedCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      beingProcessedCount = value;
   }

  /**
   * Sets as the search value the number of suspicious invalid
   * packets received. This is used to search for all servers
   * matching the value parameter. 
   *
   * @param value The number of suspicious invalid packets received. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setForgedPacketCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      forgedPacketCount = value;
   }

  /**
   * Sets as the search value the number of times a new request is
   * received before a reply to a previous request has been sent.
   * This is used to search for all servers matching the value parameter. 
   *
   * @param value The number of times a new request is received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setStillTransmittingCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      stillTransmittingCount = value;
   }

  /**
   * Sets as the search value the number of times the requester did
   * not receive the reply and the request had to be reprocessed.
   * This is used to search for all servers matching the value parameter. 
   *
   * @param value The number of times the requester did not receive
   *              the reply.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setReExecuteRequestCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      reExecuteRequestCount = value;
   }

  /**
   * Sets as the search value the number of request packets the server
   * received from a connection where the sequence number in the packet
   * did not match the current or the next sequence number. This is
   * used to search for all servers matching the value parameter.  
   *
   * @param value The number of request packets the server received.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setInvalidSequenceNumCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      invalidSequenceNumCount = value;
   }

  /**
   * Sets as the search value the number of times a duplicate reply
   * was requested when the reply had already been sent. This is
   * used to search for all servers matching the value parameter.
   *
   * @param value The number of times a duplicate reply was
   *              requested. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setDuplicateIsBeingSentAlreadyCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      duplicateIsBeingSentAlreadyCount = value;
   }

  /**
   * Sets as the search value the number of acknowledgments sent
   * by the server (sent when a connection repeats a request being
   * serviced). This is used to search for all servers matching
   * the value parameter.
   *
   * @param value The number of acknowledgments sent by the server.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setSentPositiveAcknowledgeCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      sentPositiveAcknowledgeCount = value;
   }

  /**
   * Sets as the search value the number of request packets for
   * which the server had to send a duplicate reply (sent only
   * for requests the server cannot process). This is used to
   * search for all servers matching the value parameter.
   *
   * @param value The number of request packets.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setSentDuplicateReplyCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      sentDuplicateReplyCount = value;
   }

  /**
   * Sets as the search value the number of times the server could
   * not allocate memory to expand the connection table for a new
   * connection. This is used to search for all servers matching
   * the value parameter.
   *
   * @param value The number of times the server could not allocate
   *              memory.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNoMemForStationCtrlCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      noMemForStationCtrlCount = value;
   }

  /**
   * Sets as the search value the number of times no slots were
   * available in the connection table for a new connection. This
   * is used to search for all servers matching the value parameter. 
   *
   * @param value The number of times no slots were available in the
   *              connection table for a new connection. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNoAvailableConnsCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      noAvailableConnsCount = value;
   }

  /**
   * Sets as the search value the number of times the server
   * reallocated the same slot in the connection table for a client
   * that logged out and relogged in. This is used to search for
   * all servers matching the value parameter. 
   *
   * @param value The number of times the server reallocated the
   *              same slot.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setReallocSlotCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      reallocSlotCount = value;
   }

  /**
   * Sets as the search value the number of times that a request
   * came from a client to relog in before that client had been
   * completely logged out. This is used to search for all servers
   * matching the value parameter.
   *
   * @param value The number of times that a request came from a
   *              client to relog in.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setReallocSlotCameTooSoonCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      reallocSlotCameTooSoonCount = value;
   }

  /**
   * Sets as the search value the number of packets discarded because
   * they had passed through more than 16 bridges without reaching
   * their destination. This is used to search for all servers
   * matching the value parameter. 
   *
   * @param value The number of packets discarded. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setTooManyHops(
         short value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      tooManyHops = value;
   }

  /**
   * Sets as the search value the number of packets discarded
   * because their destination network was unknown to the server.
   * This is used to search for all servers matching the value
   * parameter. 
   *
   * @param value The number of packets discarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setUnknownNetwork(
         short value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      unknownNetwork = value;
   }

  /**
   * Sets as the search value zero (0)because it is reserved. 
   *
   * @param value Zero because it is reserved. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNoSpaceForService(
         short value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      noSpaceForService = value;
   }

  /**
   * Sets as the search value the number of times a packet was
   * discarded because no buffers existed to receive it. This is
   * used to search for all servers matching the value parameter. 
   *
   * @param value The number of times a packet was discarded.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNoReceiveBuffers(
         short value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      noReceiveBuffers = value;
   }

  /**
   * Sets as the search value the number of received packets not
   * destined for the server. This is used to search for all
   * servers matching the value parameter.
   *
   * @param value The number of received packets.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNotMyNetwork(
         short value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      notMyNetwork = value;
   }

  /**
   * Sets as the search value the number of NetBIOS packets
   * received that were sent forward. This is used to search for
   * all servers matching the value parameter.
   *
   * @param value The number of NetBIOS packets received. 
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setNetBIOSProgatedCount(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      netBIOSProgatedCount = value;
   }

  /**
   * Sets as the search value the total packets received by the
   * server. This is used to search for all servers matching the
   * value parameter.
   *
   * @param value The total packets received by the server.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setTotalPacketsServiced(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      totalPacketsServiced = value;
   }

  /**
   * Sets as the search value the number of all packets forwarded
   * by the server. This is used to search for all servers matching
   * the value parameter.
   *
   * @param value The number of all packets forwarded by the server.
   *
   * @exception NSIException  When an error occurs retrieving the 
   *                          information.
   */
   public void setTotalPacketsRouted(
         int value)
      throws NSIException
   {
      if(empty)
         getFileServerInfo();
      totalPacketsRouted = value;
   }

   /**
   * Get service from the session and fill in the instance values
   */
   private void getFileServerInfo () throws NSIException
   {
      empty = false;
      //only call if valid session. This allows users to new()
      // instances of this class for search()
      if(session == null)
         return;
      CNWFSEFileServerInfo info = new CNWFSEFileServerInfo();
      try
      {
         ((CallsService)session.getService(
            CallsService.KEY)).getFileServerInfo(info);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }

      serverUpTime = info.serverUpTime;
      currentCPUUtilization = info.serverCPUUtilization;
      replyCanceledCount = info.replyCanceledCount;
      writeHeldOffCount = info.writeHeldOffCount;
      writeHeldOffWithDupRequest = info.writeHeldOffWithDupRequest;
      invalidRequestTypeCount = info.invalidRequestTypeCount;
      beingAbortedCount = info.beingAbortedCount;
      alreadyDoingReallocCount = info.alreadyDoingReallocCount;
      deAllocInvalidSlotCount = info.deAllocInvalidSlotCount;
      deAllocBeingProcessedCount = info.deAllocBeingProcessedCount;
      deAllocForgedPacketCount = info.deAllocForgedPacketCount;
      deAllocStillTransmittingCount = info.deAllocStillTransmittingCount;
      startStationErrorCount = info.startStationErrorCount;
      invalidSlotCount = info.invalidSlotCount;
      beingProcessedCount = info.beingProcessedCount;
      forgedPacketCount = info.forgedPacketCount;
      stillTransmittingCount = info.stillTransmittingCount;
      reExecuteRequestCount = info.reExecuteRequestCount;
      invalidSequenceNumCount = info.invalidSequenceNumCount;
      duplicateIsBeingSentAlreadyCount = info.duplicateIsBeingSentAlreadyCount;
      sentPositiveAcknowledgeCount = info.sentPositiveAcknowledgeCount;
      sentDuplicateReplyCount = info.sentDuplicateReplyCount;
      noMemForStationCtrlCount = info.noMemForStationCtrlCount;
      noAvailableConnsCount = info.noAvailableConnsCount;
      reallocSlotCount = info.reallocSlotCount;
      reallocSlotCameTooSoonCount = info.reallocSlotCameTooSoonCount;
      tooManyHops = (short)info.tooManyHops;
      unknownNetwork = (short)info.unknownNetwork;
      noSpaceForService = (short)info.noSpaceForService;
      noReceiveBuffers = (short)info.noReceiveBuffers;
      notMyNetwork = (short)info.notMyNetwork;
      netBIOSProgatedCount = info.netBIOSProgatedCount;
      totalPacketsServiced = info.totalPacketsServiced;
      totalPacketsRouted = info.totalPacketsRouted;
   }

   /** @internal
   */   
   public Attribute buildAttribute() throws NamingException
   {
      return new BasicAttribute(ATTR_ID, this);
   }

   /** @internal
   */   
   public String getID()
   {
      return ATTR_ID;
   }

   /** @internal
   */   
   public boolean compare(
         SearchStringComponent ssc)
      throws NamingException
   {
      int opType = ssc.getOperationType();
      if(opType == SearchStringComponent.PRESENT)
         return true;
      if(opType == SearchStringComponent.EQUALS)
         return equals(ssc.getReplacementObject());
      return false;
   }

   /** @internal
   */   
   public boolean equals(
         Object compObject)
   {
      if(compObject== null || !(compObject instanceof ServerDiagnosticsImpl) )
         return false;
      ServerDiagnosticsImpl obj = (ServerDiagnosticsImpl)compObject;
      if(obj == this)
         return true;
      try
      {
         if(empty)
            getFileServerInfo();
         if(replyCanceledCount == obj.getReplyCanceledCount() &&
            writeHeldOffCount == obj.getWriteHeldOffCount() &&
            writeHeldOffWithDupRequest ==
               obj.getWriteHeldOffWithDupRequest() &&
            invalidRequestTypeCount == obj.getInvalidRequestTypeCount() &&
            beingAbortedCount == obj.getBeingAbortedCount() &&
            alreadyDoingReallocCount == obj.getAlreadyDoingReallocCount() &&
            deAllocInvalidSlotCount == obj.getDeAllocInvalidSlotCount() &&
            deAllocBeingProcessedCount ==
               obj.getDeAllocBeingProcessedCount() &&
            deAllocForgedPacketCount == obj.getDeAllocForgedPacketCount() &&
            deAllocStillTransmittingCount ==
               obj.getDeAllocStillTransmittingCount() &&
            startStationErrorCount == obj.getStartStationErrorCount() &&
            invalidSlotCount == obj.getInvalidSlotCount() &&
            beingProcessedCount == obj.getBeingProcessedCount() &&
            forgedPacketCount == obj.getForgedPacketCount() &&
            stillTransmittingCount == obj.getStillTransmittingCount() &&
            reExecuteRequestCount == obj.getReExecuteRequestCount() &&
            invalidSequenceNumCount == obj.getInvalidSequenceNumCount() &&
            duplicateIsBeingSentAlreadyCount ==
               obj.getDuplicateIsBeingSentAlreadyCount() &&
            sentPositiveAcknowledgeCount ==
               obj.getSentPositiveAcknowledgeCount() &&
            sentDuplicateReplyCount == obj.getSentDuplicateReplyCount() &&
            noMemForStationCtrlCount == obj.getNoMemForStationCtrlCount() &&
            noAvailableConnsCount == obj.getNoAvailableConnsCount() &&
            reallocSlotCount == obj.getReallocSlotCount() &&
            reallocSlotCameTooSoonCount ==
               obj.getReallocSlotCameTooSoonCount() &&
            tooManyHops == obj.getTooManyHops() &&
            unknownNetwork == obj.getUnknownNetwork() &&
            noSpaceForService == obj.getNoSpaceForService() &&
            noReceiveBuffers == obj.getNoReceiveBuffers() &&
            notMyNetwork == obj.getNotMyNetwork() &&
            netBIOSProgatedCount == obj.getNetBIOSProgatedCount() &&
            totalPacketsServiced == obj.getTotalPacketsServiced() &&
            totalPacketsRouted == obj.getTotalPacketsRouted() )
         {
            return true;
         }
         return false;
      }
      catch(NSIException e)
      {
         return false;
      }
   }

   // Server does not support modifying attributes
   // so all of the following methods are not supported.
   /** @internal
   */   
   public void addAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void deleteAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void modifyAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public boolean hasMoreElements()
   {
      return false;
   }

   /** @internal
   */   
   public Object nextElement()
   {
      throw new java.util.NoSuchElementException();
   }

   /** @internal
   */   
   public Object getStaticInterface()
   {
      return this;
   }
}
